/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.machine.low.TileEntityPump;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityCompressor
extends TileEntityBasicElectricMachine {
    public TileEntityPump[] connectingPumps = new TileEntityPump[6];
    public IMachineRecipeList.RecipeEntry entry;

    public TileEntityCompressor() {
        super(3, 2, 400, 32);
    }

    @Override
    public MachineType getType() {
        return MachineType.compressed;
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.compressor;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.CompressorGui.class;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return Ic2Resources.compressor;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.compressor;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        IMachineRecipeList.RecipeEntry entry;
        IMachineRecipeList.RecipeEntry recipeEntry = entry = input.func_190926_b() ? null : ClassicRecipes.compressor.getRecipeInAndOutput(input, false);
        if (entry == null && this.getValidPump() != null) {
            return this.getEntry();
        }
        return entry;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1.func_190926_b()) {
            return false;
        }
        if (ClassicRecipes.compressor.getRecipeInAndOutput(par1, true) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    @Override
    public void operateOnce(IRecipeInput input, MachineOutput output, List<ItemStack> list) {
        if (output instanceof SnowballOutput) {
            TileEntityPump pump = this.getValidPump();
            if (pump == null) {
                return;
            }
            pump.getFluidBelow(true);
            pump.usePump();
            for (ItemStack stack : output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData())) {
                list.add(stack.func_77946_l());
            }
            return;
        }
        super.operateOnce(input, output, list);
    }

    @Override
    public boolean canWorkWithoutItems() {
        return true;
    }

    @Override
    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.compressorOp;
    }

    @Override
    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    public TileEntityPump getValidPump() {
        for (Direction dir : Direction.directions) {
            TileEntityPump pump = this.connectingPumps[dir.toSideValue()];
            if (pump == null) continue;
            if (pump.func_145837_r()) {
                this.connectingPumps[dir.toSideValue()] = null;
                continue;
            }
            if (!pump.isPumpReady() || !pump.isFluidBelow(FluidRegistry.WATER)) continue;
            return pump;
        }
        return null;
    }

    private void updatePumps() {
        for (Direction dir : Direction.directions) {
            TileEntity tile = dir.applyToTileEntity(this);
            this.connectingPumps[dir.toSideValue()] = tile == null || !(tile instanceof TileEntityPump) ? null : (TileEntityPump)tile;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.updatePumps();
        }
        super.func_73660_a();
    }

    public IMachineRecipeList.RecipeEntry getEntry() {
        if (this.entry == null) {
            this.entry = new IMachineRecipeList.RecipeEntry(new CompressorRecipeInput(this), new SnowballOutput(), "snow");
        }
        return this.entry;
    }

    public static void init() {
        TileEntityCompressor.addRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150322_A), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack((Block)Blocks.field_150354_m, 1, 1), new ItemStack(Blocks.field_180395_cM), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack(Blocks.field_150424_aL, 3), new ItemStack(Blocks.field_150385_bj), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack(Items.field_151126_ay), new ItemStack(Blocks.field_150432_aD), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack(Blocks.field_150432_aD, 3), new ItemStack(Blocks.field_150403_cj), 0.1f);
        TileEntityCompressor.addRecipe(new ItemStack(Items.field_151065_br, 5), new ItemStack(Items.field_151072_bj), 0.5f);
        TileEntityCompressor.addRecipe(new RecipeInputFluid(FluidRegistry.WATER), new ItemStack(Items.field_151126_ay), 0.1f);
        TileEntityCompressor.addRecipe("dropUranium", 1, Ic2Items.uraniumIngot.func_77946_l(), 0.3f);
        TileEntityCompressor.addRecipe("ingotCopper", 8, Ic2Items.denseCopperPlate.func_77946_l());
        TileEntityCompressor.addRecipe(Ic2Items.plantBall.func_77946_l(), Ic2Items.compressedPlantBall.func_77946_l(), 0.2f);
        TileEntityCompressor.addRecipe(Ic2Items.hydratedCoalDust.func_77946_l(), Ic2Items.hydratedCoalClump.func_77946_l(), 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.hydratedCharCoalDust.func_77946_l(), Ic2Items.hydratedCoalClump.func_77946_l(), 0.05f);
        TileEntityCompressor.addRecipe(Ic2Items.emptyCell.func_77946_l(), Ic2Items.airCell.func_77946_l(), 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.bioBall.func_77946_l(), Ic2Items.bioCompressedBall.func_77946_l(), 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.machine.func_77946_l(), StackUtil.copyWithSize(Ic2Items.miningPipe, 10));
        TileEntityCompressor.addRecipe(Ic2Items.rareEarthChunk, Ic2Items.deadMagnet, 0.1f);
        TileEntityCompressor.addRecipe(Ic2Items.carbonMesh.func_77946_l(), Ic2Items.carbonPlate.func_77946_l(), 0.3f);
        TileEntityCompressor.addRecipe(Ic2Items.coalBall.func_77946_l(), Ic2Items.compressedCoalBall.func_77946_l(), 0.2f);
        TileEntityCompressor.addRecipe(Ic2Items.coalChunk.func_77946_l(), Ic2Items.industrialDiamond.func_77946_l(), 1.0f);
        TileEntityCompressor.addRecipe(StackUtil.copyWithSize(Ic2Items.scrapMetal, 8), Ic2Items.scrapMetalChunk.func_77946_l(), 0.5f);
        TileEntityCompressor.addRecipe(Ic2Items.rawObsidianBlade.func_77946_l(), Ic2Items.obsidianBlade.func_77946_l(), 0.3f);
        TileEntityCompressor.addRecipe(Ic2Items.mixedMetalIngot.func_77946_l(), Ic2Items.advancedAlloy.func_77946_l(), 0.3f);
        TileEntityCompressor.addRecipe(Ic2Items.constructionFoam.func_77946_l(), Ic2Items.constructionFoamPellet.func_77946_l(), 0.1f);
        ItemStack healing = PotionUtils.func_185184_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), Arrays.asList(new PotionEffect(MobEffects.field_76428_l, 900, 4), new PotionEffect(MobEffects.field_76438_s, 600, 2), new PotionEffect(MobEffects.field_76431_k, 400, 4)));
        healing.func_151001_c(TextFormatting.RESET + "" + TextFormatting.AQUA + "High Quality Hemp Oil");
        TileEntityCompressor.addRecipe(StackUtil.copyWithSize(Ic2Items.hempSeeds, 64), healing);
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input), output);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input, stacksize), output);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output) {
        TileEntityCompressor.addRecipe(new RecipeInputOreDict(input, stacksize), output);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input), output, exp);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, float exp) {
        TileEntityCompressor.addRecipe(new RecipeInputItemStack(input, stacksize), output, exp);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, float exp) {
        TileEntityCompressor.addRecipe(new RecipeInputOreDict(input, stacksize), output, exp);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output) {
        TileEntityCompressor.addRecipe(input, output, 0.0f);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, float exp) {
        ClassicRecipes.compressor.addRecipe(input, output, exp, TileEntityCompressor.makeString(output));
    }

    private static String makeString(ItemStack stack) {
        return stack.func_82833_r();
    }

    public static class CompressorRecipeInput
    implements INullableRecipeInput {
        IRecipeInput input = new RecipeInputFluid(FluidRegistry.WATER);
        TileEntityCompressor comp;

        public CompressorRecipeInput(TileEntityCompressor recipe) {
            this.comp = recipe;
        }

        @Override
        public boolean matches(ItemStack subject) {
            return subject.func_190926_b() && this.comp.getValidPump() != null;
        }

        @Override
        public int getAmount() {
            return 0;
        }

        @Override
        public List<ItemStack> getInputs() {
            return this.input.getInputs();
        }
    }

    public static final class SnowballOutput
    extends MachineOutput {
        public SnowballOutput() {
            super(null, new ItemStack(Items.field_151126_ay));
        }

        @Override
        public MachineOutput copy() {
            return new SnowballOutput();
        }

        @Override
        public boolean canOverride() {
            return false;
        }
    }
}

