/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.crops.ICropSeed;
import ic2.api.energy.EnergyNet;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.low.container.ContainerCropAnalyzer;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityCropAnalyzer
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
IOutputMachine {
    public static final int[] energyNeeded = new int[]{1, 9, 90, 900};
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit16)
    public int progress = 0;
    @NetworkField(index=8)
    public int energyUsage = 1;

    public TileEntityCropAnalyzer() {
        super(7, 32);
        this.setFuelSlot(0);
        this.maxEnergy = 10000;
        this.addGuiFields("progress");
        this.addInfos(new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.getOppositeList(), 1);
        handler.registerDefaultSlotsForSide(RotationList.UP.getOppositeList(), 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(CommonFilters.SeedFilter, 1);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Input, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return 0.0f;
        }
        ICropSeed seed = (ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b();
        int lvl = seed.getScannedFromStack((ItemStack)this.inventory.get(1));
        if (lvl > 3 || lvl < 0) {
            return 0.0f;
        }
        return energyNeeded[lvl];
    }

    public double getRecipeProgress() {
        if (!(((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed)) {
            return 0.0;
        }
        ICropSeed seed = (ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b();
        int lvl = seed.getScannedFromStack((ItemStack)this.inventory.get(1));
        if (lvl > 3 || lvl < 0) {
            return 0.0;
        }
        return (double)this.progress / (double)energyNeeded[lvl];
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        this.updateNeighbors();
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(1)).func_77973_b() instanceof ICropSeed) {
                ICropSeed seed = (ICropSeed)((ItemStack)this.inventory.get(1)).func_77973_b();
                int lvl = seed.getScannedFromStack((ItemStack)this.inventory.get(1));
                if (lvl < 0 || lvl > 3) {
                    if (this.progress > 0) {
                        this.progress = 0;
                        this.getNetwork().updateTileGuiField(this, "progress");
                    }
                } else if (this.hasEnergy(this.energyUsage)) {
                    this.handleChargeSlot(energyNeeded[lvl]);
                    this.progress += this.energyUsage;
                    this.useEnergy(this.energyUsage);
                    if (this.progress >= energyNeeded[lvl]) {
                        boolean output;
                        this.progress = 0;
                        seed.incrementScannedFromStack((ItemStack)this.inventory.get(1));
                        lvl = seed.getScannedFromStack((ItemStack)this.inventory.get(1));
                        boolean bl = output = lvl >= 4 || lvl == -1;
                        if (output) {
                            this.inventory.set(2, this.inventory.get(1));
                            this.inventory.set(1, (Object)ItemStack.field_190927_a);
                            for (int i = 0; i < 4; ++i) {
                                ItemStack upgrade = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
                                if (!(upgrade.func_77973_b() instanceof IMachineUpgradeItem)) continue;
                                ((IMachineUpgradeItem)upgrade.func_77973_b()).onProcessFinished(upgrade, this);
                            }
                            this.notifyNeighbors();
                        }
                    }
                    this.getNetwork().updateTileGuiField(this, "progress");
                }
            } else if (this.progress != 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField(this, "progress");
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.getNetwork().updateTileGuiField(this, "progress");
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, this);
        }
        this.updateComparators();
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCropAnalyzer(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.cropScanner;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("Progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Progress", this.progress);
        return nbt;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return true;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
    }

    @Override
    public boolean isRedstoneSensitive() {
        return false;
    }

    @Override
    public boolean isProcessing() {
        return this.getActive();
    }

    @Override
    public World getMachineWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null || !(par1.func_77973_b() instanceof ICropSeed)) {
            return false;
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return true;
        }
        return StackUtil.isStackEqual((ItemStack)this.inventory.get(1), par1, false, false);
    }

    @Override
    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper(this, 2);
    }

    @Override
    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper(this, 0).setFilters(CommonFilters.SeedFilter);
    }

    @Override
    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return EnumSet.of(IMachineUpgradeItem.UpgradeType.ImportExport, IMachineUpgradeItem.UpgradeType.MachineModifierA, IMachineUpgradeItem.UpgradeType.MachineModifierB, IMachineUpgradeItem.UpgradeType.Custom);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockerRates();
        }
    }

    public void setOverclockerRates() {
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (item == null || !(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.func_190916_E();
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.func_190916_E());
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.func_190916_E());
            extraTier += upgrade.getExtraTier(item, this) * item.func_190916_E();
        }
        this.energyUsage = TileEntityCropAnalyzer.applyModifier(1, extraEnergyDemand, energyDemandMultiplier);
        this.setMaxEnergy(TileEntityCropAnalyzer.applyModifier(10000, extraEnergyStorage, energyStorageMultiplier));
        this.tier = 1 + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energyUsage < 1) {
            this.energyUsage = 1;
        }
    }

    static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }
}

