/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.EnergyUsageInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IEnergyUser;
import ic2.core.block.base.util.info.misc.IPumpTile;
import ic2.core.block.machine.low.container.ContainerElectricWoodGasser;
import ic2.core.fluid.IC2Fluid;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.OreFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ITankListener;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityElectricWoodGasser
extends TileEntityElecMachine
implements ITickable,
ITankListener,
IProgressMachine,
IHasGui,
IEnergyUser,
IPumpTile,
IBitLevelOverride {
    @NetworkField(index=7)
    public IC2Tank gasTank = new IC2Tank(18000);
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit8)
    public int ticksLeft = 0;
    public static int maxProgress = 130;

    public TileEntityElectricWoodGasser() {
        super(5, 32);
        this.setFuelSlot(0);
        this.maxEnergy = 500;
        this.gasTank.addListener(this);
        this.gasTank.setCanFill(false);
        this.addGuiFields("gasTank", "ticksLeft");
        this.addInfos(new EnergyUsageInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1, 3);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2, 4);
        handler.registerDefaultSlotsForSide(RotationList.UP.getOppositeList(), 0, 2, 4);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.getOppositeList(), 1, 3);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(new OreFilter("logWood"), 1);
        handler.registerInputFilter(new BasicItemFilter(Ic2Items.emptyCell.func_77946_l()), 3);
        handler.registerSlotType(SlotType.Fuel, 0);
        handler.registerSlotType(SlotType.Input, 1, 3);
        handler.registerSlotType(SlotType.Output, 2, 4);
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit16;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        this.handleChargeSlot(500);
        this.updateNeighbors();
        if (this.hasEnergy(1)) {
            if (this.ticksLeft > 0 && this.gasTank.getFluidAmount() <= 17994) {
                this.setActive(true);
                this.gasTank.fillInternal(IC2Fluid.getFluidStack("woodgas", 6), true);
                --this.ticksLeft;
                this.getNetwork().updateTileGuiField(this, "ticksLeft");
                this.useEnergy(1);
                if (this.ticksLeft <= 0) {
                    this.gasTank.fillInternal(IC2Fluid.getFluidStack("woodgas", 30), true);
                    if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                        this.inventory.set(2, (Object)new ItemStack(Items.field_151044_h, 1, 1));
                    } else {
                        ((ItemStack)this.inventory.get(2)).func_190917_f(1);
                    }
                    this.notifyNeighbors();
                }
            } else {
                this.setActive(false);
            }
            if (this.ticksLeft <= 0 && this.gasTank.getFluidAmount() <= 17000 && StackUtil.hasOreTag("logWood", (ItemStack)this.inventory.get(1)) && this.hasCharcoalRoom()) {
                this.ticksLeft = 130;
                this.getNetwork().updateTileGuiField(this, "ticksLeft");
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            }
        } else {
            this.setActive(false);
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.processCell();
        }
        this.updateComparators();
    }

    public void processCell() {
        if (this.gasTank.getFluidAmount() <= 0 || ((ItemStack)this.inventory.get(3)).func_190926_b()) {
            return;
        }
        Tuple<ItemStack, FluidStack> filled = FluidHelper.fillContainer((ItemStack)this.inventory.get(3), this.gasTank.getFluid(), true, true);
        if (filled != null) {
            if (((ItemStack)this.inventory.get(4)).func_190926_b()) {
                this.inventory.set(4, (Object)((ItemStack)filled.func_76341_a()).func_77946_l());
            } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(4), (ItemStack)filled.func_76341_a(), false, false) && ((ItemStack)this.inventory.get(4)).func_190916_E() < ((ItemStack)this.inventory.get(4)).func_77976_d()) {
                ((ItemStack)this.inventory.get(4)).func_190917_f(1);
            } else {
                return;
            }
            ((ItemStack)this.inventory.get(3)).func_190918_g(1);
            this.gasTank.drain((FluidStack)filled.func_76340_b(), true);
        }
    }

    public boolean hasCharcoalRoom() {
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return true;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), new ItemStack(Items.field_151044_h, 1, 1))) {
            return ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d();
        }
        return false;
    }

    @Override
    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField(this, "gasTank");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.gasTank.readFromNBT(nbt.func_74775_l("Tank"));
        this.ticksLeft = nbt.func_74762_e("TicksLeft");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.gasTank.writeToNBT(this.getTag(nbt, "Tank"));
        nbt.func_74768_a("TicksLeft", this.ticksLeft);
        return nbt;
    }

    @Override
    public int getPumpCharge() {
        return this.gasTank.getFluidAmount();
    }

    @Override
    public int getMaxPumpCharge() {
        return this.gasTank.getCapacity();
    }

    @Override
    public float getProgress() {
        if (this.ticksLeft == 0) {
            return 0.0f;
        }
        return maxProgress - this.ticksLeft;
    }

    @Override
    public float getMaxProgress() {
        return maxProgress;
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.gasTank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerElectricWoodGasser(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.electricWoodGasser;
    }
}

