/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.info.Info;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorFuelMachine;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.FuelMachineInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.low.container.ContainerIronFurnace;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IFurnace;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityIronFurnace
extends TileEntityMachine
implements ITickable,
IFuelMachine,
IProgressMachine,
IHasGui,
IFurnace {
    @NetworkField(index=3)
    public int fuel = 0;
    @NetworkField(index=4)
    public int maxFuel = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int progress = 0;
    public AudioSource audio;

    public TileEntityIronFurnace() {
        super(3);
        this.addGuiFields("fuel", "maxFuel", "progress");
        this.addInfos(new FuelMachineInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0);
        handler.registerDefaultSlotAccess(AccessRule.Both, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.getOppositeList(), 0);
        handler.registerDefaultSlotsForSide(RotationList.UP.getOppositeList(), 1, 2);
        handler.registerInputFilter(CommonFilters.IronFurnaceFuelWithLava, 1);
        handler.registerOutputFilter(CommonFilters.NotIronFurnaceFuelWithLava, 1);
        handler.registerInputFilter(CommonFilters.FurnaceInputFilter, 0);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.Fuel, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorFuelMachine(this));
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return 160.0f;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("fuel");
        this.maxFuel = nbt.func_74762_e("maxFuel");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74768_a("maxFuel", this.maxFuel);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        if (this.fuel <= 0 && !((ItemStack)this.inventory.get(1)).func_190926_b() && this.canOperate()) {
            int newFuel;
            this.maxFuel = newFuel = Info.itemInfo.getFuelValue((ItemStack)this.inventory.get(1), true);
            this.fuel = newFuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            this.getNetwork().updateTileGuiField(this, "maxFuel");
            if (this.fuel > 0) {
                if (((ItemStack)this.inventory.get(1)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(1))) {
                    this.inventory.set(1, (Object)((ItemStack)this.inventory.get(1)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(1)));
                } else {
                    ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                }
            }
        }
        if (this.isBurning() && this.canOperate()) {
            ++this.progress;
            if (this.progress >= 160) {
                this.progress = 0;
                this.operate();
            }
            this.getNetwork().updateTileGuiField(this, "progress");
        } else if (this.progress != 0) {
            this.progress = 0;
            this.getNetwork().updateTileGuiField(this, "progress");
        }
        if (this.isBurning()) {
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        if (wasBurning != this.isBurning()) {
            this.setActive(this.isBurning());
        }
        this.updateComparators();
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        ItemStack result = this.getResultFor((ItemStack)this.inventory.get(0));
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            this.inventory.set(2, (Object)result.func_77946_l());
        } else {
            ((ItemStack)this.inventory.get(2)).func_190917_f(result.func_190916_E());
        }
        if (((ItemStack)this.inventory.get(0)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(0))) {
            this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
        } else {
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = this.getResultFor((ItemStack)this.inventory.get(0));
        return !itemstack.func_190926_b() && (((ItemStack)this.inventory.get(2)).func_190926_b() || StackUtil.isStackEqual((ItemStack)this.inventory.get(2), itemstack) && ((ItemStack)this.inventory.get(2)).func_190916_E() + itemstack.func_190916_E() <= ((ItemStack)this.inventory.get(2)).func_77976_d());
    }

    public ItemStack getResultFor(ItemStack input) {
        return FurnaceRecipes.func_77602_a().func_151395_a(input);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerIronFurnace(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.FurnaceGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.ironFurnace;
    }

    public int getFuelLevel() {
        if (this.fuel <= 0) {
            return 0;
        }
        if (this.maxFuel <= 0) {
            this.maxFuel = this.fuel;
        }
        return (int)((double)this.fuel / (double)this.maxFuel * 14.0);
    }

    public int getProgressLevel() {
        if (this.progress <= 0) {
            return 0;
        }
        return (int)((double)this.progress / 160.0 * 24.0);
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("isActive")) {
            if (this.audio != null && this.audio.isRemoved()) {
                this.audio = null;
            }
            if (this.audio == null) {
                this.audio = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.ironFurnaceOp, true, true, IC2.audioManager.getDefaultVolume());
            }
            if (this.audio != null) {
                if (this.getActive()) {
                    this.audio.play();
                } else if (!this.getActive()) {
                    this.audio.stop();
                }
            }
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.audio != null) {
            this.audio.remove();
            this.audio = null;
        }
    }
}

