/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.INotifyMachine;
import ic2.api.energy.EnergyNet;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.machine.low.container.ContainerMachineTank;
import ic2.core.fluid.LayeredFluidTank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.util.obj.IBufferBox;
import ic2.core.util.obj.ITankListener;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityMachineTank
extends TileEntityElecMachine
implements ITickable,
IMachine,
INotifyMachine,
IHasGui,
IBufferBox,
INetworkClientTileEventListener,
ITankListener {
    public boolean redstoneInverted = false;
    public boolean redstoneSensitive = false;
    boolean notified = false;
    @NetworkField(index=7)
    public boolean tick = true;
    @NetworkField(index=8)
    public boolean notifyWhenTick = false;
    @NetworkField(index=9)
    public LayeredFluidTank tank = new LayeredFluidTank(64000);

    public TileEntityMachineTank() {
        super(4, 32);
        this.tank.addListener(this);
        this.maxEnergy = 500;
        this.addGuiFields("tick", "notifyWhenTick", "tank");
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    @Override
    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField(this, "tank");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.notified = nbt.func_74767_n("Notify");
        this.tick = nbt.func_74767_n("Tick");
        this.notifyWhenTick = nbt.func_74767_n("NotiTick");
        this.tank.readFromNBT(nbt.func_74775_l("Tank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Notify", this.notified);
        nbt.func_74757_a("Tick", this.tick);
        nbt.func_74757_a("NotiTick", this.notifyWhenTick);
        this.tank.writeToNBT(this.getTag(nbt, "Tank"));
        return nbt;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.machineTank;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerMachineTank(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isTicking() {
        return this.tick;
    }

    @Override
    public boolean isNofiting() {
        return this.notifyWhenTick;
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        this.handleRedstone();
        boolean active = !this.isRedstonePowered();
        this.setActive(active);
        if (active) {
            ItemStack item;
            int i;
            if (this.tick) {
                for (i = 0; i < 4; ++i) {
                    item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
                    if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
                    ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, this);
                }
            }
            if (this.notified) {
                if (!this.tick || this.notifyWhenTick) {
                    for (i = 0; i < 4; ++i) {
                        item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
                        if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
                        ((IMachineUpgradeItem)item.func_77973_b()).onProcessFinished(item, this);
                    }
                }
                this.notified = false;
            }
        }
        this.updateComparators();
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.tick = !this.tick;
            this.getNetwork().updateTileGuiField(this, "tick");
            if (!this.tick) {
                this.notifyWhenTick = false;
                this.getNetwork().updateTileGuiField(this, "notifyWhenTick");
            }
        } else if (event == 1 && this.tick) {
            this.notifyWhenTick = !this.notifyWhenTick;
            this.getNetwork().updateTileGuiField(this, "notifyWhenTick");
        }
    }

    @Override
    public void onNotify() {
        this.notified = true;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        boolean result;
        boolean bl = result = (double)this.energy >= amount;
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return result;
    }

    @Override
    public boolean isRedstonePowered() {
        if (!this.redstoneSensitive) {
            return false;
        }
        if (this.redstoneInverted) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public void handleRedstone() {
        if (this.redstoneSensitive) {
            super.handleRedstone();
        }
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
        this.redstoneSensitive = active;
    }

    @Override
    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    @Override
    public boolean isProcessing() {
        return false;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        return true;
    }

    @Override
    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return EnumSet.of(IMachineUpgradeItem.UpgradeType.Custom, IMachineUpgradeItem.UpgradeType.MachineModifierB, IMachineUpgradeItem.UpgradeType.RedstoneControl, IMachineUpgradeItem.UpgradeType.ImportExport, IMachineUpgradeItem.UpgradeType.Processing);
    }

    @Override
    public World getMachineWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.func_190916_E());
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, this), item.func_190916_E()));
            extraTier += upgrade.getExtraTier(item, this) * item.func_190916_E();
            if (!upgrade.useRedstoneInverter(item, this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.setMaxEnergy(TileEntityMachineTank.applyModifier(500, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }
}

