/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.tile.ISawMill;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.machine.recipes.entries.WoodWorkOutput;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.util.misc.StackUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySawMill
extends TileEntityBasicElectricMachine
implements ISawMill {
    public TileEntitySawMill() {
        super(3, 2, 320, 32);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.sawMill;
    }

    @Override
    public MachineType getType() {
        return MachineType.sawMill;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.sawMill;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return this.getRecipeList().getRecipeInAndOutput(input, false);
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return Ic2Resources.sawmill;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.SawMillGui.class;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (ClassicRecipes.sawMill.getRecipeInAndOutput(par1, true) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    public static void init() {
        LinkedList<ItemStack> stickList = new LinkedList<ItemStack>();
        for (ItemStack stack : OreDictionary.getOres((String)"logWood", (boolean)false)) {
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                List<ItemStack> list = TileEntitySawMill.unfoldMetadata(stack);
                for (ItemStack entry : list) {
                    ItemStack output = TileEntitySawMill.findOutput(entry.func_77946_l());
                    if (output.func_190926_b()) continue;
                    TileEntitySawMill.addWoodWorkRecipe(StackUtil.copyWithSize(entry, 1), StackUtil.copyWithSize(output, 6), 0.0f);
                    stickList.add(output.func_77946_l());
                }
                continue;
            }
            ItemStack output = TileEntitySawMill.findOutput(stack.func_77946_l());
            if (output.func_190926_b()) continue;
            TileEntitySawMill.addWoodWorkRecipe(StackUtil.copyWithSize(stack, 1), StackUtil.copyWithSize(output, 6), 0.0f);
            stickList.add(output.func_77946_l());
        }
        for (ItemStack input : stickList) {
            TileEntitySawMill.addWoodWorkRecipe(StackUtil.copyWithSize(input, 1), new ItemStack(Items.field_151055_y, 4), 0.0f, input.func_82833_r() + "_To_Sticks");
        }
        TileEntitySawMill.addWoodWorkRecipe(Ic2Items.rubberWood.func_77946_l(), new ItemStack(Blocks.field_150364_r, 6, 3), 0.0f);
        TileEntitySawMill.addRecipe(new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba, 7), 0.1f);
    }

    public static List<ItemStack> unfoldMetadata(ItemStack stack) {
        NonNullList list = NonNullList.func_191196_a();
        stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list);
        return list;
    }

    public static ItemStack findOutput(ItemStack recipe) {
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return true;
            }
        }, 3, 3);
        inventory.func_70299_a(4, StackUtil.copyWithSize(recipe, 1));
        try {
            return CraftingManager.func_82787_a((InventoryCrafting)inventory, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void addWoodWorkRecipe(ItemStack input, ItemStack output, float exp, String id) {
        ClassicRecipes.sawMill.addRecipe((IRecipeInput)new RecipeInputItemStack(input), new WoodWorkOutput(null, exp, output), id);
    }

    public static void addWoodWorkRecipe(ItemStack input, ItemStack output, float exp) {
        ClassicRecipes.sawMill.addRecipe((IRecipeInput)new RecipeInputItemStack(input), new WoodWorkOutput(null, exp, output), TileEntitySawMill.makeString(output));
    }

    public static void addRecipe(ItemStack input, ItemStack output, float xp) {
        ClassicRecipes.sawMill.addRecipe(new RecipeInputItemStack(input), output, xp, TileEntitySawMill.makeString(output));
    }

    private static String makeString(ItemStack stack) {
        return stack.func_82833_r();
    }
}

