/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crops;

import ic2.api.classic.crops.ClassicCrops;
import ic2.api.crops.CropCard;
import ic2.core.block.machine.low.logic.crops.CropSeedEntry;
import ic2.core.block.machine.low.logic.crops.SeedEntry;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.item.crop.ItemCropSeed;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;

public class SeedStorage {
    public PersonalInventory display = new PersonalInventory(25);
    Map<CropCard, List<SeedEntry>> crops = new LinkedHashMap<CropCard, List<SeedEntry>>();
    LinkedList<CropCard> workList = new LinkedList();
    public int offset = 0;
    public boolean dissabled = false;

    public boolean enable() {
        if (this.dissabled) {
            this.dissabled = false;
            return true;
        }
        return false;
    }

    public void dissable() {
        if (!this.dissabled) {
            this.display.clear();
            this.dissabled = true;
        }
    }

    public boolean hasWork() {
        return this.workList.size() > 0;
    }

    public void addWork(List<CropCard> cards) {
        this.workList.clear();
        this.workList.addAll(cards);
    }

    public void addSingleWork(CropCard card) {
        this.workList.remove(card);
        this.workList.add(card);
    }

    public void addSingleWorkFirst(CropCard card) {
        this.workList.remove(card);
        this.workList.addFirst(card);
    }

    public boolean processWork(Comparator<SeedEntry> sorter, boolean inverted, CropCard card) {
        if (sorter != null && this.workList.size() > 0) {
            CropCard current = this.workList.removeFirst();
            List<SeedEntry> entry = this.crops.get(current);
            if (entry == null) {
                return false;
            }
            entry.sort(inverted ? sorter.reversed() : sorter);
            return current == card;
        }
        return false;
    }

    public void updateNull() {
        List<SeedEntry> list = this.crops.get(null);
        if (list == null) {
            list = new ArrayList<SeedEntry>();
            this.crops.put(null, list);
        }
        list.clear();
        for (Map.Entry<CropCard, List<SeedEntry>> entry : this.crops.entrySet()) {
            if (entry.getKey() == null) continue;
            for (SeedEntry seed : entry.getValue()) {
                list.add(new CropSeedEntry(seed, entry.getKey()));
            }
        }
    }

    public boolean contains(CropCard card) {
        return this.crops.containsKey(card);
    }

    public void clearOffset() {
        this.offset = 0;
    }

    public Set<CropCard> getCards() {
        return this.crops.keySet();
    }

    public void moveOffset(CropCard card, int movement) {
        this.offset += movement;
        List<SeedEntry> seed = this.crops.get(card);
        if (seed == null) {
            this.offset = 0;
            return;
        }
        if (this.offset > seed.size() / 5) {
            this.offset = seed.size() / 5;
        } else if (this.offset < 0) {
            this.offset = 0;
        }
    }

    public ItemStack drain(CropCard currentCrop, int slot, int requested, boolean doDrain) {
        List<SeedEntry> list = this.crops.get(currentCrop);
        int slotID = this.offset * 5 + slot;
        if (list == null || list.size() <= slotID) {
            return ItemStack.field_190927_a;
        }
        SeedEntry entry = list.get(slotID);
        int drained = entry.consume(requested, doDrain);
        if (doDrain && entry.isEmpty()) {
            boolean nullUpdate = false;
            list.remove(slotID);
            if (currentCrop == null) {
                List<SeedEntry> seed = this.crops.get(entry.getCard(null));
                seed.remove(((CropSeedEntry)entry).getEntry());
                if (seed.isEmpty()) {
                    this.crops.remove(entry.getCard(null));
                }
                nullUpdate = true;
            }
            if (list.isEmpty()) {
                this.crops.remove(currentCrop);
                nullUpdate = true;
            }
            if (nullUpdate) {
                this.updateNull();
            }
        }
        ItemStack stack = ItemCropSeed.generateItemStack(entry.getCard(currentCrop), entry.getGrowth(), entry.getGain(), entry.getResistance(), 4);
        stack.func_190920_e(drained);
        return stack;
    }

    public int getFirstWithIndex(List<CropCard> list) {
        if (this.crops.isEmpty()) {
            return 0;
        }
        for (CropCard card : this.crops.keySet()) {
            int index = list.indexOf(card);
            if (index == -1) continue;
            return index;
        }
        return 0;
    }

    public void updateDisplay(CropCard currentCard) {
        if (this.dissabled) {
            return;
        }
        this.display.clear();
        List<SeedEntry> entry = this.crops.get(currentCard);
        if (entry == null) {
            return;
        }
        int realIndex = this.offset * 5;
        for (int i = 0; i + realIndex < entry.size() && i < 25; ++i) {
            SeedEntry seed = entry.get(realIndex + i);
            ItemStack stack = ItemCropSeed.generateItemStack(seed.getCard(currentCard), seed.getGrowth(), seed.getGain(), seed.getResistance(), 4);
            ItemCropSeed.setVisible(stack);
            stack.func_190920_e(MathHelper.func_76125_a((int)seed.getAmount(), (int)1, (int)127));
            this.display.setStackInSlot(i, stack);
            StackUtil.getOrCreateNbtData(stack).func_74768_a("CropCount", seed.getAmount());
        }
    }

    public boolean storeSeeds(Tuple<CropCard, SeedEntry> tuple) {
        if (this.dissabled) {
            return false;
        }
        List<SeedEntry> entry = this.crops.get(tuple.func_76341_a());
        if (entry == null) {
            entry = new ArrayList<SeedEntry>();
            this.crops.put((CropCard)tuple.func_76341_a(), entry);
            entry.add((SeedEntry)tuple.func_76340_b());
            this.updateNull();
            this.addSingleWork((CropCard)tuple.func_76341_a());
            return true;
        }
        SeedEntry toAdd = (SeedEntry)tuple.func_76340_b();
        for (int i = 0; i < entry.size(); ++i) {
            SeedEntry seed = entry.get(i);
            if (!seed.equals(toAdd)) continue;
            seed.combine(toAdd);
            return true;
        }
        entry.add(toAdd);
        return true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        CropCard card;
        String id;
        this.crops.clear();
        this.workList.clear();
        this.offset = nbt.func_74762_e("Offset");
        this.dissabled = nbt.func_74767_n("Dissabled");
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            id = data.func_74779_i("Card");
            if (id.equals("Empty") || (card = ClassicCrops.instance.getCropCard(new ResourceLocation(id))) == null) continue;
            NBTTagList counts = data.func_150295_c("Entries", 10);
            ArrayList<SeedEntry> seeds = new ArrayList<SeedEntry>(counts.func_74745_c());
            for (int x = 0; x < counts.func_74745_c(); ++x) {
                seeds.add(new SeedEntry(counts.func_150305_b(x)));
            }
            this.crops.put(card, seeds);
        }
        NBTTagList work = nbt.func_150295_c("Work", 8);
        for (int i = 0; i < work.func_74745_c(); ++i) {
            id = work.func_150307_f(i);
            if (id.equals("Empty")) {
                this.workList.add(null);
                continue;
            }
            card = ClassicCrops.instance.getCropCard(new ResourceLocation(id));
            if (card == null) continue;
            this.workList.add(card);
        }
        this.updateNull();
        this.workList.add(null);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<CropCard, List<SeedEntry>> entry : this.crops.entrySet()) {
            NBTTagList stored = new NBTTagList();
            for (SeedEntry seed : entry.getValue()) {
                stored.func_74742_a((NBTBase)seed.writeToNBT());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("Entries", (NBTBase)stored);
            CropCard card = entry.getKey();
            nbt.func_74778_a("Card", card == null ? "Empty" : new ResourceLocation(card.getOwner(), card.getId()).toString());
            list.func_74742_a((NBTBase)nbt);
        }
        NBTTagList work = new NBTTagList();
        for (CropCard card : this.workList) {
            work.func_74742_a((NBTBase)new NBTTagString(card == null ? "Empty" : new ResourceLocation(card.getOwner(), card.getId()).toString()));
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("Data", (NBTBase)list);
        nBTTagCompound.func_74782_a("Work", (NBTBase)work);
        nBTTagCompound.func_74757_a("Dissabled", this.dissabled);
        nBTTagCompound.func_74768_a("Offset", this.offset);
        return nBTTagCompound;
    }
}

