/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IElectrolyzerRecipeList;
import ic2.api.classic.tile.IElectrolyzerProvider;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.med.container.ContainerChargedElectrolyzer;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityChargedElectrolyzer
extends TileEntityMachine
implements ITickable,
IHasGui,
IProgressMachine {
    @NetworkField(index=3)
    public int energy = 0;
    @NetworkField(index=4)
    public int maxEnergy = 0;
    public AudioSource source;
    public int ticker;
    public IElectrolyzerProvider[] providers = new IElectrolyzerProvider[6];
    public Set<Direction> iteration = new LinkedHashSet<Direction>();
    public int highestTier = 0;

    public TileEntityChargedElectrolyzer() {
        super(2);
        this.ticker = IC2.random.nextInt(16);
        this.addGuiFields("energy", "maxEnergy");
        this.addInfos(new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.getOppositeList(), 0);
        handler.registerDefaultSlotsForSide(RotationList.UP.getOppositeList(), 1);
        handler.registerInputFilter(CommonFilters.ElectrolyzerInput, 0);
        handler.registerInputFilter(CommonFilters.ElectrolyzerOutput, 1);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.Output, 1);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public float getProgress() {
        return this.energy;
    }

    @Override
    public float getMaxProgress() {
        return this.maxEnergy;
    }

    @Override
    public boolean supportsRotation() {
        return false;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.chargedElectrolyzer;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("Energy");
        this.maxEnergy = nbt.func_74762_e("MaxEnergy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("MaxEnergy", this.maxEnergy);
        return nbt;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") && this.isActiveChanged()) {
            if (this.source != null && this.source.isRemoved()) {
                this.source = null;
            }
            if (this.source == null) {
                this.source = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.electrolyzerOp, true, true, IC2.audioManager.defaultVolume);
            }
            if (this.source != null) {
                if (this.getActive()) {
                    this.source.play();
                } else {
                    this.source.pause();
                }
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.source != null) {
            IC2.audioManager.removeSources(this);
            this.source = null;
        }
        super.onUnloaded();
    }

    public void updateProviders() {
        this.highestTier = 0;
        for (Direction dir : Direction.directions) {
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile instanceof IElectrolyzerProvider) {
                IElectrolyzerProvider prov;
                this.providers[dir.toSideValue()] = prov = (IElectrolyzerProvider)tile;
                int tier = prov.getTier();
                if (tier > this.highestTier) {
                    this.highestTier = tier;
                }
                this.iteration.add(dir);
                continue;
            }
            this.providers[dir.toSideValue()] = null;
            this.iteration.remove((Object)dir);
        }
    }

    public void func_73660_a() {
        if (++this.ticker % 16 == 0) {
            this.updateProviders();
        }
        if (this.iteration.isEmpty()) {
            return;
        }
        boolean active = false;
        if (this.shouldDrain() && this.canDrain()) {
            active = true;
            this.drain();
        }
        if (this.shouldPower() && (this.energy > 0 || this.canPower())) {
            active = true;
            this.power();
        }
        if (active != this.getActive()) {
            this.setActive(active);
        }
    }

    public boolean shouldPower() {
        for (Direction facing : this.iteration) {
            IElectrolyzerProvider prov = this.providers[facing.toSideValue()];
            if (!this.needsPower(prov)) continue;
            return true;
        }
        return false;
    }

    public boolean canPower() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return false;
        }
        IElectrolyzerRecipeList.RecipeEntry entry = this.getRecipeList().getOutput((ItemStack)this.inventory.get(1), false);
        if (entry == null) {
            return false;
        }
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return true;
        }
        if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(0), entry.getInput())) {
            return false;
        }
        return ((ItemStack)this.inventory.get(0)).func_190916_E() + entry.getInput().func_190916_E() <= ((ItemStack)this.inventory.get(0)).func_77976_d();
    }

    public void power() {
        int comboEnergy;
        if (this.energy > 0) {
            for (Direction facing : this.iteration) {
                IElectrolyzerProvider prov = this.providers[facing.toSideValue()];
                if (!this.needsPower(prov)) continue;
                int process = prov.getProcessRate();
                if (process > this.energy) {
                    process = this.energy;
                }
                this.energy -= process;
                prov.addPower(process);
                this.getNetwork().updateTileGuiField(this, "energy");
            }
            return;
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return;
        }
        IElectrolyzerRecipeList.RecipeEntry entry = this.getRecipeList().getOutput((ItemStack)this.inventory.get(1), false);
        if (entry == null) {
            return;
        }
        double totalEnergy = entry.getEnergy();
        int baseEnergy = (int)(totalEnergy / 10.0 * 6.0);
        int extraEnergy = (int)(totalEnergy / 10.0 * (double)this.highestTier);
        this.energy = comboEnergy = baseEnergy + extraEnergy;
        this.maxEnergy = comboEnergy;
        this.getNetwork().updateTileGuiField(this, "energy");
        this.getNetwork().updateTileGuiField(this, "maxEnergy");
        ((ItemStack)this.inventory.get(1)).func_190918_g(1);
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            this.inventory.set(0, (Object)entry.getInput().func_77946_l());
        } else {
            ((ItemStack)this.inventory.get(0)).func_190917_f(entry.getInput().func_190916_E());
        }
    }

    public boolean shouldDrain() {
        for (Direction facing : this.iteration) {
            IElectrolyzerProvider prov = this.providers[facing.toSideValue()];
            if (!this.hasPower(prov)) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        IElectrolyzerRecipeList.RecipeEntry entry = this.getRecipeList().getOutput((ItemStack)this.inventory.get(0), true);
        if (entry == null || entry.getEnergy() > this.getAviablePower()) {
            return false;
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return true;
        }
        if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(1), entry.getOutput())) {
            return false;
        }
        return ((ItemStack)this.inventory.get(1)).func_190916_E() + entry.getOutput().func_190916_E() <= ((ItemStack)this.inventory.get(1)).func_77976_d();
    }

    public void drain() {
        IElectrolyzerRecipeList.RecipeEntry entry = this.getRecipeList().getOutput((ItemStack)this.inventory.get(0), true);
        if (entry == null) {
            return;
        }
        int neededEnergy = entry.getEnergy();
        if (this.maxEnergy != neededEnergy) {
            this.maxEnergy = neededEnergy;
            this.getNetwork().updateTileGuiField(this, "maxEnergy");
        }
        for (Direction facing : this.iteration) {
            IElectrolyzerProvider prov = this.providers[facing.toSideValue()];
            if (!this.hasPower(prov)) continue;
            int progress = prov.getProcessRate();
            prov.drawPower(progress);
            this.energy += progress;
            this.getNetwork().updateTileGuiField(this, "energy");
        }
        if (this.energy < neededEnergy) {
            return;
        }
        this.energy -= neededEnergy;
        ((ItemStack)this.inventory.get(0)).func_190918_g(1);
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            this.inventory.set(1, (Object)entry.getOutput().func_77946_l());
        } else {
            ((ItemStack)this.inventory.get(1)).func_190917_f(entry.getOutput().func_190916_E());
        }
    }

    public int getAviablePower() {
        long total = 0L;
        for (Direction facing : this.iteration) {
            IElectrolyzerProvider prov = this.providers[facing.toSideValue()];
            if (!this.hasPower(prov)) continue;
            total += (long)prov.getStoredEnergy();
        }
        return (int)(total > Integer.MAX_VALUE ? Integer.MAX_VALUE : total);
    }

    public boolean hasPower(IElectrolyzerProvider provider) {
        return (double)provider.getStoredEnergy() / (double)provider.getMaxEnergyStorage() >= 0.7;
    }

    public boolean needsPower(IElectrolyzerProvider provider) {
        return (double)provider.getStoredEnergy() / (double)provider.getMaxEnergyStorage() <= 0.3;
    }

    public IElectrolyzerRecipeList getRecipeList() {
        return ClassicRecipes.electrolyzer;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerChargedElectrolyzer(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.ElectrolyzerGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }
}

