/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityAdvancedMachine;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.slots.SlotCustom;
import ic2.core.inventory.slots.SlotDischarge;
import ic2.core.inventory.slots.SlotOutput;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IFurnace;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TileEntityInductionFurnace
extends TileEntityAdvancedMachine
implements IFurnace {
    public TileEntityInductionFurnace() {
        super(5, 15, 4000);
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1, 2);
        handler.registerDefaultSlotAccess(AccessRule.Export, this.getOutputSlots());
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.getOppositeList(), 1, 2);
        handler.registerDefaultSlotsForSide(RotationList.UP.getOppositeList(), this.getOutputSlots());
        handler.registerInputFilter(CommonFilters.DischargeEU, 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(new MachineFilter(this), 1, 2);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Input, 1, 2);
        handler.registerSlotType(SlotType.Output, this.getOutputSlots());
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return ClassicRecipes.furnace.getRecipeInAndOutput(input, false);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.FurnaceGui.class;
    }

    @Override
    public MachineType getType() {
        return MachineType.furnace;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.inductionFurnace;
    }

    @Override
    public LocaleComp getSpeedName() {
        return Ic2GuiLang.machineHeat;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.inductionFurnace;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{3, 4};
    }

    @Override
    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper(this, 1, 2).setFilters(new MachineFilter(this));
    }

    @Override
    public IMachineRecipeList.RecipeEntry getRecipe() {
        IMachineRecipeList.RecipeEntry entry = this.getRecipe(1);
        if (entry == null) {
            entry = this.getRecipe(2);
        }
        return entry;
    }

    @Override
    public void handleModifiers(IMachineRecipeList.RecipeEntry entry) {
        int newProg;
        IMachineRecipeList.RecipeEntry firstEntry = this.getRawRecipe(1);
        IMachineRecipeList.RecipeEntry secondEntry = this.getRawRecipe(2);
        if (this.isNull(firstEntry) && this.isNull(secondEntry)) {
            if (this.recipeEnergy != this.energyConsume) {
                this.recipeEnergy = this.energyConsume;
                this.getNetwork().updateTileGuiField(this, "recipeEnergy");
            }
            if (this.recipeOperation != this.operationLength) {
                this.recipeOperation = this.operationLength;
                this.getNetwork().updateTileGuiField(this, "recipeOperation");
            }
            return;
        }
        int newEnergy = Math.max(this.getEnergyCost(firstEntry), this.getEnergyCost(secondEntry));
        if (newEnergy != this.recipeEnergy) {
            this.recipeEnergy = newEnergy;
            this.getNetwork().updateTileGuiField(this, "recipeEnergy");
        }
        if ((newProg = Math.max(this.getExtraTime(firstEntry), this.getExtraTime(secondEntry))) != this.recipeOperation) {
            this.recipeOperation = newProg;
            this.getNetwork().updateTileGuiField(this, "recipeOperation");
        }
    }

    public int getEnergyCost(IMachineRecipeList.RecipeEntry entry) {
        if (this.isNull(entry)) {
            return this.energyConsume;
        }
        NBTTagCompound nbt = entry.getOutput().getMetadata();
        double energyMod = nbt.func_74764_b("RecipeEnergyModifier") ? nbt.func_74769_h("RecipeEnergyModifier") : 1.0;
        return TileEntityInductionFurnace.applyModifier(this.energyConsume, nbt.func_74762_e("RecipeEnergy"), energyMod);
    }

    public int getExtraTime(IMachineRecipeList.RecipeEntry entry) {
        if (this.isNull(entry)) {
            return this.operationLength;
        }
        NBTTagCompound nbt = entry.getOutput().getMetadata();
        double progMod = nbt.func_74764_b("RecipeTimeModifier") ? nbt.func_74769_h("RecipeTimeModifier") : 1.0;
        return TileEntityInductionFurnace.applyModifier(this.operationLength, nbt.func_74762_e("RecipeTime"), progMod);
    }

    private boolean isNull(IMachineRecipeList.RecipeEntry entry) {
        return entry == null || entry.getOutput().getMetadata() == null;
    }

    @Override
    public void operate(int slot, IMachineRecipeList.RecipeEntry entry) {
        int first = !((ItemStack)this.inventory.get(1)).func_190926_b() ? 1 : 2;
        int second = !((ItemStack)this.inventory.get(2)).func_190926_b() ? 2 : 1;
        super.operate(first, this.getRecipe(first));
        super.operate(second, this.getRecipe(second));
    }

    public IMachineRecipeList.RecipeEntry getRawRecipe(int slot) {
        if (((ItemStack)this.inventory.get(slot)).func_190926_b() && !this.canWorkWithoutItems()) {
            return null;
        }
        IMachineRecipeList.RecipeEntry result = null;
        if (this.lastRecipe != null && this.lastRecipe != null) {
            IRecipeInput recipe = this.lastRecipe.getInput();
            if (recipe instanceof INullableRecipeInput) {
                if (recipe.matches((ItemStack)this.inventory.get(slot))) {
                    result = this.lastRecipe;
                }
            } else if (((ItemStack)this.inventory.get(slot)).func_190926_b() && recipe.matches((ItemStack)this.inventory.get(slot))) {
                result = this.lastRecipe;
            }
        }
        if (result == null) {
            IMachineRecipeList.RecipeEntry out = this.getOutputFor(((ItemStack)this.inventory.get(slot)).func_77946_l());
            if (out == null) {
                return null;
            }
            result = out;
        }
        if (this.hasEmptyOutput(slot)) {
            return result;
        }
        for (ItemStack output : result.getOutput().getAllOutputs()) {
            for (int outputSlot : this.getOutputSlots()) {
                if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(outputSlot), output, false, true) || ((ItemStack)this.inventory.get(outputSlot)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(outputSlot)).func_77976_d()) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public Slot[] getInventorySlots(InventoryPlayer player) {
        Slot[] slots = new Slot[]{new SlotDischarge(this, this.tier, 0, 56, 53), new SlotCustom(this, 1, 47, 17, new MachineFilter(this)), new SlotCustom(this, 2, 63, 17, new MachineFilter(this)), new SlotOutput(player.field_70458_d, this, 3, 113, 35), new SlotOutput(player.field_70458_d, this, 4, 131, 35)};
        return slots;
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.furnace;
    }

    @Override
    public ResourceLocation getProcessSoundFile() {
        return Ic2Sounds.inductionFurnaceLoop;
    }

    @Override
    public ResourceLocation getStartingSoundFile() {
        return Ic2Sounds.inductionFurnaceStart;
    }

    @Override
    public ResourceLocation getStoppingSoundFile() {
        return Ic2Sounds.inductionFurnaceStop;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (this.getOutputFor(par1) != null) {
            if (((ItemStack)this.inventory.get(1)).func_190926_b() || StackUtil.isStackEqual((ItemStack)this.inventory.get(1), par1, false, false)) {
                return true;
            }
            if (((ItemStack)this.inventory.get(2)).func_190926_b() || StackUtil.isStackEqual((ItemStack)this.inventory.get(2), par1, false, false)) {
                return true;
            }
        }
        return false;
    }
}

