/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.item.IScannerItem;
import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.med.container.ContainerOreScanner;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TileEntityOreScanner
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
INetworkClientTileEntityEventListener,
IBitLevelOverride {
    public int range;
    public int currentX;
    public int currentY;
    public int currentZ;
    @NetworkField(index=7)
    public int maxBlocks;
    @NetworkField(index=8)
    public int currentBlocks;
    public long lastID;
    @NetworkField(index=9)
    public ProcessState state = ProcessState.None;
    public OreStorage storage = new OreStorage();

    public TileEntityOreScanner() {
        super(2, 128);
        this.setFuelSlot(0);
        this.maxEnergy = 50000;
        this.addGuiFields("state", "maxBlocks", "currentBlocks");
        this.addInfos(new ProgressInfo(this));
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit24;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public float getProgress() {
        return this.currentBlocks;
    }

    @Override
    public float getMaxProgress() {
        return this.maxBlocks;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.oreScanner;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt.func_74775_l("Storage"));
        this.range = nbt.func_74762_e("Range");
        this.currentX = nbt.func_74762_e("CurrentX");
        this.currentY = nbt.func_74762_e("CurrentY");
        this.currentZ = nbt.func_74762_e("CurrentZ");
        this.maxBlocks = nbt.func_74762_e("MaxBlocks");
        this.currentBlocks = nbt.func_74762_e("CurrentBlocks");
        this.state = ProcessState.values()[nbt.func_74762_e("Mode")];
        this.lastID = nbt.func_74763_f("ScannerID");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.storage.writeToNBT(this.getTag(nbt, "Storage"));
        nbt.func_74768_a("Range", this.range);
        nbt.func_74768_a("CurrentX", this.currentX);
        nbt.func_74768_a("CurrentY", this.currentY);
        nbt.func_74768_a("CurrentZ", this.currentZ);
        nbt.func_74768_a("MaxBlocks", this.maxBlocks);
        nbt.func_74768_a("CurrentBlocks", this.currentBlocks);
        nbt.func_74768_a("Mode", this.state.ordinal());
        nbt.func_74772_a("ScannerID", this.lastID);
        return nbt;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        boolean operate;
        int used;
        this.handleChargeSlot(50000);
        this.updateComparators();
        if (this.energy > 0 && !((ItemStack)this.inventory.get(1)).func_190926_b() && (used = (int)ElectricItem.manager.charge((ItemStack)this.inventory.get(1), this.energy, this.tier, true, false)) > 0) {
            this.useEnergy(used);
        }
        if (!(operate = this.canRun())) {
            if (this.state != ProcessState.None) {
                this.onChanged(ProcessState.None);
            }
            return;
        }
        if (this.energy < 200) {
            return;
        }
        if (this.hasChanged()) {
            this.onChanged(ProcessState.Started);
            return;
        }
        if (this.state != ProcessState.Started) {
            return;
        }
        this.work();
    }

    public void work() {
        IScannerItem item = (IScannerItem)((ItemStack)this.inventory.get(1)).func_77973_b();
        int maxX = this.func_174877_v().func_177958_n() + this.range;
        int maxZ = this.func_174877_v().func_177952_p() + this.range;
        boolean adv = item.isAdvancedScanner((ItemStack)this.inventory.get(1));
        for (int i = 0; i < 40 && this.state == ProcessState.Started; ++i) {
            BlockPos checkPos = new BlockPos(this.currentX, this.currentY, this.currentZ);
            IBlockState state = this.field_145850_b.func_180495_p(checkPos);
            if (adv ? item.isValuableOre((ItemStack)this.inventory.get(1), state, this.field_145850_b, checkPos) : item.isValuableOre((ItemStack)this.inventory.get(1), state)) {
                this.storage.add(state);
            }
            this.useEnergy(5);
            ++this.currentBlocks;
            ++this.currentX;
            if (this.currentX <= maxX) continue;
            this.currentX = this.func_174877_v().func_177958_n() - this.range;
            ++this.currentZ;
            if (this.currentZ <= maxZ) continue;
            this.currentZ = this.func_174877_v().func_177952_p() - this.range;
            --this.currentY;
            if (this.currentY >= 0) continue;
            this.onChanged(ProcessState.Finished);
        }
        this.getNetwork().updateTileGuiField(this, "currentBlocks");
    }

    public void onChanged(ProcessState newState) {
        this.state = newState;
        if (newState == ProcessState.None) {
            this.storage.clear();
            this.range = -1;
            this.currentBlocks = 0;
            this.maxBlocks = 0;
            this.currentX = 0;
            this.currentY = 0;
            this.currentZ = 0;
            this.lastID = -1L;
            this.getNetwork().updateTileGuiField(this, "maxBlocks");
            this.getNetwork().updateTileGuiField(this, "currentBlocks");
        } else if (newState == ProcessState.Started) {
            int newRange;
            IScannerItem item = (IScannerItem)((ItemStack)this.inventory.get(1)).func_77973_b();
            this.range = newRange = item.startLayerScan((ItemStack)this.inventory.get(1));
            newRange *= 2;
            this.currentBlocks = 0;
            this.maxBlocks = ++newRange * newRange * this.func_174877_v().func_177956_o();
            this.getNetwork().updateTileGuiField(this, "maxBlocks");
            this.getNetwork().updateTileGuiField(this, "currentBlocks");
            this.currentX = this.func_174877_v().func_177958_n() - this.range;
            this.currentY = this.func_174877_v().func_177956_o() - 1;
            this.currentZ = this.func_174877_v().func_177952_p() - this.range;
            this.setScannerID(System.currentTimeMillis());
            this.lastID = this.getScannerID();
        } else if (newState == ProcessState.Finished) {
            this.storage.onFinished();
        } else if (newState == ProcessState.Reseted) {
            this.currentX = this.func_174877_v().func_177958_n() - this.range;
            this.currentY = this.func_174877_v().func_177956_o();
            this.currentZ = this.func_174877_v().func_177952_p() - this.range;
            this.currentBlocks = 0;
            this.storage.clear();
            this.getNetwork().updateTileGuiField(this, "currentBlocks");
            this.onChanged(ProcessState.Started);
        }
        this.getNetwork().updateTileGuiField(this, "state");
    }

    public boolean hasChanged() {
        if (this.lastID == -1L) {
            return !((ItemStack)this.inventory.get(1)).func_190926_b();
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return false;
        }
        long scanID = this.getScannerID();
        if (scanID == -1L) {
            return true;
        }
        return this.lastID != scanID;
    }

    public boolean canRun() {
        return ((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IScannerItem;
    }

    public long getScannerID() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return -1L;
        }
        return StackUtil.getNbtData((ItemStack)this.inventory.get(1)).func_74763_f("ScannerID");
    }

    public void setScannerID(long id) {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return;
        }
        StackUtil.getOrCreateNbtData((ItemStack)this.inventory.get(1)).func_74772_a("ScannerID", id);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerOreScanner(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event != 0) {
            this.storage.offset += event;
            if (this.storage.offset > this.storage.results.size() - 1) {
                this.storage.offset = this.storage.results.size() - 1;
            }
            if (this.storage.offset < 0) {
                this.storage.offset = 0;
            }
            this.storage.updateOffset();
        } else {
            this.onChanged(ProcessState.Reseted);
        }
    }

    public static class OreStorage
    implements IHasInventory {
        int offset = 0;
        NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        List<ItemStack> results = new ArrayList<ItemStack>();
        Map<Block, Map<Integer, Integer>> ores = new LinkedHashMap<Block, Map<Integer, Integer>>();

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            this.inventory.set(slot, (Object)stack);
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.inventory.get(slot);
        }

        @Override
        public int getSlotCount() {
            return this.inventory.size();
        }

        @Override
        public int getMaxStackSize(int slot) {
            return 64;
        }

        @Override
        public boolean canInsert(int slot, ItemStack stack) {
            return true;
        }

        public int getStorage(ItemStack stack) {
            if (stack == null) {
                return 0;
            }
            return StackUtil.getNbtData(stack).func_74762_e("OreCount");
        }

        public void updateOffset() {
            for (int i = 0; i < 5; ++i) {
                int count = this.offset + i;
                if (count < this.results.size()) {
                    this.inventory.set(i, (Object)this.results.get(count).func_77946_l());
                    continue;
                }
                this.inventory.set(i, (Object)ItemStack.field_190927_a);
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("Offset", this.offset);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.results.size(); ++i) {
                NBTTagCompound data = new NBTTagCompound();
                this.results.get(i).func_77955_b(data);
                list.func_74742_a((NBTBase)data);
            }
            nbt.func_74782_a("Items", (NBTBase)list);
            NBTTagList oreList = new NBTTagList();
            for (Map.Entry<Block, Map<Integer, Integer>> entry : this.ores.entrySet()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("Key", entry.getKey().getRegistryName().toString());
                NBTTagList metaEntry = new NBTTagList();
                for (Map.Entry<Integer, Integer> value : entry.getValue().entrySet()) {
                    metaEntry.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{value.getKey(), value.getValue()}));
                }
                data.func_74782_a("Value", (NBTBase)metaEntry);
                oreList.func_74742_a((NBTBase)data);
            }
            nbt.func_74782_a("OreData", (NBTBase)oreList);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.offset = nbt.func_74762_e("Offset");
            this.ores.clear();
            this.results.clear();
            NBTTagList list = nbt.func_150295_c("Items", 10);
            this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                this.results.add(new ItemStack(data));
            }
            NBTTagList oreList = nbt.func_150295_c("OreData", 10);
            for (int i = 0; i < oreList.func_74745_c(); ++i) {
                NBTTagCompound data = oreList.func_150305_b(i);
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(data.func_74779_i("Key")));
                NBTTagList metaList = data.func_150295_c("Value", 11);
                HashMap<Integer, Integer> maps = new HashMap<Integer, Integer>();
                for (int x = 0; x < metaList.func_74745_c(); ++x) {
                    int[] array = metaList.func_150306_c(x);
                    maps.put(array[0], array[1]);
                }
                this.ores.put(block, maps);
            }
            this.updateOffset();
        }

        public void add(IBlockState state) {
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            Map<Integer, Integer> map = this.ores.get(block);
            if (map == null) {
                map = new HashMap<Integer, Integer>();
                this.ores.put(block, map);
            }
            if (map.containsKey(meta)) {
                map.put(meta, map.get(meta) + 1);
            } else {
                map.put(meta, 1);
            }
        }

        public void clear() {
            this.ores.clear();
            this.results.clear();
            this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        }

        public void onFinished() {
            this.offset = 0;
            this.results.clear();
            for (Map.Entry<Block, Map<Integer, Integer>> entry : this.ores.entrySet()) {
                Map<Integer, Integer> value = entry.getValue();
                for (Map.Entry<Integer, Integer> valueMap : value.entrySet()) {
                    ItemStack stack = new ItemStack(entry.getKey(), 1, valueMap.getKey().intValue());
                    if (stack.func_190926_b()) continue;
                    this.results.add(stack);
                    StackUtil.getOrCreateNbtData(stack).func_74768_a("OreCount", valueMap.getValue().intValue());
                }
            }
            this.ores.clear();
            Collections.sort(this.results, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    int sizeB;
                    int sizeA = this.getSize(o1);
                    if (sizeA > (sizeB = this.getSize(o2))) {
                        return -1;
                    }
                    if (sizeB > sizeA) {
                        return 1;
                    }
                    return 0;
                }

                public int getSize(ItemStack par1) {
                    if (par1.func_190926_b()) {
                        return 0;
                    }
                    return this.getStorage(par1);
                }
            });
            this.updateOffset();
        }
    }

    public static enum ProcessState {
        None,
        Started,
        Finished,
        Reseted;

    }
}

