/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import com.google.common.base.Strings;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineExpOutput;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.recipe.IBasicMachineRecipeManager;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.RecipeOutput;
import ic2.core.block.machine.recipes.managers.RecipeManager;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;

public class BasicMachineRecipeList
implements IMachineRecipeList {
    public static Random rand = new Random();
    String base;
    protected Map<ItemWithMeta, IMachineRecipeList.RecipeEntry> recipeMap = new LinkedHashMap<ItemWithMeta, IMachineRecipeList.RecipeEntry>();

    public BasicMachineRecipeList(String id) {
        this.base = id;
    }

    @Override
    public void addRecipe(IRecipeInput input, ItemStack output, String id) {
        this.addRecipe(input, output, 0.0f, id);
    }

    @Override
    public void addRecipe(IRecipeInput input, ItemStack output, float exp, String id) {
        this.addRecipe(input, null, output, exp, id);
    }

    @Override
    public void addRecipe(IRecipeInput input, NBTTagCompound nbt, ItemStack output, float exp, String id) {
        assert (!output.func_190926_b());
        assert (input != null);
        if (exp > 0.0f) {
            this.addRecipe(input, new MachineExpOutput(nbt, exp, output), id);
        } else {
            this.addRecipe(input, new MachineOutput(nbt, output), id);
        }
    }

    @Override
    public void addRecipe(IRecipeInput input, MachineOutput output, String id) {
        assert (output != null);
        assert (input != null);
        assert (!Strings.isNullOrEmpty((String)id));
        if (this.checksRecipes() && !RecipeManager.register(this.base, id)) {
            return;
        }
        for (ItemStack item : output.getAllOutputs()) {
            if (!item.func_190926_b()) continue;
            return;
        }
        IMachineRecipeList.RecipeEntry toAdd = new IMachineRecipeList.RecipeEntry(input, output, id);
        LinkedHashMap<ItemWithMeta, IMachineRecipeList.RecipeEntry> addMap = new LinkedHashMap<ItemWithMeta, IMachineRecipeList.RecipeEntry>();
        for (ItemStack stack : input.getInputs()) {
            if (stack.func_190926_b()) continue;
            ItemWithMeta meta = new ItemWithMeta(stack);
            IMachineRecipeList.RecipeEntry entry = this.recipeMap.get(meta);
            if (entry != null) {
                FMLLog.getLogger().info("Found Overleap with recipe: " + entry.getInput() + " Its not getting Added");
                return;
            }
            addMap.put(meta, toAdd);
        }
        this.recipeMap.putAll(addMap);
    }

    @Override
    public IMachineRecipeList.RecipeEntry getRecipeInAndOutput(ItemStack input, boolean ignore) {
        IRecipeInput rInput;
        if (input.func_190926_b()) {
            return null;
        }
        ItemWithMeta item = new ItemWithMeta(input);
        IMachineRecipeList.RecipeEntry entry = this.recipeMap.get(item);
        if (entry == null) {
            entry = this.recipeMap.get(item.toWildcard());
        }
        if (entry != null && (rInput = entry.getInput()).matches(input) && (ignore || rInput.getAmount() <= input.func_190916_E())) {
            return entry;
        }
        return null;
    }

    protected boolean checksRecipes() {
        return true;
    }

    @Override
    public List<IMachineRecipeList.RecipeEntry> getRecipeMap() {
        return new ArrayList<IMachineRecipeList.RecipeEntry>(new LinkedHashSet<IMachineRecipeList.RecipeEntry>(this.recipeMap.values()));
    }

    @Override
    public List<IMachineRecipeList.RecipeEntry> removeRecipe(IRecipeInput input) {
        if (input == null) {
            return new ArrayList<IMachineRecipeList.RecipeEntry>();
        }
        LinkedHashMap<ItemWithMeta, IMachineRecipeList.RecipeEntry> toRemove = new LinkedHashMap<ItemWithMeta, IMachineRecipeList.RecipeEntry>();
        for (ItemStack item : input.getInputs()) {
            ItemWithMeta meta;
            IMachineRecipeList.RecipeEntry entry;
            if (item == null || item.func_77973_b() == null || (entry = this.recipeMap.get(meta = new ItemWithMeta(item))) == null || !entry.getInput().matches(item) || entry.getInput().getAmount() != input.getAmount()) continue;
            toRemove.put(meta, entry);
        }
        for (ItemWithMeta meta : toRemove.keySet()) {
            this.recipeMap.remove(meta);
        }
        return new ArrayList<IMachineRecipeList.RecipeEntry>(toRemove.values());
    }

    @Override
    public void removeRecipe(IMachineRecipeList.RecipeEntry entry) {
        if (entry == null) {
            return;
        }
        for (ItemStack stack : entry.getInput().getInputs()) {
            if (stack.func_190926_b()) continue;
            this.recipeMap.remove(new ItemWithMeta(stack));
        }
    }

    @Override
    public IMachineRecipeList.RecipeEntry removeRecipe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return this.recipeMap.remove(new ItemWithMeta(stack));
    }

    @Override
    public IMachineRecipeManager toIC2Exp() {
        return new IBasicMachineRecipeManager(){

            @Override
            public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean replace, ItemStack ... outputs) {
                BasicMachineRecipeList.this.addRecipe(input, new MachineOutput(metadata, outputs), this.makeID(Arrays.asList(outputs)));
                return true;
            }

            @Override
            @Deprecated
            public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
                return BasicMachineRecipeList.this.getRecipeInAndOutput(input, false).getOutput().toIC2Exp();
            }

            @Override
            public Iterable<? extends MachineRecipe<IRecipeInput, Collection<ItemStack>>> getRecipes() {
                return new MachineRecipeIterator(BasicMachineRecipeList.this);
            }

            @Override
            public boolean isIterable() {
                return true;
            }

            @Override
            public boolean addRecipe(IRecipeInput input, Collection<ItemStack> output, NBTTagCompound metadata, boolean replace) {
                BasicMachineRecipeList.this.addRecipe(input, new MachineOutput(metadata, new ArrayList<ItemStack>(output)), this.makeID(output));
                return true;
            }

            @Override
            public MachineRecipeResult<IRecipeInput, Collection<ItemStack>, ItemStack> apply(ItemStack input, boolean acceptTest) {
                IMachineRecipeList.RecipeEntry entry = BasicMachineRecipeList.this.getRecipeInAndOutput(input, true);
                if (!acceptTest) {
                    input = input.func_77946_l();
                    input.func_190918_g(entry.getInput().getAmount());
                }
                return new MachineRecipe<IRecipeInput, List<ItemStack>>(entry.getInput(), entry.getOutput().copy().getRecipeOutput(rand, new NBTTagCompound())).getResult(input);
            }

            private String makeID(Collection<ItemStack> array) {
                StringBuilder builder = new StringBuilder();
                builder.append("ic2exprecipe_");
                for (ItemStack stack : array) {
                    builder.append(stack.func_82833_r()).append("_");
                }
                builder.substring(0, builder.length() - 1);
                return builder.toString();
            }
        };
    }

    public class MachineRecipeIterator
    implements Iterable<MachineRecipe<IRecipeInput, Collection<ItemStack>>> {
        IMachineRecipeList list;

        public MachineRecipeIterator(IMachineRecipeList par1) {
            this.list = par1;
        }

        @Override
        public Iterator<MachineRecipe<IRecipeInput, Collection<ItemStack>>> iterator() {
            return new Iterator<MachineRecipe<IRecipeInput, Collection<ItemStack>>>(){
                int index;
                IMachineRecipeList.RecipeEntry last;

                @Override
                public boolean hasNext() {
                    return MachineRecipeIterator.this.list.getRecipeMap().size() > this.index;
                }

                @Override
                public MachineRecipe<IRecipeInput, Collection<ItemStack>> next() {
                    this.last = MachineRecipeIterator.this.list.getRecipeMap().get(this.index++);
                    return new MachineRecipe<IRecipeInput, Collection<ItemStack>>(this.last.getInput(), this.last.getOutput().toIC2Exp().items);
                }

                @Override
                public void remove() {
                    if (this.last != null) {
                        MachineRecipeIterator.this.list.getRecipeMap().remove(this.last);
                    }
                }
            };
        }
    }
}

