/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineExpOutput;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.recipe.IRecipeInput;
import ic2.core.item.recipe.entry.RecipeInputCombined;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class RecipeManager {
    private static boolean ignore = false;
    public static final String[] machines = new String[]{"extractor", "macerator", "compressor", "recycler", "sawmill"};
    public static JsonObject obj;
    static Map<String, Set<String>> map;

    public static boolean register(String type, String id) {
        String canAdd;
        if (ignore) {
            return true;
        }
        JsonObject obj = RecipeManager.getObj(type);
        if (obj.has(canAdd = RecipeManager.getRecipeID(RecipeManager.getType(type), id, 0)) && !obj.get(canAdd).getAsBoolean()) {
            return false;
        }
        obj.addProperty(canAdd, Boolean.valueOf(true));
        return true;
    }

    private static JsonObject getObj(String type) {
        if (!obj.has(type)) {
            obj.add(type, (JsonElement)new JsonObject());
        }
        return obj.getAsJsonObject(type);
    }

    static Set<String> getType(String id) {
        Set<String> s = map.get(id);
        if (s == null) {
            s = new LinkedHashSet<String>();
            map.put(id, s);
        }
        return s;
    }

    static String getRecipeID(Set<String> ids, String base, int index) {
        String newString = base;
        if (index > 0) {
            newString = newString + "_" + index;
        }
        if (ids.contains(newString)) {
            return RecipeManager.getRecipeID(ids, base, index + 1);
        }
        ids.add(newString);
        return newString;
    }

    public static void loadRecipes(JsonObject obj) {
        if (obj.size() == 0) {
            return;
        }
        ignore = true;
        RecipeManager.convert(obj.get("recipes"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                try {
                    RecipeManager.loadRecipe(t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ignore = false;
    }

    static void loadRecipe(JsonObject value) {
        String type = value.get("recipeType").getAsString();
        if (RecipeManager.isStandartMachine(type)) {
            final ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            RecipeManager.convert(value.get("outputs"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    ItemStack stack = RecipeManager.createStack(t);
                    if (stack.func_190926_b()) {
                        return;
                    }
                    outputs.add(stack);
                }
            });
            NBTTagCompound comp = value.has("recipeMetadata") ? RecipeManager.createData(value.get("recipeMetadata").getAsString()) : new NBTTagCompound();
            comp = comp.func_82582_d() ? null : comp;
            MachineOutput out = value.has("recipeExperience") ? new MachineExpOutput(comp, value.get("recipeExperience").getAsFloat(), outputs) : new MachineOutput(comp, outputs);
            JsonObject input = value.getAsJsonObject("input");
            String inputType = input.get("inputType").getAsString();
            if (inputType.equalsIgnoreCase("ore")) {
                int amount = input.has("amount") ? input.get("amount").getAsInt() : 1;
                RecipeManager.getRecipeForMachine(type).addRecipe((IRecipeInput)new RecipeInputOreDict(input.get("oreID").getAsString(), amount), out, "customRecipe");
            } else if (inputType.equalsIgnoreCase("fluid")) {
                Fluid fluid = FluidRegistry.getFluid((String)input.get("fluidID").getAsString());
                if (fluid == null) {
                    FMLLog.log.info("FluidID is Invalid: " + input.get("fluidID"));
                    return;
                }
                int amount = input.has("fluidAmount") ? input.get("fluidAmount").getAsInt() : 1000;
                RecipeManager.getRecipeForMachine(type).addRecipe((IRecipeInput)new RecipeInputFluid(new FluidStack(fluid, amount)), out, "customRecipe");
            } else if (inputType.equalsIgnoreCase("item")) {
                ItemStack stack = RecipeManager.createStack(input);
                if (stack.func_190926_b()) {
                    FMLLog.log.info("Input is Invalid: " + input);
                    return;
                }
                RecipeManager.getRecipeForMachine(type).addRecipe((IRecipeInput)new RecipeInputItemStack(stack), out, "customRecipe");
            } else if (inputType.equalsIgnoreCase("itemList")) {
                final ArrayList<IRecipeInput> inputList = new ArrayList<IRecipeInput>();
                RecipeManager.convert(input.get("items"), new Consumer<JsonObject>(){

                    @Override
                    public void accept(JsonObject t) {
                        ItemStack stack = RecipeManager.createStack(t);
                        if (stack.func_190926_b()) {
                            return;
                        }
                        inputList.add(new RecipeInputItemStack(stack));
                    }
                });
                RecipeManager.getRecipeForMachine(type).addRecipe((IRecipeInput)new RecipeInputCombined(inputList), out, "customRecipe");
            }
            return;
        }
        if (type.equalsIgnoreCase("massFab")) {
            JsonObject input = value.getAsJsonObject("input");
            String inputType = input.get("inputType").getAsString();
            int amplifier = input.get("amplifier").getAsInt();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("amplification", amplifier);
            MachineOutput output = new MachineOutput(nbt, Arrays.asList(Ic2Items.uuMatter));
            if (inputType.equalsIgnoreCase("ore")) {
                int amount = input.has("amount") ? input.get("amount").getAsInt() : 1;
                ClassicRecipes.massfabAmplifier.addRecipe((IRecipeInput)new RecipeInputOreDict(input.get("oreID").getAsString(), amount), output, "customRecipe");
            } else if (inputType.equalsIgnoreCase("fluid")) {
                Fluid fluid = FluidRegistry.getFluid((String)input.get("fluidID").getAsString());
                if (fluid == null) {
                    FMLLog.log.info("FluidID is Invalid: " + input.get("fluidID"));
                    return;
                }
                int amount = input.has("fluidAmount") ? input.get("fluidAmount").getAsInt() : 1000;
                ClassicRecipes.massfabAmplifier.addRecipe((IRecipeInput)new RecipeInputFluid(new FluidStack(fluid, amount)), output, "customRecipe");
            } else if (inputType.equalsIgnoreCase("item")) {
                ItemStack stack = RecipeManager.createStack(input);
                if (stack.func_190926_b()) {
                    FMLLog.log.info("Input is Invalid: " + input);
                    return;
                }
                ClassicRecipes.massfabAmplifier.addRecipe((IRecipeInput)new RecipeInputItemStack(stack), output, "customRecipe");
            } else if (inputType.equalsIgnoreCase("itemList")) {
                final ArrayList<IRecipeInput> inputList = new ArrayList<IRecipeInput>();
                RecipeManager.convert(input.get("items"), new Consumer<JsonObject>(){

                    @Override
                    public void accept(JsonObject t) {
                        ItemStack stack = RecipeManager.createStack(t);
                        if (stack.func_190926_b()) {
                            return;
                        }
                        inputList.add(new RecipeInputItemStack(stack));
                    }
                });
                ClassicRecipes.massfabAmplifier.addRecipe((IRecipeInput)new RecipeInputCombined(inputList), output, "customRecipe");
            }
        } else if (type.equalsIgnoreCase("electrolyzer")) {
            ItemStack input = RecipeManager.createStack(value.getAsJsonObject("input"));
            ItemStack output = RecipeManager.createStack(value.getAsJsonObject("output"));
            if (input.func_190926_b() || output.func_190926_b()) {
                FMLLog.log.info("Inalid Recipe Aborting entry: " + value);
                return;
            }
            int energy = value.get("recipeEnergy").getAsInt();
            String recipeType = value.get("direction").getAsString();
            if (recipeType.equalsIgnoreCase("both")) {
                ClassicRecipes.electrolyzer.addBothRecipe(input, output, energy, "customRecipe");
            } else if (recipeType.equalsIgnoreCase("discharge")) {
                ClassicRecipes.electrolyzer.addDischargeRecipe(input, output, energy, "customRecipe");
            } else {
                ClassicRecipes.electrolyzer.addChargeRecipe(input, output, energy, "customRecipe");
            }
        } else if (type.equalsIgnoreCase("cannerFuel")) {
            ItemStack stack = RecipeManager.createStack(value.getAsJsonObject("input"));
            if (stack.func_190926_b()) {
                FMLLog.log.info("Inalid Recipe Aborting entry: " + value);
                return;
            }
            String fuelType = value.get("fuelType").getAsString();
            if (fuelType.equalsIgnoreCase("multiplier")) {
                ClassicRecipes.canningMachine.registerFuelMultiplier(stack, value.get("multiplier").getAsFloat());
            } else if (fuelType.equalsIgnoreCase("adaptive")) {
                ClassicRecipes.canningMachine.registerFuelValue(stack, value.get("adaptive").getAsInt());
            }
        } else if (type.equalsIgnoreCase("rareEarth")) {
            ItemStack stack = RecipeManager.createStack(value.getAsJsonObject("input"));
            if (stack.func_190926_b()) {
                FMLLog.log.info("Inalid Recipe Aborting entry: " + value);
                return;
            }
            ClassicRecipes.earthExtractor.registerValue(value.get("amount").getAsFloat(), stack);
        }
    }

    public static ItemStack createStack(JsonObject value) {
        Item item = Item.func_111206_d((String)value.get("item").getAsString());
        if (item == Items.field_190931_a) {
            FMLLog.log.info("Invalid Item found at json Object: " + value);
            return ItemStack.field_190927_a;
        }
        int meta = value.get("meta").getAsInt();
        int amount = value.get("amount").getAsInt();
        ItemStack stack = new ItemStack(item, amount, meta);
        if (value.has("nbt")) {
            NBTTagCompound compound = RecipeManager.createData(value.get("nbt").getAsString());
            if (compound.func_82582_d()) {
                FMLLog.log.info("Invalid NBTString found at Json Object: " + value);
                return ItemStack.field_190927_a;
            }
            stack.func_77982_d(compound);
        }
        return stack;
    }

    public static NBTTagCompound createData(String data) {
        try {
            return JsonToNBT.func_180713_a((String)data);
        }
        catch (Exception exception) {
            return new NBTTagCompound();
        }
    }

    static IMachineRecipeList getRecipeForMachine(String id) {
        if (id.equalsIgnoreCase("extractor")) {
            return ClassicRecipes.extractor;
        }
        if (id.equalsIgnoreCase("macerator")) {
            return ClassicRecipes.macerator;
        }
        if (id.equalsIgnoreCase("compressor")) {
            return ClassicRecipes.compressor;
        }
        if (id.equalsIgnoreCase("recycler")) {
            return ClassicRecipes.recycler;
        }
        if (id.equalsIgnoreCase("sawmill")) {
            return ClassicRecipes.sawMill;
        }
        return null;
    }

    static boolean isStandartMachine(String id) {
        for (String value : machines) {
            if (!value.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    public static void convert(JsonElement value, Consumer<JsonObject> receiver) {
        if (value == null) {
            return;
        }
        if (value.isJsonObject()) {
            receiver.accept(value.getAsJsonObject());
        } else if (value.isJsonArray()) {
            for (JsonElement entry : value.getAsJsonArray()) {
                if (!entry.isJsonObject()) continue;
                receiver.accept(entry.getAsJsonObject());
            }
        }
    }

    static {
        map = new LinkedHashMap<String, Set<String>>();
    }
}

