/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.core.IC2;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockScaffoldBase
extends Block
implements ITexturedBlock,
IBootable,
ILocaleBlock {
    public static PropertyInteger strength = PropertyInteger.func_177719_a((String)"strength", (int)0, (int)15);

    public BlockScaffoldBase(Material par1) {
        super(par1);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)strength, (Comparable)Integer.valueOf(0)));
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{strength});
    }

    public abstract double getMaxSpeed();

    public abstract int getReinforcedStrength();

    public abstract int getStandartStrength();

    public abstract ItemStack getUpgradeItem();

    public abstract boolean isSameScaffold(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getSideTexture();

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getTopTexture();

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getUpgradedSideTexture();

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing par1) {
        if (par1.func_176740_k().func_176720_b()) {
            return this.getTopTexture();
        }
        if (((Integer)state.func_177229_b((IProperty)strength)).intValue() == this.getReinforcedStrength()) {
            return this.getUpgradedSideTexture();
        }
        return this.getSideTexture();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return this.getTopTexture();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        states.addAll((Collection<IBlockState>)this.func_176194_O().func_177619_a());
        return states;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)strength);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)strength, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.func_176740_k().func_176720_b();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        float factor = 1.0f;
        float min = factor / 16.0f;
        float max = factor - min;
        return new AxisAlignedBB((double)min, 0.0, (double)min, (double)max, 1.0, (double)max);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            player.field_70143_R = 0.0f;
            double motionX = player.field_70159_w;
            double motionZ = player.field_70179_y;
            double d = motionX > 0.15 ? 0.15 : (player.field_70159_w = motionX < -0.15 ? 0.15 : player.field_70159_w);
            double d2 = motionZ > 0.15 ? 0.15 : (player.field_70179_y = motionZ < -0.15 ? 0.15 : player.field_70179_y);
            if (player.field_70181_x < -0.15) {
                player.field_70181_x = -0.15;
            }
            if (player.func_70093_af()) {
                player.field_70181_x = 0.08;
            }
            if (IC2.keyboard.isForwardKeyDown(player) && player.field_70181_x < 0.2) {
                player.field_70181_x = this.getMaxSpeed();
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack((Block)this, 1));
        if (((Integer)state.func_177229_b((IProperty)strength)).intValue() == this.getReinforcedStrength()) {
            items.add(this.getUpgradeItem());
        }
        return items;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.getStrengthFrom(worldIn, pos) > -1 && super.func_176196_c(worldIn, pos);
    }

    public int getStrengthFrom(World world, BlockPos pos) {
        int strength = 0;
        if (this.isPillar(world, pos.func_177977_b())) {
            strength = this.getStandartStrength() + 1;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int other;
            if (facing == EnumFacing.UP || (other = this.getConnectedStrength(world, pos.func_177972_a(facing))) <= strength) continue;
            strength = other;
        }
        return strength - 1;
    }

    public boolean isPillar(World world, BlockPos pos) {
        BlockPos realPos = pos;
        while (world.func_180495_p(realPos).func_177230_c() == this) {
            realPos = realPos.func_177977_b();
        }
        return world.isSideSolid(realPos, EnumFacing.UP, false);
    }

    public int getConnectedStrength(World world, BlockPos pos) {
        if (!world.func_175668_a(pos, false)) {
            return 0;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            int cu = (Integer)state.func_177229_b((IProperty)strength);
            if (cu > this.getReinforcedStrength()) {
                cu = this.getReinforcedStrength();
            }
            return cu;
        }
        return 0;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177230_c() != this) {
            return;
        }
        int ownStrength = (Integer)state.func_177229_b((IProperty)strength);
        if (ownStrength >= this.getReinforcedStrength()) {
            if (!this.isPillar(worldIn, pos)) {
                ownStrength = this.getStrengthFrom(worldIn, pos);
                ItemStack drop = this.getUpgradeItem();
                if (drop != null) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
                }
            }
        } else {
            ownStrength = this.getStrengthFrom(worldIn, pos);
        }
        if (ownStrength < 0) {
            this.func_176226_b(worldIn, pos, this.func_176223_P(), 0);
            worldIn.func_175698_g(pos);
        } else if (ownStrength != (Integer)state.func_177229_b((IProperty)strength)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)strength, (Comparable)Integer.valueOf(ownStrength)));
            worldIn.func_175704_b(pos, pos);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.func_180650_b(worldIn, pos, state, null);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_180497_b(pos, (Block)this, 1, 0);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack upgrade;
        if (playerIn.func_70093_af()) {
            return false;
        }
        ItemStack current = playerIn.func_184586_b(hand);
        if (!StackUtil.isStackEqual(current, upgrade = this.getUpgradeItem()) || current.func_190916_E() < upgrade.func_190916_E()) {
            return false;
        }
        if (((Integer)state.func_177229_b((IProperty)strength)).intValue() == this.getReinforcedStrength() || !this.isPillar(worldIn, pos)) {
            return false;
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            current.func_190918_g(upgrade.func_190916_E());
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)strength, (Comparable)Integer.valueOf(this.getReinforcedStrength())));
        worldIn.func_175704_b(pos, pos);
        IC2.network.get().announceBlockUpdate(worldIn, pos);
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        BlockPos cuPos;
        ItemStack stack = playerIn.func_184614_ca();
        if (stack != null && this.isSameScaffold(stack)) {
            cuPos = pos;
            while (worldIn.func_180495_p(cuPos).func_177230_c() == this) {
                cuPos = cuPos.func_177984_a();
            }
            if (this.func_176196_c(worldIn, cuPos) && cuPos.func_177956_o() < worldIn.func_72940_L()) {
                worldIn.func_175656_a(cuPos, this.func_176223_P());
                this.func_180650_b(worldIn, cuPos, this.func_176223_P(), RANDOM);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (this.field_149764_J == Material.field_151573_f && pos.func_177956_o() <= 5 && cuPos.func_177956_o() >= 255) {
                    IC2.achievements.issueStat(playerIn, "scaffolded");
                }
                return;
            }
        }
        if ((stack = playerIn.func_184592_cb()) != null && this.isSameScaffold(stack)) {
            cuPos = pos;
            while (worldIn.func_180495_p(cuPos).func_177230_c() == this) {
                cuPos = cuPos.func_177984_a();
            }
            if (this.func_176196_c(worldIn, cuPos) && cuPos.func_177956_o() < worldIn.func_72940_L()) {
                worldIn.func_175656_a(cuPos, this.func_176223_P());
                this.func_180650_b(worldIn, cuPos, this.func_176223_P(), RANDOM);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
        }
    }
}

