/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.container;

import ic2.core.block.base.tile.TileEntityChargePadBase;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.base.MachineChargeComp;
import ic2.core.inventory.gui.components.special.ChargePadComp;
import ic2.core.inventory.slots.SlotBase;
import ic2.core.inventory.slots.SlotCustom;
import ic2.core.inventory.slots.SlotDischarge;
import ic2.core.inventory.slots.SlotPadUpgrade;
import ic2.core.inventory.slots.SlotUpgrade;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerChargePad
extends ContainerTileComponent<TileEntityChargePadBase> {
    public ContainerChargePad(InventoryPlayer player, TileEntityChargePadBase base) {
        super(base);
        SlotBase slotBase;
        int slot = 0;
        if (base.type == TileEntityChargePadBase.ChargePadType.Nuclear) {
            ++slot;
            slotBase = new SlotCustom(base.inv, slot, 8, 58, CommonFilters.cargePadFitler);
        } else {
            ++slot;
            slotBase = new SlotDischarge(base.inv, base.tier, slot, 8, 58);
        }
        this.func_75146_a(slotBase);
        if (base.type.getTier() > 1) {
            this.func_75146_a(new SlotPadUpgrade(base.inv, slot++, 134, 58).setInfo(base, true));
            this.func_75146_a(new SlotPadUpgrade(base.inv, slot++, 134, 29).setInfo(base, false));
        }
        int left = base.inv.getSlotCount() - slot;
        this.func_75146_a(new SlotUpgrade(base.inv, slot++, 71, 39, base.getMachine(), base));
        if (left > 1) {
            this.func_75146_a(new SlotUpgrade(base.inv, slot++, 61, 58, base.getMachine(), base));
            if (left > 2) {
                this.func_75146_a(new SlotUpgrade(base.inv, slot++, 81, 58, base.getMachine(), base));
            }
        }
        this.addPlayerInventory(player);
        this.addComponent(new ChargePadComp(base));
        this.addComponent(new MachineChargeComp(base, Ic2GuiComp.chargePadChargeBox, Ic2GuiComp.chargePadChargePos));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.field_146291_p = false;
        gui.setMaxGuiY(169);
    }

    @Override
    public int guiInventorySize() {
        return ((TileEntityChargePadBase)this.getGuiHolder()).inv.getSlotCount();
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.chargePad;
    }
}

