/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.EnergyNetPathMap;
import ic2.core.util.helpers.AbstractIterator;
import ic2.core.util.helpers.FilteredList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.EnumFacing;

public class EnergyNetGrid {
    EnergyNetLocal local;
    final GridID gridID;
    final EnergyNetPathMap.EnergyNetSubPathMap pathMap;
    Set<IEnergyConductor> cables = new LinkedHashSet<IEnergyConductor>();
    Set<IEnergySource> sources = new LinkedHashSet<IEnergySource>();
    Set<IEnergySink> sinks = new LinkedHashSet<IEnergySink>();
    Map<IEnergyConductor, WireConnection> connectionMap = new HashMap<IEnergyConductor, WireConnection>();
    Set<IEnergySource> newSources = new LinkedHashSet<IEnergySource>();
    Set<IEnergySink> newSinks = new LinkedHashSet<IEnergySink>();
    Set<WireConnection> connections = new LinkedHashSet<WireConnection>();
    boolean isDirty = false;
    boolean markSplit = false;
    boolean split = false;
    boolean didCombine = false;
    boolean reset = false;
    int addedGrids = 0;

    public EnergyNetGrid(GridID par1, EnergyNetLocal par2) {
        this.gridID = par1;
        this.local = par2;
        this.pathMap = par2.createSubList();
    }

    public GridID getGridID() {
        return this.gridID;
    }

    void setIsSplitted() {
        this.split = true;
    }

    public boolean hasConductors() {
        return this.cables.size() > 0;
    }

    public boolean isDirty() {
        return this.isDirty || this.didCombine;
    }

    public Set<EnergyNetLocal.EnergyPath> getPaths(IEnergyConductor tile) {
        return this.pathMap.getConductorPaths(tile);
    }

    public void addConductor(IEnergyConductor wire) {
        if (this.cables.add(wire)) {
            this.local.addWireToGrid(wire, this.getGridID());
            WireConnection connections = new WireConnection(wire, this);
            this.connectionMap.put(wire, connections);
            if (connections.getNeighborCount() > 1) {
                if (this.didCombine || this.reset || this.split || this.isDirty) {
                    return;
                }
                this.isDirty = true;
                this.reset = true;
                this.pathMap.resetPaths();
                this.local.markGridDirty(this.getGridID());
                this.newSources.addAll(this.sources);
                this.newSinks.addAll(this.sinks);
            }
        }
    }

    public void addSinks(IEnergySink sink) {
        this.sinks.add(sink);
        this.newSinks.add(sink);
        if (!this.split) {
            this.isDirty = true;
            this.local.markGridDirty(this.getGridID());
        }
    }

    public void addSource(IEnergySource source) {
        this.sources.add(source);
        this.newSources.add(source);
        if (!this.split) {
            this.isDirty = true;
            this.local.markGridDirty(this.getGridID());
        }
    }

    public void addGridWithPaths(EnergyNetGrid grid) {
        this.cables.addAll(grid.cables);
        if (grid.isDirty()) {
            this.sinks.addAll(grid.sinks);
            this.sources.addAll(grid.sources);
            this.newSources.addAll(grid.sources);
            this.newSinks.addAll(grid.newSinks);
            this.isDirty = true;
        } else {
            for (IEnergySink sink : grid.sinks) {
                if (this.sinks.add(sink)) continue;
                this.newSinks.add(sink);
            }
            for (IEnergySource source : grid.sources) {
                if (this.sources.add(source)) continue;
                this.newSources.add(source);
            }
        }
        this.pathMap.addAll(grid.pathMap);
        if (grid.sources.size() > 0 || grid.sinks.size() > 0) {
            ++this.addedGrids;
        }
        for (IEnergyConductor cable : this.cables) {
            this.connectionMap.put(cable, new WireConnection(cable, this));
        }
        this.didCombine = true;
    }

    public void addGrid(EnergyNetGrid grid) {
        this.cables.addAll(grid.cables);
        this.sinks.addAll(grid.sinks);
        this.sources.addAll(grid.sources);
        this.newSources.addAll(grid.sources);
        this.newSinks.addAll(grid.newSinks);
        for (IEnergyConductor cable : this.cables) {
            this.connectionMap.put(cable, new WireConnection(cable, this));
        }
        this.didCombine = true;
    }

    public void finishCombining() {
        if (this.didCombine) {
            this.didCombine = false;
            if (this.addedGrids > 1) {
                this.newSinks.addAll(this.sinks);
                this.newSources.addAll(this.sources);
            }
            this.addedGrids = 0;
            this.isDirty = this.isDirty || this.newSources.size() > 0 && this.sinks.size() > 0 || this.newSinks.size() > 0 && this.sources.size() > 0;
            for (IEnergyConductor cable : this.cables) {
                this.local.addWireToGrid(cable, this.getGridID());
            }
            if (this.isDirty) {
                this.local.markGridDirty(this.getGridID());
            }
        }
    }

    public void removeSink(IEnergySink sink) {
        this.sinks.remove(sink);
        if (this.newSinks.size() > 0) {
            this.newSinks.remove(sink);
        }
        this.pathMap.removeSink(sink);
    }

    public void removeSource(IEnergySource source) {
        this.sources.remove(source);
        if (this.newSources.size() > 0) {
            this.newSources.remove(source);
        }
        this.pathMap.removeSource(source);
    }

    public void removeConductor(IEnergyConductor conductor) {
        this.cables.remove(conductor);
        this.pathMap.removeConductor(conductor);
        WireConnection wire = this.connectionMap.remove(conductor);
        if (wire != null) {
            this.connections.remove(wire);
            this.connections.addAll(wire.getNeighbors());
            wire.destroy();
        }
    }

    public void markForSplit() {
        this.isDirty = true;
        this.markSplit = true;
        this.local.markGridToSplit(this.getGridID());
    }

    public void processChanges() {
        if (this.isDirty) {
            this.isDirty = false;
            if (this.markSplit) {
                if (this.isSplit()) {
                    this.local.splitGrid(this);
                    return;
                }
                this.markSplit = false;
            }
            if (this.newSinks.size() > 0 && this.sources.size() > 0 || this.newSources.size() > 0 && this.sinks.size() > 0) {
                this.processPathChanges();
                if (this.reset) {
                    this.reset = false;
                }
            }
        }
    }

    private boolean isSplit() {
        int size = this.connectionMap.size();
        FilteredList<WireConnection> allWires = new FilteredList<WireConnection>(size);
        allWires.add(this.connections.iterator().next());
        HashSet<WireConnection> con = new HashSet<WireConnection>(this.connections);
        this.connections = new FilteredList<WireConnection>();
        LinkedList toDo = new LinkedList(allWires);
        boolean foundAll = false;
        int i = 1;
        while (toDo.size() > 0) {
            toDo.addAll(allWires.getAdded(((WireConnection)toDo.remove()).getNeighbors()));
            if (i % 10 == 0) {
                con.removeAll(allWires);
                if (con.isEmpty()) {
                    foundAll = true;
                    break;
                }
            }
            ++i;
        }
        if (foundAll) {
            return false;
        }
        return !foundAll || size != allWires.size();
    }

    private void processPathChanges() {
        List<EnergyNetLocal.EnergyPath> paths;
        HashSet<IEnergyTile> sourceTargets = new HashSet<IEnergyTile>(this.sinks);
        LinkedHashMap<IEnergySink, LinkedHashSet<IEnergySource>> sinkList = new LinkedHashMap<IEnergySink, LinkedHashSet<IEnergySource>>();
        for (IEnergySink iEnergySink : this.newSinks) {
            sinkList.put(iEnergySink, new LinkedHashSet<IEnergySource>(this.sources));
        }
        this.newSinks.clear();
        for (IEnergySource iEnergySource : this.newSources) {
            paths = this.local.discoverTargets(iEnergySource, sourceTargets, this.cables, false, this.local.getMaxEnergy(iEnergySource));
            this.pathMap.removePaths(paths);
            this.pathMap.addSourcePaths(iEnergySource, paths);
            for (EnergyNetLocal.EnergyPath path : paths) {
                Set sinkTodo = (Set)sinkList.get(path.target);
                if (sinkTodo == null) continue;
                sinkTodo.remove(iEnergySource);
                if (!sinkTodo.isEmpty()) continue;
                sinkList.remove(path.target);
            }
        }
        this.newSources.clear();
        if (sinkList.isEmpty()) {
            return;
        }
        for (Map.Entry entry : sinkList.entrySet()) {
            paths = this.local.discoverTargets((IEnergyTile)entry.getKey(), (Set)entry.getValue(), this.cables, true, Integer.MAX_VALUE);
            this.pathMap.removePaths(paths);
            this.pathMap.addSinkPaths((IEnergySink)entry.getKey(), paths);
        }
    }

    public void processSplit() {
        if (this.split) {
            this.split = false;
            LinkedHashMap todoList = new LinkedHashMap();
            for (IEnergySource source : this.newSources) {
                FilteredList<IEnergySink> storedSinks = new FilteredList<IEnergySink>((Collection<IEnergySink>)this.newSinks);
                for (EnergyNetLocal.EnergyPath path : this.pathMap.getSourcePaths(source)) {
                    storedSinks.remove(path.target);
                }
                if (storedSinks.size() <= 0) continue;
                for (int i = 0; i < storedSinks.size(); ++i) {
                    if (this.local.getTarget((IEnergyTile)storedSinks.get(i)).hasEmitters()) continue;
                    storedSinks.remove(i--);
                }
                if (storedSinks.size() <= 0) continue;
                todoList.put(source, storedSinks);
            }
            for (IEnergySink sink : this.newSinks) {
                FilteredList<IEnergySource> storedSources = new FilteredList<IEnergySource>((Collection<IEnergySource>)this.newSources);
                for (EnergyNetLocal.EnergyPath path : this.pathMap.getSinkPaths(sink)) {
                    storedSources.remove(path.emitter);
                }
                if (storedSources.size() <= 0) continue;
                for (int i = 0; i < storedSources.size(); ++i) {
                    IEnergySource source = (IEnergySource)storedSources.get(i);
                    if (!this.local.getTarget(source).hasReceivers()) continue;
                    FilteredList list = (FilteredList)todoList.get(source);
                    if (list == null) {
                        list = new FilteredList();
                        todoList.put(source, list);
                    }
                    list.add(sink);
                }
            }
            this.newSinks.clear();
            this.newSources.clear();
            if (todoList.size() > 0) {
                HashSet<IEnergyConductor> cableset = new HashSet<IEnergyConductor>(this.cables);
                for (Map.Entry entry : todoList.entrySet()) {
                    IEnergySource source = (IEnergySource)entry.getKey();
                    HashSet<IEnergyTile> targets = new HashSet<IEnergyTile>((Collection)entry.getValue());
                    this.pathMap.addSourcePaths(source, this.local.discoverTargets(source, targets, cableset, false, this.local.getMaxEnergy(source)));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnergyNetGrid) {
            EnergyNetGrid grid = (EnergyNetGrid)obj;
            return grid.getGridID().equals(this.getGridID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getGridID().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", ID: " + this.getGridID();
    }

    public void unload() {
        this.newSinks.clear();
        this.newSources.clear();
        this.sinks.clear();
        this.sources.clear();
        this.cables.clear();
        this.pathMap.clear();
        this.connectionMap.clear();
        this.connections.clear();
        this.local = null;
    }

    public Set<IEnergySource> getSources() {
        return this.sources;
    }

    public Set<IEnergySink> getSinks() {
        return this.sinks;
    }

    public static class WireConnection
    implements Iterable<WireConnection> {
        IEnergyConductor wire;
        FilteredList<WireConnection>[] connections = WireConnection.createList(6);
        List<EnumFacing> dirs = new ArrayList<EnumFacing>();
        int count = 0;
        int hashCode;

        public WireConnection(IEnergyConductor par1, EnergyNetGrid par2) {
            this.wire = par1;
            this.hashCode = Objects.hash(this.wire);
            for (EnergyNetLocal.EnergyTarget target : par2.local.getTarget(par1).getBoth()) {
                EnumFacing dir;
                EnumFacing oppo;
                WireConnection con;
                if (!(target.targetTile instanceof IEnergyConductor) || (con = par2.connectionMap.get(target.targetTile)) == null || !con.add(this, oppo = (dir = target.targetDirection.toFacing()).func_176734_d())) continue;
                this.add(con, dir);
            }
        }

        public void destroy() {
            this.wire = null;
            this.count = 0;
            this.dirs.clear();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                for (WireConnection entry : this.connections[dir.func_176745_a()]) {
                    entry.remove(this, dir.func_176734_d());
                }
            }
        }

        public int getNeighborCount() {
            return this.count;
        }

        public boolean add(WireConnection connect, EnumFacing dir) {
            if (this.connections[dir.func_176745_a()].add(connect)) {
                ++this.count;
                this.dirs.add(dir);
                return true;
            }
            return false;
        }

        public void remove(WireConnection connect, EnumFacing dir) {
            FilteredList<WireConnection> list = this.connections[dir.func_176745_a()];
            if (list.remove(connect)) {
                --this.count;
                if (list.isEmpty()) {
                    this.dirs.remove(dir);
                }
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WireConnection) {
                WireConnection con = (WireConnection)obj;
                return con.wire == this.wire;
            }
            return false;
        }

        @Override
        public Iterator<WireConnection> iterator() {
            return new Iterator<WireConnection>(){
                int dir = 0;
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.dir < dirs.size() && this.index < connections[dirs.get(this.dir).func_176745_a()].size();
                }

                @Override
                public WireConnection next() {
                    FilteredList<WireConnection> list = connections[dirs.get(this.dir).func_176745_a()];
                    WireConnection con = (WireConnection)list.get(this.index);
                    if (++this.index >= list.size()) {
                        ++this.dir;
                        this.index = 0;
                    }
                    return con;
                }
            };
        }

        public Collection<WireConnection> getNeighbors() {
            return new AbstractIterator<WireConnection>(){

                @Override
                public Iterator<WireConnection> iterator() {
                    return this.iterator();
                }

                @Override
                public int size() {
                    return count;
                }
            };
        }

        private static FilteredList<WireConnection>[] createList(int amount) {
            FilteredList[] result = new FilteredList[amount];
            for (int i = 0; i < amount; ++i) {
                result[i] = new FilteredList();
            }
            return result;
        }
    }

    public static class GridID {
        static int lastGridID = 0;
        final int id;

        public GridID(int par1) {
            this.id = par1;
        }

        public int getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Grid ID: " + this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GridID) {
                return ((GridID)obj).id == this.id;
            }
            return false;
        }

        public static GridID createNewID() {
            return new GridID(lastGridID++);
        }
    }
}

