/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.fluid;

import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IC2Fluid
extends Fluid {
    public static Map<String, Fluid> fluids = new HashMap<String, Fluid>();
    LocaleComp comp;
    String type;
    boolean both;
    ResourceLocation[] icons = new ResourceLocation[2];

    public IC2Fluid(String fluidName) {
        this(new LangComponentHolder.LocaleFluidComp("fluid." + fluidName), fluidName);
    }

    public IC2Fluid(LocaleComp fluidName, String type) {
        super(IC2Fluid.getID(fluidName), new ResourceLocation("missingno"), new ResourceLocation("missingno"));
        this.type = type;
        this.comp = fluidName;
        FluidRegistry.registerFluid((Fluid)this);
        this.setTextures();
    }

    private static String getID(LocaleComp comp) {
        return comp.getUnlocalized().replace("fluid.", "");
    }

    public IC2Fluid setNoneSingleTexture() {
        this.both = true;
        this.setTextures();
        return this;
    }

    public static void createFluid(String id, Fluid fluid) {
        fluids.put(id, fluid);
    }

    public static Fluid getFluid(String id) {
        return fluids.get(id);
    }

    public static FluidStack getFluidStack(String id, int amount) {
        return new FluidStack(fluids.get(id), amount);
    }

    public String getLocalizedName(FluidStack stack) {
        return this.comp.getLocalized();
    }

    public String getUnlocalizedName() {
        return this.comp.getUnlocalizedFully();
    }

    private void setTextures() {
        if (!this.both) {
            ResourceLocation texture;
            this.icons[0] = texture = new ResourceLocation("ic2", "blocks/fluids/" + this.type + "_still");
            this.icons[1] = texture;
            return;
        }
        this.icons[0] = new ResourceLocation("ic2", "blocks/fluids/" + this.type + "_still");
        this.icons[1] = new ResourceLocation("ic2", "blocks/fluids/" + this.type + "_flowing");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTexture(TextureMap map) {
        if (!this.both) {
            map.setTextureEntry((TextureAtlasSprite)new FluidIcon(this.icons[0].toString()));
            return;
        }
        map.setTextureEntry((TextureAtlasSprite)new FluidIcon(this.icons[0].toString()));
        map.setTextureEntry((TextureAtlasSprite)new FluidIcon(this.icons[1].toString()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadFluids(TextureMap map) {
        for (Map.Entry<String, Fluid> entry : fluids.entrySet()) {
            Fluid fluid = entry.getValue();
            if (!(fluid instanceof IC2Fluid)) continue;
            ((IC2Fluid)fluid).registerTexture(map);
        }
    }

    public ResourceLocation getFlowing() {
        return this.icons[1];
    }

    public ResourceLocation getStill() {
        return this.icons[0];
    }

    public static class FluidIcon
    extends TextureAtlasSprite {
        public FluidIcon(String spriteName) {
            super(spriteName);
        }
    }
}

