/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.items;

import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.inventory.management.SlotType;
import ic2.core.item.inv.inventories.InventorySlotTypeUpgrade;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotTypeComp
extends GuiComponent {
    InventorySlotTypeUpgrade data;

    public SlotTypeComp(InventorySlotTypeUpgrade tile) {
        super(Ic2GuiComp.nullBox);
        this.data = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int max = Math.min(4, this.data.types.length - this.data.offset);
        for (int i = 0; i < max; ++i) {
            SlotType type = this.data.types[this.data.offset + i];
            if (type == null) continue;
            int boost = 30 * i;
            gui.drawString(Ic2GuiLang.invUpgradeSlotType.getLocalizedFormatted(type.getLocalizedName()), 4, 20 + boost, 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        int max = Math.min(4, this.data.types.length - this.data.offset);
        for (int i = 0; i < max; ++i) {
            int boost = 30 * i;
            Set<EnumFacing> sides = this.data.sides[this.data.offset + i];
            for (int z = 0; z < 6; ++z) {
                EnumFacing side = EnumFacing.func_82600_a((int)z);
                gui.registerButton(new ToggleButton(z + 6 * i, x + 4 + z * 21, y + 28 + boost, 20, 20).setIcon(Ic2Items.displayIcons[2 + side.func_176745_a()].func_77946_l()).setState(sides.contains(side)).addToolTip(Ic2Lang.getFacingComp(side)));
            }
        }
        gui.registerButton(new IC2Button(100, x + 152, y + 5, 20, 10, "-"));
        gui.registerButton(new IC2Button(101, x + 152, y + 118, 20, 10, "+"));
        gui.registerButton(new IC2Button(102, x + 130, y + 129, 42, 10, Ic2GuiLang.saveButton));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        int max = Math.min(4, this.data.types.length - this.data.offset);
        for (int i = 0; i < max; ++i) {
            Set<EnumFacing> sides = this.data.sides[this.data.offset + i];
            for (int x = 0; x < 6; ++x) {
                gui.getCastedButton(i * 6 + x, ToggleButton.class).setState(sides.contains(EnumFacing.func_82600_a((int)x)));
            }
        }
        gui.getButton((int)100).field_146124_l = this.data.offset > 0;
        gui.getButton((int)101).field_146124_l = this.data.offset + 4 < this.data.types.length;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id < 30) {
            Set<EnumFacing> set = this.data.sides[id / 6 + this.data.offset];
            EnumFacing side = EnumFacing.func_82600_a((int)id);
            if (set.contains(side)) {
                set.remove(side);
            } else {
                set.add(side);
            }
        }
        if (id == 100 && this.data.offset > 0) {
            --this.data.offset;
        }
        if (id == 101 && this.data.offset + 4 < this.data.types.length) {
            ++this.data.offset;
        }
        if (id == 102) {
            PayloadFieldPacket fields = new PayloadFieldPacket(0, this.data.types.length * 2 + 1, 1);
            fields.addFlag(0, this.data.isOffHand);
            fields.addNumber(0, this.data.types.length);
            for (int i = 0; i < this.data.types.length; ++i) {
                SlotType type = this.data.types[i];
                if (type == null) continue;
                RotationList list = new RotationList(this.data.sides[i]);
                int slot = i * 2 + 1;
                FMLLog.getLogger().info("Test: " + slot);
                fields.addNumber(slot, type.getID());
                fields.addNumber(slot + 1, list.writeToNumber());
            }
            IC2.network.get().initiateCustomClientItemEvent(this.data.item, fields);
        }
    }
}

