/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.management;

import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;

public final class SlotType {
    public static SlotType[] registered = new SlotType[512];
    public static SlotType Input = new SlotType(0, "input");
    public static SlotType SecondInput = new SlotType(1, "secondInput");
    public static SlotType Output = new SlotType(2, "output");
    public static SlotType Fuel = new SlotType(3, "fuel");
    public static SlotType FluidFuel = new SlotType(4, "fluidFuel");
    public static SlotType Charge = new SlotType(5, "charge");
    public static SlotType Discharge = new SlotType(6, "discharge");
    public static SlotType Reactor = new SlotType(7, "reactor");
    public static SlotType Tools = new SlotType(8, "tools");
    public static SlotType BatteryStation = new SlotType(9, "batteryStation");
    public static SlotType Fertilzer = new SlotType(10, "fertilizer");
    public static SlotType Hydration = new SlotType(11, "hydration");
    public static SlotType WeedEx = new SlotType(12, "weedEx");
    public static SlotType Book = new SlotType(13, "books");
    public static SlotType Storage = new SlotType(14, "storage");
    LocaleComp comp;
    int typeID;

    private SlotType(int id, String name) {
        this.typeID = id;
        this.comp = new LangComponentHolder.LocaleSlotTypeComp("slotType." + name + ".name");
        if (registered[id] != null) {
            throw new RuntimeException("SlotTypeID already used");
        }
        SlotType.registered[id] = this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SlotType) {
            return ((SlotType)obj).getID() == this.getID();
        }
        return false;
    }

    public int getID() {
        return this.typeID;
    }

    public String getUnlocalizedName() {
        return this.comp.getUnlocalized();
    }

    public LocaleComp getComponent() {
        return this.comp;
    }

    public String getLocalizedName() {
        return this.comp.getLocalized();
    }

    public static SlotType getTypeFromID(int id) {
        if (id < registered.length) {
            return registered[id];
        }
        return null;
    }
}

