/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.base;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.entity.IC2DamageSource;
import ic2.core.item.armor.base.ItemIC2ArmorBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemElectricArmorBase
extends ItemIC2ArmorBase
implements IDamagelessElectricItem,
ISpecialArmor,
IElectricTool {
    public int maxCharge;
    public int transferLimit;
    public int tier;

    public ItemElectricArmorBase(int index, EntityEquipmentSlot equipmentSlotIn, int maxCharge, int transferLimit, int tier) {
        super(ItemArmor.ArmorMaterial.DIAMOND, index, equipmentSlotIn);
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    @Override
    public ItemStack getRepairItem() {
        return null;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack full = new ItemStack((Item)this);
        ItemStack empty = new ItemStack((Item)this);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        subItems.add((Object)empty);
        subItems.add((Object)full);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c() && !this.isBlockingEverything()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (source.func_76355_l().equals(IC2DamageSource.electricity.func_76355_l()) && IC2.config.getFlag("SpecialElectricArmor")) {
            if (!ItemElectricArmorBase.hasElectricBoots(player)) {
                return new ISpecialArmor.ArmorProperties(0, 1.0, this.maxCharge - (int)ElectricItem.manager.getCharge(armor));
            }
            return new ISpecialArmor.ArmorProperties(0, 1.0, Integer.MAX_VALUE);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        double energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0.0 ? 25.0 * ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (energyPerDamage *= (double)IC2.config.getFloat("electricSuitEnergyCostModifier")) : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio *= (double)IC2.config.getFloat("electricSuitAbsorbtionScale"), damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio() * (double)IC2.config.getFloat("electricSuitAbsorbtionScale"));
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source.func_76355_l().equals(IC2DamageSource.electricity.func_76355_l()) && IC2.config.getFlag("SpecialElectricArmor")) {
            int max = (int)(this.getMaxCharge(stack) - ElectricItem.manager.getCharge(stack));
            if (max > 0) {
                ElectricItem.manager.charge(stack, damage, Integer.MAX_VALUE, true, false);
                return;
            }
            if (ItemElectricArmorBase.hasElectricBoots(entity)) {
                return;
            }
        }
        this.useEnergy(stack, (float)damage * ((float)this.getEnergyPerDamage() * IC2.config.getFloat("electricSuitAbsorbtionScale")), entity);
        if (entity instanceof EntityPlayer) {
            this.damageAbsorbed((EntityPlayer)entity, damage);
        }
    }

    public void damageAbsorbed(EntityPlayer player, int damage) {
    }

    public void useEnergy(ItemStack stack, double amount, EntityLivingBase player) {
        ElectricItem.manager.use(stack, amount, player);
    }

    public boolean canUseEnergy(ItemStack stack, double amount) {
        return ElectricItem.manager.canUse(stack, amount);
    }

    public boolean isBlockingEverything() {
        return false;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    private double getBaseAbsorptionRatio() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 0.15;
            }
            case CHEST: {
                return 0.4;
            }
            case LEGS: {
                return 0.3;
            }
            case FEET: {
                return 0.3;
            }
        }
        return 0.0;
    }

    public static boolean hasElectricBoots(EntityLivingBase base) {
        ItemStack stack = base.func_184582_a(EntityEquipmentSlot.FEET);
        if (stack == null || !(stack.func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        return !base.field_70170_p.func_175623_d(base.func_180425_c().func_177977_b());
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        switch (this.field_77881_a) {
            case CHEST: {
                return EnumEnchantmentType.ARMOR_CHEST;
            }
            case FEET: {
                return EnumEnchantmentType.ARMOR_FEET;
            }
            case HEAD: {
                return EnumEnchantmentType.ARMOR_HEAD;
            }
            case LEGS: {
                return EnumEnchantmentType.ARMOR_LEGS;
            }
        }
        return EnumEnchantmentType.ARMOR;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_92091_k || ench == Enchantments.field_185296_A;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }
}

