/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.classic.item.ICropAnalyzer;
import ic2.api.classic.item.IEUReader;
import ic2.api.classic.item.IThermometer;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.entity.IC2Potion;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import ic2.core.item.misc.ItemTinCan;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorQuantumSuit
extends ItemElectricArmorBase
implements IMetalArmor,
IColorEffectedTexture,
IEUReader,
IThermometer,
ICropAnalyzer {
    public ItemArmorQuantumSuit(int index, EntityEquipmentSlot equipmentSlotIn) {
        super(index, equipmentSlotIn, 1000000, 1000, 3);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public boolean isCropAnalyzer(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("CropUpgrade");
    }

    @Override
    public boolean isThermometer(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("ThermometerUpgrade");
    }

    @Override
    public boolean isEUReader(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("EUReaderUpgrade");
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return !StackUtil.getNbtData(stack).func_74767_n("HideDurability");
    }

    @Override
    public int getEnergyPerDamage() {
        return 900;
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/quantum";
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbt = stack.func_179543_a("display");
        if (nbt != null) {
            return nbt.func_74764_b("color");
        }
        return false;
    }

    @Override
    public boolean hasOverlay(ItemStack stack) {
        return this.func_82816_b_(stack);
    }

    public void func_82813_b(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color", color);
    }

    public int func_82814_b(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74775_l("display").func_74762_e("color");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == EntityEquipmentSlot.FEET) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (double)energyPerDamage : 0.0);
            return new ISpecialArmor.ArmorProperties(10, (double)(1.0f * IC2.config.getFloat("electricSuitAbsorbtionScale")), damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public void damageAbsorbed(EntityPlayer player, int damage) {
        IC2.achievements.issueStat(player, "quantumArmorDamageTaken", damage);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        boolean server = IC2.platform.isSimulating();
        switch (this.field_77881_a) {
            case HEAD: {
                PotionEffect wither;
                PotionEffect radiation;
                if (!server) break;
                int air = player.func_70086_ai();
                if (air < 100 && this.canUseEnergy(stack, 1000.0)) {
                    player.func_70050_g(air + 200);
                    this.useEnergy(stack, 1000.0, (EntityLivingBase)player);
                } else if (air <= 0) {
                    IC2.achievements.issueStat(player, "drownWithQHelmet");
                }
                if (player.func_71024_bL().func_75121_c() && this.canUseEnergy(stack, 1000.0)) {
                    ItemStack result;
                    IItemTransporter trans = TransporterManager.manager.getTransporter(player, true);
                    if (trans != null && !(result = trans.removeItem(ItemTinCan.foodCanFilter, EnumFacing.DOWN, 1, true)).func_190926_b()) {
                        ItemTinCan can = (ItemTinCan)result.func_77973_b();
                        can.onFoodEaten(result, world, player);
                        this.useEnergy(stack, 1000.0, (EntityLivingBase)player);
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueStat(player, "starveWithQHelmet");
                }
                PotionEffect poison = player.func_70660_b(MobEffects.field_76436_u);
                if (poison != null && this.canUseEnergy(stack, 10000 * poison.func_76458_c())) {
                    this.useEnergy(stack, 10000 * poison.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76436_u);
                }
                if ((radiation = player.func_70660_b((Potion)IC2Potion.radiation)) != null && this.canUseEnergy(stack, 20000 * radiation.func_76458_c())) {
                    this.useEnergy(stack, 20000 * radiation.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, IC2Potion.radiation);
                }
                if ((wither = player.func_70660_b(MobEffects.field_82731_v)) == null || !this.canUseEnergy(stack, 25000 * wither.func_76458_c())) break;
                this.useEnergy(stack, 25000 * wither.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_82731_v);
                break;
            }
            case CHEST: {
                player.func_70066_B();
                break;
            }
            case LEGS: {
                PlayerHandler handler = PlayerHandler.getHandlerForPlayer(player);
                if (!this.canUseEnergy(stack, 1000.0) || (!handler.quantumArmorBoostSprint || !player.func_70051_ag()) && (!handler.boostKeyDown || !(Math.abs(player.field_70159_w) + Math.abs(player.field_70179_y) > 0.1000000014901161))) break;
                if (++handler.quantumSpeedTicker >= 10) {
                    handler.quantumSpeedTicker = 0;
                    this.useEnergy(stack, 1000.0, (EntityLivingBase)player);
                }
                player.func_191958_b(0.0f, 0.0f, 1.0f, player.func_70090_H() ? 0.1f : 0.22f);
                break;
            }
            case FEET: {
                PlayerHandler handler = PlayerHandler.getHandlerForPlayer(player);
                if (handler.quantumJumpCharge < 1.0f && player.field_70122_E && this.canUseEnergy(stack, 1000.0)) {
                    handler.quantumJumpCharge = 1.0f;
                    this.useEnergy(stack, 1000.0, (EntityLivingBase)player);
                }
                if (!(player.field_70181_x >= 0.0 & handler.quantumJumpCharge > 0.0f) || player.func_70090_H()) break;
                if (handler.jumpKeyDown && handler.boostKeyDown) {
                    if (handler.quantumJumpCharge == 1.0f) {
                        player.field_70159_w *= 3.5;
                        player.field_70179_y *= 3.5;
                    }
                    player.field_70181_x += (double)(handler.quantumJumpCharge * 0.3f);
                    handler.quantumJumpCharge *= 0.75f;
                    break;
                }
                if (!(handler.quantumJumpCharge < 1.0f)) break;
                handler.quantumJumpCharge = 0.0f;
                break;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> shiftTip = sortedTooltip.get((Object)ToolTipType.Shift);
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        switch (this.field_77881_a) {
            case CHEST: {
                shiftTip.add(Ic2InfoLang.qArmorRemovesFire.getLocalized());
                break;
            }
            case FEET: {
                ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(1), Ic2InfoLang.qArmorHighJump));
                break;
            }
            case HEAD: {
                shiftTip.add(Ic2InfoLang.qArmorFeedsYou.getLocalized());
                shiftTip.add(Ic2InfoLang.qArmorRemovePotions.getLocalized());
                shiftTip.add(Ic2InfoLang.qArmorGivesAir.getLocalized());
                NBTTagCompound nbt = StackUtil.getNbtData(stack);
                if (nbt.func_74764_b("EUReaderUpgrade")) {
                    shiftTip.add(Ic2Lang.upgradeEU.getLocalized());
                }
                if (nbt.func_74764_b("CropUpgrade")) {
                    shiftTip.add(Ic2Lang.upgradeCrop.getLocalized());
                }
                if (!nbt.func_74764_b("ThermometerUpgrade")) break;
                shiftTip.add(Ic2Lang.upgradeThermo.getLocalized());
                break;
            }
            case LEGS: {
                ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(1), Ic2InfoLang.qArmorHighSpeed));
                break;
            }
        }
    }
}

