/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.IC2;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.cables.CableContainer;
import ic2.core.block.wiring.cables.IWireInformation;
import ic2.core.block.wiring.cables.WireRegistry;
import ic2.core.block.wiring.tile.TileEntityCable;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.tool.ItemToolPainter;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.IMetaSoundBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCable
extends ItemIC2
implements IBootable {
    public static WireRegistry registry = WireRegistry.instance;
    private Block block = null;

    public ItemCable() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.copperCable);
    }

    @Override
    public void onLoad() {
        Ic2Items.copperCable = this.getStackFromType(0, 0);
        Ic2Items.insulatedCopperCable = this.getStackFromType(0, 1);
        Ic2Items.goldCable = this.getStackFromType(1, 0);
        Ic2Items.insulatedGoldCable = this.getStackFromType(1, 1);
        Ic2Items.doubleInsulatedGoldCable = this.getStackFromType(1, 2);
        Ic2Items.ironCable = this.getStackFromType(2, 0);
        Ic2Items.insulatedIronCable = this.getStackFromType(2, 1);
        Ic2Items.doubleInsulatedIronCable = this.getStackFromType(2, 2);
        Ic2Items.tribbleInsulatedIronCable = this.getStackFromType(2, 3);
        Ic2Items.glassFiberCable = this.getStackFromType(3, 0);
        Ic2Items.tinCable = this.getStackFromType(4, 0);
        Ic2Items.detectorCable = this.getStackFromType(5, 0);
        Ic2Items.splitterCable = this.getStackFromType(6, 0);
        Ic2Items.bronzeCable = this.getStackFromType(7, 0);
        Ic2Items.insulatedBronzeCable = this.getStackFromType(7, 1);
        Ic2Items.doubleInsulatedBronzeCable = this.getStackFromType(7, 2);
        Ic2Items.plasmaCable = this.getStackFromType(8, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader()) {
            CableContainer container = BlockCable.registry.getContainerFromMeta(stack.func_77960_j());
            IWireInformation info = container.getInfo();
            tooltip.add(Ic2InfoLang.euReaderCableLimit.getLocalizedFormatted((int)(info.getConductorBreakdownEnergy(container.getInsulation()) - 1.0)));
            tooltip.add(Ic2InfoLang.euReaderCableLoss.getLocalizedFormatted(Ic2Formatters.enetFormat.format(info.getConductorLoss(container.getInsulation()))));
        }
    }

    protected ItemStack getStackFromType(int type, int insulation) {
        return new ItemStack((Item)this, 1, registry.getMetaFromType(type, insulation));
    }

    public int func_77647_b(int damage) {
        return registry.getTypeFromMeta(damage);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        CableContainer cont = registry.getContainerFromMeta(stack.func_77960_j());
        return cont.getInfo().getName(cont.getInsulation());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(stack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, stack) && worldIn.func_190527_a(block, pos, false, facing, (Entity)null)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = this.getBlock().getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileEntityCable) {
                    EnumDyeColor color;
                    ItemStack offHand;
                    TileEntityCable cable = (TileEntityCable)tile;
                    cable.setInsulation(registry.getInsulationFromMeta(stack.func_77960_j()));
                    if (hand == EnumHand.MAIN_HAND && (offHand = player.func_184586_b(EnumHand.OFF_HAND)) != null && offHand.func_77973_b() == Ic2Items.painters[0].func_77973_b() && cable.changeColor(IEnergyConductorColored.WireColor.fromColor(color = EnumDyeColor.func_176766_a((int)offHand.func_77960_j())), null)) {
                        ItemToolPainter.damagePainter(offHand, player, EnumHand.OFF_HAND);
                    }
                }
                if (IC2.platform.isRendering()) {
                    SoundType soundtype = this.getSound(iblockstate1);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.getBlock()) {
            this.getBlock().func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            return true;
        }
        return false;
    }

    public SoundType getSound(IBlockState state) {
        SoundType type;
        if (state.func_177230_c() instanceof IMetaSoundBlock && (type = ((IMetaSoundBlock)state.func_177230_c()).getSoundFromState(state)) != null) {
            return type;
        }
        return this.getBlock().func_185467_w();
    }

    protected Block getBlock() {
        if (this.block == null) {
            this.block = Ic2States.copperCable.func_177230_c();
        }
        return this.block;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < registry.getMaxMeta(); ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public List<Integer> getValidVariants() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < registry.getMaxMeta(); ++i) {
            list.add(i);
        }
        return list;
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        CableContainer cont = registry.getContainerFromMeta(meta);
        return Ic2Icons.getTextures("i0")[cont.getInfo().getItemIcon(cont.getInsulation())];
    }
}

