/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.RotationList;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.SlotType;
import ic2.core.item.inv.container.ContainerSlotTypeUpgrade;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class InventorySlotTypeUpgrade
implements IHasGui {
    public boolean isOffHand;
    public ItemStack item;
    public SlotType[] types;
    public Set<EnumFacing>[] sides;
    public int offset = 0;

    public InventorySlotTypeUpgrade(ItemStack stack, EnumHand hand) {
        this.isOffHand = hand == EnumHand.OFF_HAND;
        this.item = stack;
        NBTTagList list = StackUtil.getOrCreateNbtData(stack).func_150295_c("Data", 10);
        this.types = new SlotType[list.func_74745_c()];
        this.sides = this.createArray(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            SlotType type = SlotType.getTypeFromID(data.func_74762_e("ID"));
            if (type == null) continue;
            this.types[i] = type;
            this.sides[i].addAll(Arrays.asList(RotationList.readFromNumber(data.func_74771_c("Sides")).getFacings()));
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSlotTypeUpgrade(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !player.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    private Set<EnumFacing>[] createArray(int count) {
        Set[] array = new Set[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = EnumSet.noneOf(EnumFacing.class);
        }
        return array;
    }
}

