/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.api.classic.event.ScrapBoxEvent;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.custom.IClassicScrapBoxManager;
import ic2.api.recipe.Recipes;
import ic2.core.IC2;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemScrapBox
extends ItemIC2
implements IBootable {
    public ItemScrapBox() {
        this.setUnlocalizedName(Ic2ItemLang.scrapBox);
    }

    @Override
    public void onLoad() {
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorScrapboxDispense());
        Ic2Items.scrapBox = new ItemStack((Item)this);
    }

    public static void init() {
        if (IC2.config.getFlag("SuddenlyHoes")) {
            ItemScrapBox.addDrop(Items.field_151017_I, 9001.0f);
        } else {
            ItemScrapBox.addDrop(Items.field_151017_I, 5.01f);
        }
        ItemScrapBox.addDrop(Blocks.field_150346_d, 5.0f);
        ItemScrapBox.addDrop((Block)Blocks.field_150349_c, 3.0f);
        ItemScrapBox.addDrop(Blocks.field_150351_n, 3.0f);
        ItemScrapBox.addDrop(Blocks.field_150424_aL, 2.0f);
        ItemScrapBox.addDrop(Blocks.field_150425_aM);
        ItemScrapBox.addDrop(Blocks.field_150423_aK, 0.9f);
        ItemScrapBox.addDrop(Blocks.field_150366_p, 0.5f);
        ItemScrapBox.addDrop(Blocks.field_150352_o, 0.5f);
        ItemScrapBox.addDrop(Ic2Items.copperOre.func_77946_l(), 0.7f);
        ItemScrapBox.addDrop(Ic2Items.tinOre.func_77946_l(), 0.7f);
        ItemScrapBox.addDrop(Ic2Items.silverOre.func_77946_l(), 0.6f);
        ItemScrapBox.addDrop(Items.field_151137_ax, 0.9f);
        ItemScrapBox.addDrop(Ic2Items.coalDust.func_77946_l(), 0.8f);
        ItemScrapBox.addDrop(Ic2Items.copperDust.func_77946_l(), 0.8f);
        ItemScrapBox.addDrop(Ic2Items.tinDust.func_77946_l(), 0.8f);
        ItemScrapBox.addDrop(Ic2Items.plantBall.func_77946_l(), 0.7f);
        ItemScrapBox.addDrop(Ic2Items.ironDust.func_77946_l(), 0.7f);
        ItemScrapBox.addDrop(Ic2Items.goldDust.func_77946_l(), 0.7f);
        ItemScrapBox.addDrop(Items.field_151045_i, 0.1f);
        ItemScrapBox.addDrop(Items.field_151166_bC, 0.05f);
        ItemScrapBox.addDrop(Items.field_151114_aO, 0.8f);
        ItemScrapBox.addDrop(Ic2Items.rubber.func_77946_l(), 0.8f);
        ItemScrapBox.addDrop(Items.field_151041_m);
        ItemScrapBox.addDrop(Items.field_151038_n);
        ItemScrapBox.addDrop(Items.field_151039_o);
        ItemScrapBox.addDrop(Items.field_151055_y, 4.0f);
        ItemScrapBox.addDrop(Items.field_151155_ap);
        ItemScrapBox.addDrop(Items.field_151078_bh, 2.0f);
        ItemScrapBox.addDrop(Items.field_151034_e, 1.5f);
        ItemScrapBox.addDrop(Items.field_151025_P, 1.5f);
        ItemScrapBox.addDrop(Ic2Items.filledTinCan.func_77946_l(), 1.5f);
        ItemScrapBox.addDrop(Items.field_151105_aU, 0.5f);
        ItemScrapBox.addDrop(Items.field_151157_am, 0.9f);
        ItemScrapBox.addDrop(Items.field_151083_be, 0.9f);
        ItemScrapBox.addDrop(Items.field_151077_bg, 0.9f);
        ItemScrapBox.addDrop(Items.field_179557_bn, 0.9f);
        ItemScrapBox.addDrop(Items.field_179559_bp, 0.9f);
        ItemScrapBox.addDrop(Items.field_151116_aA);
        ItemScrapBox.addDrop(Items.field_151008_G);
        ItemScrapBox.addDrop(Items.field_151103_aS);
        ItemScrapBox.addDrop(Items.field_151123_aH, 0.6f);
        ItemScrapBox.addDrop((Item)Items.field_151169_ag, 0.05f);
        ItemScrapBox.addDrop(Items.field_151073_bk, 0.08f);
        ItemScrapBox.addDrop(Items.field_151156_bN, 0.001f);
        ItemScrapBox.addDrop(Items.field_151143_au, 0.09f);
        ItemScrapBox.addDrop(Ic2Items.suBattery.func_77946_l(), 0.7f);
    }

    public static void addDrop(Item item) {
        ItemScrapBox.addDrop(new ItemStack(item), 1.0f);
    }

    public static void addDrop(Item item, float chance) {
        ItemScrapBox.addDrop(new ItemStack(item), chance);
    }

    public static void addDrop(Block block) {
        ItemScrapBox.addDrop(new ItemStack(block), 1.0f);
    }

    public static void addDrop(Block block, float chance) {
        ItemScrapBox.addDrop(new ItemStack(block), chance);
    }

    public static void addDrop(ItemStack item) {
        ItemScrapBox.addDrop(item, 1.0f);
    }

    public static void addDrop(ItemStack item, float chance) {
        Recipes.scrapboxDrops.addDrop(item, chance);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 66;
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating()) {
            IClassicScrapBoxManager.IDrop drop = ClassicRecipes.scrapboxDrops.getRandomDrop(stack, false);
            if (drop != null && drop.getDrop() != null) {
                if (drop.getRawChance() <= 0.1f) {
                    IC2.achievements.issueStat(playerIn, "luckyPerson");
                }
                ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                results.add(drop.getDrop());
                MinecraftForge.EVENT_BUS.post((Event)new ScrapBoxEvent.ScrapBoxPlayerUseEvent(stack, results, playerIn, handIn));
                if (!results.isEmpty()) {
                    for (int i = 0; i < results.size(); ++i) {
                        playerIn.func_71019_a((ItemStack)results.get(i), false);
                    }
                }
            }
            stack.func_190918_g(1);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public static class BehaviorScrapboxDispense
    extends BehaviorDefaultDispenseItem {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ItemStack drop = Recipes.scrapboxDrops.getDrop(stack, false);
            if (drop != null) {
                ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                results.add(drop);
                MinecraftForge.EVENT_BUS.post((Event)new ScrapBoxEvent.ScrapBoxDispenseEvent(stack, results, source));
                if (!results.isEmpty()) {
                    IPosition pos = BlockDispenser.func_149939_a((IBlockSource)source);
                    EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                    for (int i = 0; i < results.size(); ++i) {
                        BehaviorScrapboxDispense.func_82486_a((World)source.func_82618_k(), (ItemStack)((ItemStack)results.get(i)), (int)6, (EnumFacing)facing, (IPosition)pos);
                    }
                }
            }
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
        }
    }
}

