/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlanner;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.reactor.IReactor;
import ic2.core.item.base.ItemGrandualInt;
import ic2.core.item.reactor.ItemReactorUraniumRod;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;

public class ItemReactorDepletedUranium
extends ItemGrandualInt
implements IReactorPlannerComponent,
IBootable {
    public ItemReactorDepletedUranium() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.depletedUran);
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            planner.addReEnrichPulse();
        }
        IUranium uran = this.getUran(stack);
        if (reactor instanceof ISteamReactor) {
            if (heatrun) {
                int myLevel = this.getCustomDamage(stack) - 1 - reactor.getHeat() / 3000;
                if (myLevel <= 0) {
                    reactor.setItemAt(youX, youY, uran.getRodType(IUranium.RodType.ReEnrichedRod));
                } else {
                    this.setCustomDamage(stack, myLevel);
                }
            }
            return true;
        }
        int myLevel = this.getCustomDamage(stack) - 1 - reactor.getHeat() / 3000;
        if (myLevel <= 0) {
            reactor.setItemAt(youX, youY, uran.getRodType(IUranium.RodType.ReEnrichedRod));
        } else {
            this.setCustomDamage(stack, myLevel);
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return 0.0f;
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.getUran(stack).getMaxDurability();
    }

    public IUranium getUran(ItemStack stack) {
        return ItemReactorUraniumRod.getUran(stack.func_77960_j());
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 160 + meta;
    }

    @Override
    public String getSheet(int meta) {
        return "i3";
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getUran(stack).getName(IUranium.RodType.IsotopicRod);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            items.add((Object)ItemReactorUraniumRod.getUran(i).getNewIsotopicRod());
        }
    }

    @Override
    public void onLoad() {
        Ic2Items.reactorUraniumIsotopicRod = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorRedstoneUraniumIsotopicRod = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorBlazeUraniumIsotopicRod = new ItemStack((Item)this, 1, 2);
        Ic2Items.reactorEnderPearlUraniumIsotopicRod = new ItemStack((Item)this, 1, 3);
        Ic2Items.reactorNetherStarUraniumIsotopicRod = new ItemStack((Item)this, 1, 4);
        Ic2Items.reactorCharcoalUraniumIsotopicRod = new ItemStack((Item)this, 1, 5);
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[6];
        for (int i = 0; i < 6; ++i) {
            items[i] = ItemReactorUraniumRod.getUran(i).getNewIsotopicRod();
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return null;
    }

    @Override
    public short getID(ItemStack stack) {
        return this.getUran(stack).getRodID(IUranium.RodType.IsotopicRod);
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.IsotopeCell;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        IUranium uran = this.getUran(stack);
        if (uran != null && stat == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return new NBTTagInt(uran.getMaxDurability());
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Reactor;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

