/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.reactor.IReactor;
import ic2.core.fluid.IC2Fluid;
import ic2.core.item.reactor.ItemReactorHeatStorageBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ItemReactorHeatVent
extends ItemReactorHeatStorageBase
implements IBootable {
    Map<Integer, VentProperty> vents = new HashMap<Integer, VentProperty>();

    public ItemReactorHeatVent() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.heatVents);
    }

    @Override
    public List<Integer> getValidVariants() {
        return this.getSortedList();
    }

    @Override
    public void onLoad() {
        this.vents.put(0, new VentProperty(0, 6, 0, 1000, 0, Ic2ItemLang.heatVent, 18));
        this.vents.put(1, new VentProperty(0, 5, 5, 1000, 1, Ic2ItemLang.heatVentCore, 19));
        this.vents.put(2, new VentProperty(0, 20, 36, 1000, 2, Ic2ItemLang.heatVentOverclockt, 21));
        this.vents.put(3, new VentProperty(0, 12, 0, 1000, 3, Ic2ItemLang.heatVentAdvanced, 20));
        this.vents.put(10, new VentProperty(1, 6, 0, 1100, 32, Ic2ItemLang.steamVent, 22));
        this.vents.put(11, new VentProperty(1, 5, 5, 1100, 33, Ic2ItemLang.steamVentCore, 23));
        this.vents.put(12, new VentProperty(1, 20, 36, 1100, 34, Ic2ItemLang.steamVentOverclockt, 24));
        this.vents.put(13, new VentProperty(1, 12, 0, 1100, 35, Ic2ItemLang.steamVentAdvanced, 25));
        this.vents.put(20, new VentProperty(2, 12, 0, 10000, 7, Ic2ItemLang.electricVent, 48));
        this.vents.put(21, new VentProperty(2, 10, 10, 10000, 8, Ic2ItemLang.electricVentCore, 49));
        this.vents.put(22, new VentProperty(2, 40, 72, 10000, 9, Ic2ItemLang.electricVentOverclockt, 50));
        this.vents.put(23, new VentProperty(2, 24, 0, 10000, 10, Ic2ItemLang.electricVentAdvaned, 51));
        Ic2Items.reactorVent = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorVentCore = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorVentGold = new ItemStack((Item)this, 1, 2);
        Ic2Items.reactorVentDiamond = new ItemStack((Item)this, 1, 3);
        Ic2Items.reactorSteamVent = new ItemStack((Item)this, 1, 10);
        Ic2Items.reactorSteamVentCore = new ItemStack((Item)this, 1, 11);
        Ic2Items.reactorSteamVentGold = new ItemStack((Item)this, 1, 12);
        Ic2Items.reactorSteamVentDiamond = new ItemStack((Item)this, 1, 13);
        Ic2Items.reactorElectricVent = new ItemStack((Item)this, 1, 20);
        Ic2Items.reactorElectricVentCore = new ItemStack((Item)this, 1, 21);
        Ic2Items.reactorElectricVentGold = new ItemStack((Item)this, 1, 22);
        Ic2Items.reactorElectricVentDiamond = new ItemStack((Item)this, 1, 23);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Integer meta : this.getSortedList()) {
            items.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
        }
    }

    @Override
    public int getTextureEntry(int meta) {
        VentProperty prop = this.getProperty(meta);
        if (prop != null) {
            return prop.getIconPlace();
        }
        return 0;
    }

    @Override
    public String getSheet(int meta) {
        VentProperty prop = this.getProperty(meta);
        if (prop != null) {
            return prop.getSprite();
        }
        return "i3";
    }

    public VentProperty getProperty(int meta) {
        return this.vents.get(meta);
    }

    public List<Integer> getSortedList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.vents.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        VentProperty prop = this.getProperty(stack.func_77960_j());
        if (prop != null) {
            return prop.getMaxHeat();
        }
        return super.getMaxCustomDamage(stack);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        VentProperty prop = this.getProperty(stack.func_77960_j());
        if (prop != null) {
            return prop.getName();
        }
        return super.getLangComponent(stack);
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (heatrun) {
            boolean electric;
            VentProperty prop = this.getProperty(stack.func_77960_j());
            if (prop == null) {
                return;
            }
            boolean producing = reactor.produceEnergy();
            boolean bl = electric = prop.getType() == 2;
            int reactorVent = electric ? (producing ? prop.getReactor() : prop.getReactor() / 2) : prop.getReactor();
            int selfVent = prop.getSelf();
            if (reactorVent > 0) {
                int reactorDrain;
                int rheat = reactorDrain = reactor.getHeat();
                if (reactorDrain > reactorVent) {
                    reactorDrain = reactorVent;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(stack, reactor, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if (electric) {
                if (producing) {
                    reactor.addOutput(-((float)selfVent * 0.005f));
                }
                this.alterHeat(stack, reactor, x, y, producing ? -prop.getSelf() : -(prop.getSelf() / 2));
                return;
            }
            this.alterHeat(stack, reactor, x, y, -selfVent);
        }
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        VentProperty prop = this.getProperty(yourStack.func_77960_j());
        if (prop == null) {
            return;
        }
        int type = prop.getType();
        if (type == 2) {
            return;
        }
        if (type == 0) {
            this.processChamber(yourStack, reactor, x, y, heatrun);
            return;
        }
        if (heatrun) {
            int heat;
            int reactorVent = prop.getReactor();
            int selfVent = prop.getSelf();
            if (reactorVent > 0) {
                int reactorDrain;
                int rheat = reactorDrain = reactor.getHeat();
                if (reactorDrain > reactorVent) {
                    reactorDrain = reactorVent;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(yourStack, reactor, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if ((heat = this.getCustomDamage(yourStack)) < 100) {
                if (reactor.getWorldObj().func_82737_E() % 40L == 0L) {
                    this.alterHeat(yourStack, reactor, x, y, -1);
                }
                return;
            }
            double water = this.getWater(yourStack);
            if (water <= 0.0) {
                if (reactor.getWorldObj().func_72820_D() % 40L == 0L) {
                    this.alterHeat(yourStack, reactor, x, y, -1);
                }
                return;
            }
            double heatStorage = this.getHeatStorage(yourStack);
            double heatLevel = (double)heat / ((double)prop.getMaxHeat() - 100.0);
            double lvl = (double)selfVent * heatLevel;
            double consume = Math.min(water, lvl /= 40.0);
            if (consume <= 0.0) {
                return;
            }
            int steam = (int)(160.0 * consume);
            FluidTank tank = reactor.getSteamTank();
            if (steam <= 0 || tank.getCapacity() - tank.getFluidAmount() < steam) {
                return;
            }
            tank.fill(IC2Fluid.getFluidStack("steam", steam), true);
            reactor.addOutput((float)steam / 1.6f / 2.0f);
            int copy = -((int)(heatStorage += consume * 40.0));
            copy -= this.alterHeat(yourStack, reactor, x, y, copy);
            this.setWater(yourStack, water -= consume);
            this.setHeatStorage(yourStack, heatStorage += (double)copy);
        } else {
            this.refill(reactor, yourStack, prop);
        }
    }

    private void refill(ISteamReactor reactor, ItemStack yourStack, VentProperty prop) {
        double water = this.getWater(yourStack);
        if (water > (double)prop.getSelf() - 1.0) {
            return;
        }
        int needed = (int)((double)prop.getSelf() - water);
        FluidTank tank = reactor.getWaterTank();
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        int min = Math.min(tank.getFluidAmount(), needed);
        FluidStack drained = tank.drain(min, true);
        if (drained != null) {
            this.setWater(yourStack, water += (double)drained.amount);
        }
    }

    private double getWater(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74769_h("WaterBuffer");
    }

    private void setWater(ItemStack stack, double water) {
        StackUtil.getOrCreateNbtData(stack).func_74780_a("WaterBuffer", water);
    }

    private double getHeatStorage(ItemStack par1) {
        return StackUtil.getNbtData(par1).func_74769_h("HeatStorage");
    }

    private void setHeatStorage(ItemStack par1, double amount) {
        StackUtil.getOrCreateNbtData(par1).func_74780_a("HeatStorage", amount);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        VentProperty prop = this.getProperty(stack.func_77960_j());
        if (prop == null || prop.getType() != 1) {
            return;
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(Ic2Lang.pressShift.getLocalized());
            return;
        }
        int waterPer = (int)(this.getWater(stack) / (double)prop.getSelf() * 100.0);
        int customDamage = this.getCustomDamage(stack);
        double effizens = customDamage < 100 ? 0.0 : (double)customDamage / ((double)this.getMaxCustomDamage(stack) - 100.0) * 100.0;
        double steamProduction = (double)prop.getSelf() * effizens;
        steamProduction /= 100.0;
        steamProduction /= 40.0;
        tooltip.add(Ic2InfoLang.steamVentWater.getLocalizedFormatted(waterPer + "%"));
        tooltip.add(Ic2InfoLang.steamVentHeat.getLocalizedFormatted((int)effizens + "%"));
        tooltip.add(Ic2InfoLang.steamVentSteam.getLocalizedFormatted((int)(steamProduction *= 160.0) + "~ mB"));
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[this.vents.size()];
        int step = 0;
        for (Integer meta : this.getSortedList()) {
            items[step] = new ItemStack((Item)this, 1, meta.intValue());
            ++step;
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return ItemStack.field_190927_a;
    }

    @Override
    public short getID(ItemStack stack) {
        VentProperty prop = this.vents.get(stack.func_77960_j());
        if (prop != null) {
            return prop.getPlannerID();
        }
        return 0;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.Vent;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        VentProperty prop = this.vents.get(stack.func_77960_j());
        if (prop != null) {
            if (stat == IReactorPlannerComponent.ReactorComponentStat.SelfCooling) {
                return new NBTTagInt(prop.getSelf());
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.ReactorCooling) {
                return new NBTTagInt(prop.getReactor());
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyUsage) {
                return new NBTTagFloat((float)prop.getSelf() * 0.005f);
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.SteamProduction) {
                return new NBTTagFloat((float)(prop.getSelf() * 4));
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.WaterConsumtion) {
                return new NBTTagFloat((float)prop.getSelf() / 40.0f);
            }
            if (stat == IReactorPlannerComponent.ReactorComponentStat.WaterStorage) {
                return new NBTTagFloat((float)prop.getSelf());
            }
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        VentProperty prop = this.vents.get(stack.func_77960_j());
        if (prop != null) {
            if (prop.getType() == 1) {
                return IReactorPlannerComponent.ReactorType.SteamReactor;
            }
            if (prop.getType() == 2) {
                return IReactorPlannerComponent.ReactorType.Reactor;
            }
        }
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        VentProperty prop = this.vents.get(stack.func_77960_j());
        if (prop != null) {
            if (prop.getType() == 2) {
                ArrayList<IReactorPlannerComponent.ReactorComponentStat> list = new ArrayList<IReactorPlannerComponent.ReactorComponentStat>();
                list.add(IReactorPlannerComponent.ReactorComponentStat.EnergyUsage);
                return list;
            }
            if (prop.getType() == 1) {
                ArrayList<IReactorPlannerComponent.ReactorComponentStat> list = new ArrayList<IReactorPlannerComponent.ReactorComponentStat>();
                list.add(IReactorPlannerComponent.ReactorComponentStat.WaterConsumtion);
                list.add(IReactorPlannerComponent.ReactorComponentStat.SteamProduction);
                list.add(IReactorPlannerComponent.ReactorComponentStat.WaterStorage);
                return list;
            }
        }
        return null;
    }

    static class VentProperty {
        int self;
        int reactor;
        String sprite;
        int iconPlace;
        LocaleComp comp;
        int type;
        int maxHeat;
        short id;

        public VentProperty(int type, int self, int reactor, int maxHeat, int icon, LocaleComp name, int plannerID) {
            this.type = type;
            this.self = self;
            this.reactor = reactor;
            this.maxHeat = maxHeat;
            this.sprite = "i3";
            this.iconPlace = icon;
            this.comp = name;
            this.id = (short)plannerID;
        }

        public short getPlannerID() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public int getIconPlace() {
            return this.iconPlace;
        }

        public int getReactor() {
            return this.reactor;
        }

        public int getSelf() {
            return this.self;
        }

        public int getMaxHeat() {
            return this.maxHeat;
        }

        public String getSprite() {
            return this.sprite;
        }

        public LocaleComp getName() {
            return this.comp;
        }
    }
}

