/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlanner;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2;
import ic2.core.item.base.ItemGrandualInt;
import ic2.core.item.reactor.uranTypes.BlazeUranium;
import ic2.core.item.reactor.uranTypes.CharcoalUranium;
import ic2.core.item.reactor.uranTypes.EnderUranium;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.NetherStarUranium;
import ic2.core.item.reactor.uranTypes.RedstoneUranium;
import ic2.core.item.reactor.uranTypes.StandartUranium;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.ItemStackCoord;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReactorUraniumRod
extends ItemGrandualInt
implements IBootable,
ISteamReactorComponent,
IReactorPlannerComponent {
    public static int[] numberOfCells = new int[]{1, 2, 4};
    public static String[] stringOfCells = new String[]{"Simple", "Dual", "Quad"};
    public static IUranium[] types = new IUranium[0];

    public ItemReactorUraniumRod() {
        this.setUnlocalizedName(Ic2ItemLang.uraniumRod);
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        types = new IUranium[6];
        ItemReactorUraniumRod.types[0] = new StandartUranium();
        ItemReactorUraniumRod.types[1] = new RedstoneUranium();
        ItemReactorUraniumRod.types[2] = new BlazeUranium();
        ItemReactorUraniumRod.types[3] = new EnderUranium();
        ItemReactorUraniumRod.types[4] = new NetherStarUranium();
        ItemReactorUraniumRod.types[5] = new CharcoalUranium();
        Ic2Items.reactorUraniumRodSingle = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorUraniumRodDual = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorUraniumRodQuad = new ItemStack((Item)this, 1, 2);
        Ic2Items.reactorRedstoneUraniumRodSingle = new ItemStack((Item)this, 1, 3);
        Ic2Items.reactorRedstoneUraniumRodDual = new ItemStack((Item)this, 1, 4);
        Ic2Items.reactorRedstoneUraniumRodQuad = new ItemStack((Item)this, 1, 5);
        Ic2Items.reactorBlazeUraniumRodSingle = new ItemStack((Item)this, 1, 6);
        Ic2Items.reactorBlazeUraniumRodDual = new ItemStack((Item)this, 1, 7);
        Ic2Items.reactorBlazeUraniumRodQuad = new ItemStack((Item)this, 1, 8);
        Ic2Items.reactorEnderPearlUraniumRodSingle = new ItemStack((Item)this, 1, 9);
        Ic2Items.reactorEnderPearlUraniumRodDual = new ItemStack((Item)this, 1, 10);
        Ic2Items.reactorEnderPearlUraniumRodQuad = new ItemStack((Item)this, 1, 11);
        Ic2Items.reactorNetherStarUraniumRodSingle = new ItemStack((Item)this, 1, 12);
        Ic2Items.reactorNetherStarUraniumRodDual = new ItemStack((Item)this, 1, 13);
        Ic2Items.reactorNetherStarUraniumRodQuad = new ItemStack((Item)this, 1, 14);
        Ic2Items.reactorCharcoalUraniumRodSingle = new ItemStack((Item)this, 1, 15);
        Ic2Items.reactorCharcoalUraniumRodDual = new ItemStack((Item)this, 1, 16);
        Ic2Items.reactorCharcoalUraniumRodQuad = new ItemStack((Item)this, 1, 17);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return ItemReactorUraniumRod.getUran(meta / 3).getTexture(this.getRodType(meta));
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getUran(stack).getName(this.getRodType(stack.func_77960_j()));
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.getUran(stack).getMaxDurability();
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int count = this.getRodAmount(stack);
        IUranium uran = this.getUran(stack);
        for (int iteration = 0; iteration < count; ++iteration) {
            int i;
            int pulsePerTick = uran.getPulsesPerTick();
            int pulses = (1 + count / 2) * pulsePerTick;
            if (!heatrun) {
                for (i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(stack, reactor, stack, x, y, x, y, heatrun);
                }
                for (i = 0; i < pulsePerTick; ++i) {
                    for (int[] nArray : uran.getPulseArea(i)) {
                        pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], stack, x, y, heatrun, uran);
                    }
                }
                continue;
            }
            for (i = 0; i < pulsePerTick; ++i) {
                for (int[] nArray : uran.getPulseArea(i)) {
                    pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], stack, x, y, heatrun, uran);
                }
            }
            int heat = (int)((float)(this.sumUp(pulses) * 4) * uran.getHeatModifier());
            LinkedList<ItemStackCoord> targets = new LinkedList<ItemStackCoord>();
            for (int[] array4 : uran.getAcceptorTargets()) {
                this.checkHeatAcceptor(reactor, x + array4[0], y + array4[1], targets);
            }
            while (targets.size() > 0 && heat > 0) {
                int n = heat / targets.size();
                heat -= n;
                ItemStackCoord target = (ItemStackCoord)targets.remove();
                int n2 = ((IReactorComponent)target.stack.func_77973_b()).alterHeat(target.stack, reactor, target.x, target.y, n);
                heat += n2;
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (this.getCustomDamage(stack) + 1 > this.getMaxCustomDamage(stack)) {
            if (IC2.random.nextInt(3) == 0) {
                reactor.setItemAt(x, y, StackUtil.copyWithSize(uran.getRodType(IUranium.RodType.NearDepletedRod), count));
            } else {
                reactor.setItemAt(x, y, ItemStack.field_190927_a);
            }
        } else if (heatrun) {
            this.setCustomDamage(stack, this.getCustomDamage(stack) + 1);
        }
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int count = this.getRodAmount(yourStack);
        IUranium uran = this.getUran(yourStack);
        for (int iteration = 0; iteration < count; ++iteration) {
            int i;
            int pulsePerTick = uran.getPulsesPerTick();
            int pulses = (1 + count / 2) * pulsePerTick;
            if (!heatrun) {
                for (i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(yourStack, reactor, yourStack, x, y, x, y, heatrun);
                }
                for (i = 0; i < pulsePerTick; ++i) {
                    for (int[] nArray : uran.getPulseArea(i)) {
                        pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, damageTick, uran);
                    }
                }
                continue;
            }
            for (i = 0; i < pulsePerTick; ++i) {
                for (int[] nArray : uran.getPulseArea(i)) {
                    pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, damageTick, uran);
                }
            }
            int heat = (int)((float)(this.sumUp(pulses) * 4) * uran.getHeatModifier());
            LinkedList<ItemStackCoord> targets = new LinkedList<ItemStackCoord>();
            for (int[] array4 : uran.getAcceptorTargets()) {
                this.checkHeatAcceptor(reactor, x + array4[0], y + array4[1], targets);
            }
            while (targets.size() > 0 && heat > 0) {
                int n = heat / targets.size();
                heat -= n;
                ItemStackCoord target = (ItemStackCoord)targets.remove();
                int n2 = ((IReactorComponent)target.stack.func_77973_b()).alterHeat(target.stack, reactor, target.x, target.y, n);
                heat += n2;
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (damageTick) {
            if (this.getCustomDamage(yourStack) + 1 > this.getMaxCustomDamage(yourStack)) {
                if (IC2.random.nextInt(3) == 0) {
                    reactor.setItemAt(x, y, StackUtil.copyWithSize(uran.getRodType(IUranium.RodType.NearDepletedRod), count));
                } else {
                    reactor.setItemAt(x, y, ItemStack.field_190927_a);
                }
            } else {
                this.setCustomDamage(yourStack, this.getCustomDamage(yourStack) + 1);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            planner.addFuelPulse();
        }
        if (reactor instanceof ISteamReactor) {
            return true;
        }
        if (!heatrun) {
            reactor.addOutput(this.getUran(stack).getEUPerPulse());
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return this.getUran(stack).getExplosionEffectModifier() * (float)this.getRodAmount(stack);
    }

    private int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun, IUranium type) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(other, reactor, me, x, y, mex, mey, heatrun)) {
            return type.getPulsesForConnection();
        }
        return 0;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, List<ItemStackCoord> heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(thing, reactor, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    private int sumUp(int x) {
        int sum = 0;
        for (int i = 1; i <= x; ++i) {
            sum += i;
        }
        return sum;
    }

    public int getRodAmount(ItemStack stack) {
        return numberOfCells[stack.func_77960_j() % 3];
    }

    public IUranium.RodType getRodType(int metadata) {
        int meta = metadata % 3;
        if (meta == 1) {
            return IUranium.RodType.DualRod;
        }
        if (meta == 2) {
            return IUranium.RodType.QuadRod;
        }
        return IUranium.RodType.SingleRod;
    }

    public IUranium getUran(ItemStack stack) {
        return ItemReactorUraniumRod.getUran(stack.func_77960_j() / 3);
    }

    public static IUranium getUran(int type) {
        if (type >= types.length) {
            return types[0];
        }
        return types[type];
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        List<IUranium.RodType> rods = Arrays.asList(IUranium.RodType.SingleRod, IUranium.RodType.DualRod, IUranium.RodType.QuadRod);
        for (IUranium.RodType rod : rods) {
            for (int i = 0; i < types.length; ++i) {
                IUranium uran = types[i];
                if (uran == null) continue;
                items.add((Object)uran.getRodType(rod));
            }
        }
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        super.applyCustomDamage(stack, damage, src);
        return this.getCustomDamage(stack) > this.getMaxCustomDamage(stack);
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[types.length * 3];
        IUranium.RodType[] rodTypes = new IUranium.RodType[]{IUranium.RodType.SingleRod, IUranium.RodType.DualRod, IUranium.RodType.QuadRod};
        for (int i = 0; i < types.length; ++i) {
            int step = i * 3;
            for (int x = 0; x < rodTypes.length; ++x) {
                items[step + x] = types[i].getRodType(rodTypes[x]);
            }
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return ItemStack.field_190927_a;
    }

    @Override
    public short getID(ItemStack stack) {
        return this.getUran(stack).getRodID(this.getRodType(stack.func_77960_j()));
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.FuelRod;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        IUranium uran = this.getUran(stack);
        int rodAmount = this.getRodAmount(stack);
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            for (int i = 0; i < rodAmount; ++i) {
                amount = (int)((float)amount + (float)(this.sumUp((1 + rodAmount / 2) * uran.getPulsesPerTick()) * 4) * uran.getHeatModifier());
            }
            return new NBTTagInt(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            float amount = 0.0f;
            for (int i = 0; i < rodAmount; ++i) {
                int pulses = (1 + rodAmount / 2) * uran.getPulsesPerTick();
                for (int z = 0; z < pulses; ++z) {
                    amount += uran.getEUPerPulse();
                }
            }
            return new NBTTagFloat(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return new NBTTagInt(this.getMaxCustomDamage(stack));
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.RodAmount) {
            return new NBTTagInt(rodAmount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.PulseAmount) {
            return new NBTTagInt((1 + rodAmount / 2) * uran.getPulsesPerTick() * rodAmount);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction || stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        IUranium uran = this.getUran(stack);
        int rodAmount = this.getRodAmount(stack);
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            int pulsePerTick = uran.getPulsesPerTick();
            for (int i = 0; i < rodAmount; ++i) {
                int pulses = (1 + rodAmount / 2) * uran.getPulsesPerTick();
                for (int z = 0; z < pulsePerTick; ++z) {
                    for (int[] array : uran.getPulseArea(z)) {
                        pulses += this.checkPulseable(reactor, x + array[0], y + array[1], stack, x, y, false, uran);
                    }
                }
                amount = (int)((float)amount + (float)(this.sumUp(pulses) * 4) * uran.getHeatModifier());
            }
            return new NBTTagInt(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            for (int i = 0; i < rodAmount; ++i) {
                int z;
                int pulsePerTick = uran.getPulsesPerTick();
                int pulses = (1 + rodAmount / 2) * pulsePerTick;
                for (z = 0; z < pulses; ++z) {
                    this.acceptUraniumPulse(stack, reactor, stack, x, y, x, y, false);
                }
                for (z = 0; z < pulsePerTick; ++z) {
                    for (int[] array : uran.getPulseArea(z)) {
                        pulses += this.checkPulseable(reactor, x + array[0], y + array[1], stack, x, y, false, uran);
                    }
                }
            }
            return new NBTTagFloat(reactor.getReactorEnergyOutput());
        }
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

