/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.textures.Ic2Icons;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UranBaseType
implements IUranium {
    public List<int[]> offsetArray = new ArrayList<int[]>();

    public void loadDefaults() {
        this.addArray(-1, 0);
        this.addArray(1, 0);
        this.addArray(0, -1);
        this.addArray(0, 1);
    }

    public void addArray(int ... array) {
        this.offsetArray.add(array);
    }

    @Override
    public List<int[]> getPulseArea(int pulse) {
        return this.offsetArray;
    }

    @Override
    public List<int[]> getAcceptorTargets() {
        return this.offsetArray;
    }

    public abstract int getRow();

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(IUranium.RodType type) {
        int height = 6 + type.ordinal();
        return Ic2Icons.getTextures("i3")[height * 16 + this.getRow()];
    }
}

