/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.classic.recipe.crafting.RecipeObject;
import ic2.api.classic.recipe.crafting.RecipeOreObject;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.ICraftingRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.crop.misc.RecipeInputCrop;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputElectricItem;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class AdvShapelessRecipe
extends AdvRecipeBase {
    private static int recipeCounter = 0;
    private List<IRecipeInput> input = new ArrayList<IRecipeInput>();

    public static IAdvRecipe addAndGet(ItemStack out, Object[] in) {
        return AdvRecipeBase.registerRecipe(new AdvShapelessRecipe(out, in));
    }

    public static IAdvRecipe overrideAndGet(String recipeID, ItemStack out, Object[] in) {
        return AdvRecipeBase.overrideRecipe(new AdvShapelessRecipe(recipeID, out, in));
    }

    public AdvShapelessRecipe(ItemStack out, Object[] items) {
        this(AdvShapelessRecipe.getRecipeID("shapeless_" + out.func_82833_r(), 0), out, items);
    }

    private AdvShapelessRecipe(String recipeID, ItemStack out, Object[] items) {
        this.recipeID = recipeID;
        this.setRegistryNameFixed(new ResourceLocation("ic2", recipeID));
        this.output = out.func_77946_l();
        for (int i = 0; i < items.length; ++i) {
            Object obj = items[i];
            if (obj == null) continue;
            if (obj instanceof ICraftingRecipeList.IRecipeModifier) {
                this.modifier = (ICraftingRecipeList.IRecipeModifier)obj;
                continue;
            }
            if (obj instanceof Boolean) {
                this.hidden = (Boolean)obj;
                continue;
            }
            if (obj instanceof ICraftingRecipeManager.AttributeContainer) {
                this.hidden = ((ICraftingRecipeManager.AttributeContainer)obj).hidden;
                continue;
            }
            if (obj instanceof String) {
                this.add(new RecipeInputOreDict((String)obj));
                continue;
            }
            if (obj instanceof Item) {
                this.add(new ItemStack((Item)obj, 1, Short.MAX_VALUE));
                continue;
            }
            if (obj instanceof Block) {
                this.add(new ItemStack((Block)obj, 1, Short.MAX_VALUE));
                continue;
            }
            if (obj instanceof Fluid) {
                this.add(new RecipeInputFluid((Fluid)obj));
                continue;
            }
            if (obj instanceof FluidStack) {
                this.add(new RecipeInputFluid((FluidStack)obj));
                continue;
            }
            if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                if (stack.func_77973_b() instanceof IElectricItem) {
                    this.add(new RecipeInputElectricItem(stack.func_77946_l()));
                    continue;
                }
                this.add(stack.func_77946_l());
                continue;
            }
            if (obj instanceof CropCard) {
                this.add(new RecipeInputCrop((CropCard)obj));
                continue;
            }
            if (obj instanceof BaseSeed) {
                this.add(new RecipeInputCrop((BaseSeed)obj));
                continue;
            }
            if (!(obj instanceof IRecipeInput)) continue;
            this.add((IRecipeInput)obj);
        }
    }

    public void add(ItemStack item) {
        this.add(new RecipeInputItemStack(item));
    }

    public void add(IRecipeInput item) {
        this.input.add(item);
        if (item instanceof RecipeInputOreDict) {
            RecipeInputOreDict ore = (RecipeInputOreDict)item;
            this.objects.add(new RecipeOreObject(ore.input, -1, ore.getAmount()));
        } else {
            this.objects.add(new RecipeObject(-1, item.getInputs(), item.getAmount()));
        }
    }

    @Override
    public IAdvRecipe.RecipeType getRecipeType() {
        return IAdvRecipe.RecipeType.Shapeless;
    }

    @Override
    public int getRecipeHeight() {
        return -1;
    }

    @Override
    public int getRecipeLength() {
        return -1;
    }

    @Override
    public IRecipeInput getTrueInput(int index) {
        return this.input.get(index);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return !this.func_77572_b(inv).func_190926_b();
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this.modifier != null) {
            this.modifier.clear();
        }
        ItemStack out = this.output.func_77946_l();
        int totalCharge = 0;
        LinkedList<IRecipeInput> list = new LinkedList<IRecipeInput>(this.input);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Iterator iter = list.iterator();
            boolean inRecipe = false;
            while (iter.hasNext()) {
                IRecipeInput in = (IRecipeInput)iter.next();
                if (!in.matches(stack) || in.getAmount() > stack.func_190916_E() || this.modifier != null && !this.modifier.isStackValid(stack)) continue;
                iter.remove();
                inRecipe = true;
                break;
            }
            if (!inRecipe) {
                return ItemStack.field_190927_a;
            }
            if (this.modifier != null && this.modifier.isOutput(stack)) {
                out = stack.func_77946_l();
                continue;
            }
            totalCharge = (int)((double)totalCharge + ElectricItem.manager.getCharge(stack));
        }
        if (list.size() > 0) {
            return ItemStack.field_190927_a;
        }
        if (totalCharge > 0) {
            ElectricItem.manager.charge(out, totalCharge, Integer.MAX_VALUE, true, false);
        }
        if (this.modifier != null) {
            out = this.modifier.getOutput(out, false);
        }
        return out;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        LinkedList<IRecipeInput> list = new LinkedList<IRecipeInput>(this.input);
        int[] slot = new int[inv.func_70302_i_()];
        int maxSlot = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                IRecipeInput in = (IRecipeInput)iter.next();
                if (!in.matches(stack) || in.getAmount() > stack.func_190916_E()) continue;
                if (in.getAmount() > 1) {
                    slot[i] = in.getAmount();
                    ++maxSlot;
                } else if (StackUtil.isStackEqual(stack, Ic2Items.waterCell) && in.getInputs().size() > 1 && in.matches(Ic2Items.waterCell)) {
                    slot[i] = 1;
                    ++maxSlot;
                } else if (StackUtil.isStackEqual(stack, Ic2Items.lavaCell) && in.getInputs().size() > 1 && in.matches(Ic2Items.lavaCell)) {
                    slot[i] = 1;
                    ++maxSlot;
                }
                iter.remove();
            }
        }
        if (maxSlot < 0) {
            return AdvRecipe.getDefaultItems(inv);
        }
        NonNullList result = NonNullList.func_191197_a((int)slot.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < slot.length; ++i) {
            if (slot[i] < 1) {
                result.set(i, (Object)AdvRecipe.getContainerItem(inv.func_70301_a(i)));
                continue;
            }
            if (slot[i] == 1) {
                result.set(i, (Object)Ic2Items.emptyCell.func_77946_l());
                continue;
            }
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            inv.func_70299_a(i, ItemStack.field_190927_a);
            result.set(i, (Object)stack);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(slot[i]);
        }
        return result;
    }

    @Override
    public NonNullList<Ingredient> buildList() {
        return NonNullList.func_191196_a();
    }
}

