/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.IRecipeObject;
import ic2.api.classic.recipe.crafting.RecipeObject;
import ic2.api.classic.recipe.crafting.RecipeOreObject;
import ic2.api.item.ICustomDamageItem;
import ic2.api.recipe.IRecipeInput;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RepairRecipe
extends AdvRecipeBase {
    ICustomDamageItem input;
    int metadata = 0;
    IRecipeInput material;
    int change;
    IRecipeObject recipeItem;
    private int recipeCounter = 0;

    public static IAdvRecipe addAndGet(ICustomDamageItem item, int meta, IRecipeInput in, int amount) {
        return AdvRecipeBase.registerRecipe(new RepairRecipe(item, meta, in, amount));
    }

    public RepairRecipe(ICustomDamageItem item, int meta, IRecipeInput in, int amount) {
        this.recipeID = RepairRecipe.getRecipeID("recipeRepair_" + new ItemStack((Item)item, 0, meta).func_82833_r(), 0);
        this.setRegistryName(new ResourceLocation("ic2", this.recipeID));
        this.input = item;
        this.metadata = meta;
        this.material = in;
        this.change = amount;
        if (in instanceof RecipeInputOreDict) {
            RecipeInputOreDict obj = (RecipeInputOreDict)in;
            this.recipeItem = new RecipeOreObject(obj.input, -1, obj.getAmount());
        } else {
            this.recipeItem = new RecipeObject(-1, in.getInputs(), in.getAmount());
        }
        this.objects.add(this.recipeItem);
        this.objects.add(new RecipeObject(-1, new ItemStack((Item)item, 0, meta)));
    }

    @Override
    public IRecipeInput getTrueInput(int index) {
        if (index == 0) {
            return this.material;
        }
        return new RecipeInputItemStack(((IRecipeObject)this.objects.get(1)).getItems().get(0));
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return !this.getResult(inv, false).func_190926_b();
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getResult(inv, true);
    }

    public ItemStack getResult(InventoryCrafting inv, boolean doAdd) {
        ItemStack itemToCharge = ItemStack.field_190927_a;
        int amount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == this.input && (this.metadata == Short.MAX_VALUE || this.metadata == stack.func_77960_j())) {
                if (itemToCharge.func_190926_b()) {
                    itemToCharge = stack;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            if (!this.material.matches(stack) || stack.func_190916_E() < this.material.getAmount()) continue;
            ++amount;
        }
        if (amount <= 0 || itemToCharge.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!doAdd) {
            return itemToCharge;
        }
        ItemStack copy = itemToCharge.func_77946_l();
        int max = this.input.getMaxCustomDamage(copy);
        int current = this.input.getCustomDamage(copy);
        if ((current += amount * this.change) > max) {
            current = max;
        } else if (current < 0) {
            current = 0;
        }
        this.input.setCustomDamage(copy, current);
        return copy;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.getRecipeLength() && height >= this.getRecipeHeight();
    }

    @Override
    @Nullable
    public ItemStack func_77571_b() {
        return new ItemStack((Item)this.input, 1, this.metadata);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        int toChargeSlot = -1;
        int amount = 0;
        boolean[] slots = new boolean[inv.func_70302_i_()];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == this.input && (this.metadata == Short.MAX_VALUE || this.metadata == stack.func_77960_j())) {
                if (toChargeSlot == -1) {
                    toChargeSlot = i;
                    continue;
                }
                return null;
            }
            if (!this.material.matches(stack) || stack.func_190916_E() < this.material.getAmount()) continue;
            ++amount;
            slots[i] = true;
        }
        if (amount <= 0 || toChargeSlot == -1) {
            return AdvRecipe.getDefaultItems(inv);
        }
        NonNullList array = NonNullList.func_191197_a((int)slots.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < array.size(); ++i) {
            if (i == toChargeSlot) continue;
            if (slots[i]) {
                inv.func_70298_a(i, this.material.getAmount());
                array.set(i, (Object)inv.func_70301_a(i).func_77946_l());
                inv.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            array.set(i, (Object)AdvRecipe.getContainerItem(inv.func_70301_a(i)));
        }
        return array;
    }

    public int getEffect() {
        return this.change;
    }

    @Override
    public IAdvRecipe.RecipeType getRecipeType() {
        return IAdvRecipe.RecipeType.Repair;
    }

    @Override
    public int getRecipeHeight() {
        return 3;
    }

    @Override
    public int getRecipeLength() {
        return 3;
    }

    @Override
    public NonNullList<Ingredient> buildList() {
        return NonNullList.func_191196_a();
    }
}

