/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.audio.AudioPosition;
import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.energy.tile.IInsulationModifieableConductor;
import ic2.api.classic.item.ICutterItem;
import ic2.core.IC2;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemToolCutter
extends ItemIC2
implements ICutterItem,
ICustomItemCameraTransform {
    public ItemToolCutter() {
        this.setUnlocalizedName(Ic2ItemLang.cutter);
        this.func_77625_d(1);
        this.func_77656_e(512);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 54;
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public void cutInsulationFrom(ItemStack stack, World world, BlockPos pos, EntityPlayer player) {
        IInsulationModifieableConductor cable;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInsulationModifieableConductor && (cable = (IInsulationModifieableConductor)tile).tryRemoveInsulation()) {
            if (IC2.platform.isSimulating()) {
                StackUtil.dropAsEntity(world, pos, Ic2Items.rubber.func_77946_l());
                stack.func_77972_a(3, (EntityLivingBase)player);
            } else {
                IC2.audioManager.playOnce(new AudioPosition(world, pos), PositionSpec.Center, Ic2Sounds.cutterUse, true, IC2.audioManager.getDefaultVolume());
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IInsulationModifieableConductor cable;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IInsulationModifieableConductor && (cable = (IInsulationModifieableConductor)tile).tryAddInsulation()) {
            IItemTransporter trans = TransporterManager.manager.getTransporter(player, true);
            if (trans != null && trans.removeItem(new BasicItemFilter(Ic2Items.rubber.func_77946_l()), EnumFacing.DOWN, 1, true) != null) {
                if (IC2.platform.isSimulating()) {
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
                player.field_71070_bA.func_75142_b();
                return EnumActionResult.SUCCESS;
            }
            cable.tryRemoveInsulation();
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }
}

