/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IFoamProvider;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.tool.ItemToolSprayer;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemElectricToolSprayer
extends ItemToolSprayer
implements IDamagelessElectricItem,
IFoamProvider {
    public static final int[] sprayModes = new int[]{1, 2, 4, 8, 16, 32};

    public ItemElectricToolSprayer() {
        this.func_77656_e(0);
        this.setUnlocalizedName(Ic2ItemLang.electricSprayer);
        this.setNoRepair();
    }

    @Override
    public int getTextureEntry(int meta) {
        return 45;
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        tooltip.add(Ic2InfoLang.sprayerSize.getLocalizedFormatted(sprayModes[nbt.func_74762_e("SprayAmount")]));
        tooltip.add(Ic2InfoLang.sprayerUses.getLocalizedFormatted(nbt.func_74762_e("StoredFoam"), 1000));
        List<String> list = sortedTooltip.get((Object)ToolTipType.Ctrl);
        list.add(Ic2Lang.onItemRightClick.getLocalized());
        list.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.electricSprayerRange));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 10000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 100.0;
    }

    @Override
    public int getFoamAmount(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("StoredFoam");
    }

    @Override
    public void useFoam(ItemStack stack, EntityPlayer player, int amount) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        int stored = nbt.func_74762_e("StoredFoam");
        if ((stored -= amount) < 0) {
            stored = 0;
        }
        nbt.func_74768_a("StoredFoam", stored);
    }

    @Override
    public void onFoam(ItemStack stack, EntityPlayer player, int foamAmount) {
        super.onFoam(stack, player, foamAmount);
        ElectricItem.manager.use(stack, foamAmount * 5, (EntityLivingBase)player);
    }

    @Override
    public int getSprayMass(ItemStack stack) {
        int amount = sprayModes[StackUtil.getNbtData(stack).func_74762_e("SprayAmount")];
        if (ElectricItem.manager.canUse(stack, amount * 5)) {
            return amount;
        }
        return 0;
    }

    @Override
    public boolean canProvideFoam(EntityPlayer player, ItemStack stack, int amount, IFoamProvider.ProviderSlot type) {
        return false;
    }

    @Override
    public void useFoam(EntityPlayer player, ItemStack stack, int amount) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public void fillFoam(ItemStack stack, int amount) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        int stored = nbt.func_74762_e("StoredFoam");
        if ((stored += amount) > 1000) {
            stored = 1000;
        }
        nbt.func_74768_a("StoredFoam", stored);
    }

    @Override
    public int getFreeRoom(ItemStack stack) {
        return 1000 - StackUtil.getNbtData(stack).func_74762_e("StoredFoam");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            if (worldIn.field_72995_K) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            int amount = nbt.func_74762_e("SprayAmount") + 1;
            if (amount >= sprayModes.length) {
                amount = 0;
            }
            nbt.func_74768_a("SprayAmount", amount);
            IC2.platform.messagePlayer(playerIn, Ic2InfoLang.sprayerSize, sprayModes[amount]);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }
}

