/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import com.mojang.authlib.GameProfile;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.network.INetworkItemEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.slots.SlotUpgrade;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.upgrades.subtypes.machine.BasicExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.BasicFluidExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.BasicFluidImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.BasicImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.CobbleGenUpgrade;
import ic2.core.item.upgrades.subtypes.machine.CraftingUpgrade;
import ic2.core.item.upgrades.subtypes.machine.CreativeUpgrade;
import ic2.core.item.upgrades.subtypes.machine.EfficenyUpgrade;
import ic2.core.item.upgrades.subtypes.machine.EnergyMultiplierUpgrade;
import ic2.core.item.upgrades.subtypes.machine.EnergyStorageUpgrade;
import ic2.core.item.upgrades.subtypes.machine.ExpCollectorUpgrade;
import ic2.core.item.upgrades.subtypes.machine.ExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredBasicExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredBasicFluidExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredBasicFluidImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredBasicImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredFluidExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredFluidImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FilteredImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FluidExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.FluidImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.IUpgradeMetaItem;
import ic2.core.item.upgrades.subtypes.machine.ImportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.LoudnessUpgrade;
import ic2.core.item.upgrades.subtypes.machine.MufflerUpgrade;
import ic2.core.item.upgrades.subtypes.machine.MuteUpgrade;
import ic2.core.item.upgrades.subtypes.machine.OverclockerUpgrade;
import ic2.core.item.upgrades.subtypes.machine.QuantumOverclockerUpgrade;
import ic2.core.item.upgrades.subtypes.machine.ReactorTrackUpgrade;
import ic2.core.item.upgrades.subtypes.machine.RedstoneInverterUpgrade;
import ic2.core.item.upgrades.subtypes.machine.RedstoneSensitivityUpgrade;
import ic2.core.item.upgrades.subtypes.machine.RoundRobinExportUpgrade;
import ic2.core.item.upgrades.subtypes.machine.SawBladeUpgrade;
import ic2.core.item.upgrades.subtypes.machine.SlowDownUpgrade;
import ic2.core.item.upgrades.subtypes.machine.TransformerUpgrade;
import ic2.core.platform.capabilities.energy.SinkLimiterHandler;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Capabilities;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUpgradeModul
extends ItemIC2
implements IMachineUpgradeItem,
IBootable,
IHandHeldInventory,
INetworkItemEventListener {
    public Map<Integer, IUpgradeMetaItem> upgrades = new LinkedHashMap<Integer, IUpgradeMetaItem>();

    public ItemUpgradeModul() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.upgradeBase);
    }

    @Override
    public void onLoad() {
        Ic2Items.overClockerUpgrade = new ItemStack((Item)this, 1, 0);
        Ic2Items.transformerUpgrade = new ItemStack((Item)this, 1, 1);
        Ic2Items.energyStorageUpgrade = new ItemStack((Item)this, 1, 2);
        Ic2Items.redstoneSUpgrade = new ItemStack((Item)this, 1, 3);
        Ic2Items.redstoneIUpgrade = new ItemStack((Item)this, 1, 4);
        Ic2Items.importBasicUpgrade = new ItemStack((Item)this, 1, 5);
        Ic2Items.importUpgrade = new ItemStack((Item)this, 1, 6);
        Ic2Items.exportBasicUpgrade = new ItemStack((Item)this, 1, 7);
        Ic2Items.exportUpgrade = new ItemStack((Item)this, 1, 8);
        Ic2Items.mufflerUpgrade = new ItemStack((Item)this, 1, 9);
        Ic2Items.muteUpgrade = new ItemStack((Item)this, 1, 10);
        Ic2Items.expCollectorUpgrade = new ItemStack((Item)this, 1, 11);
        Ic2Items.efficencyUpgrade = new ItemStack((Item)this, 1, 12);
        Ic2Items.energyMultiplierUpgrade = new ItemStack((Item)this, 1, 13);
        Ic2Items.loudnessUpgrade = new ItemStack((Item)this, 1, 14);
        Ic2Items.roundRobinExport = new ItemStack((Item)this, 1, 15);
        Ic2Items.slowdownUpgrade = new ItemStack((Item)this, 1, 16);
        Ic2Items.filteredImportBasicUpgrade = new ItemStack((Item)this, 1, 17);
        Ic2Items.filteredImportUpgrade = new ItemStack((Item)this, 1, 18);
        Ic2Items.filteredExportBasicUpgrade = new ItemStack((Item)this, 1, 19);
        Ic2Items.filteredExportUpgrade = new ItemStack((Item)this, 1, 20);
        Ic2Items.basicFluidImportUpgrade = new ItemStack((Item)this, 1, 21);
        Ic2Items.fluidImportUpgrade = new ItemStack((Item)this, 1, 22);
        Ic2Items.basicFluidExportUpgrade = new ItemStack((Item)this, 1, 23);
        Ic2Items.fluidExportUpgrade = new ItemStack((Item)this, 1, 24);
        Ic2Items.filteredBasicFluidImportUpgrade = new ItemStack((Item)this, 1, 25);
        Ic2Items.filteredFluidImportUpgrade = new ItemStack((Item)this, 1, 26);
        Ic2Items.filteredBasicFluidExportUpgrade = new ItemStack((Item)this, 1, 27);
        Ic2Items.filteredFluidExportUpgrade = new ItemStack((Item)this, 1, 28);
        Ic2Items.reactorTrackUpgrade = new ItemStack((Item)this, 1, 29);
        Ic2Items.cobbleGenUpgrade = new ItemStack((Item)this, 1, 30);
        Ic2Items.craftingUpgrade = new ItemStack((Item)this, 1, 31);
        Ic2Items.quantumOverclockerUpgrade = new ItemStack((Item)this, 1, 32);
        Ic2Items.efficientSawBladeUpgrade = new ItemStack((Item)this, 1, 33);
        Ic2Items.durabileSawBladeUpgrade = new ItemStack((Item)this, 1, 34);
        Ic2Items.creativeUpgrade = new ItemStack((Item)this, 1, 3000);
        this.upgrades.put(0, new OverclockerUpgrade());
        this.upgrades.put(1, new TransformerUpgrade());
        this.upgrades.put(2, new EnergyStorageUpgrade());
        this.upgrades.put(3, new RedstoneSensitivityUpgrade());
        this.upgrades.put(4, new RedstoneInverterUpgrade());
        this.upgrades.put(5, new BasicImportUpgrade());
        this.upgrades.put(6, new ImportUpgrade());
        this.upgrades.put(7, new BasicExportUpgrade());
        this.upgrades.put(8, new ExportUpgrade());
        this.upgrades.put(9, new MufflerUpgrade());
        this.upgrades.put(10, new MuteUpgrade());
        this.upgrades.put(11, new ExpCollectorUpgrade());
        this.upgrades.put(12, new EfficenyUpgrade());
        this.upgrades.put(13, new EnergyMultiplierUpgrade());
        this.upgrades.put(14, new LoudnessUpgrade());
        this.upgrades.put(15, new RoundRobinExportUpgrade());
        this.upgrades.put(16, new SlowDownUpgrade());
        this.upgrades.put(17, new FilteredBasicImportUpgrade());
        this.upgrades.put(18, new FilteredImportUpgrade());
        this.upgrades.put(19, new FilteredBasicExportUpgrade());
        this.upgrades.put(20, new FilteredExportUpgrade());
        this.upgrades.put(21, new BasicFluidImportUpgrade());
        this.upgrades.put(22, new FluidImportUpgrade());
        this.upgrades.put(23, new BasicFluidExportUpgrade());
        this.upgrades.put(24, new FluidExportUpgrade());
        this.upgrades.put(25, new FilteredBasicFluidImportUpgrade());
        this.upgrades.put(26, new FilteredFluidImportUpgrade());
        this.upgrades.put(27, new FilteredBasicFluidExportUpgrade());
        this.upgrades.put(28, new FilteredFluidExportUpgrade());
        this.upgrades.put(29, new ReactorTrackUpgrade());
        this.upgrades.put(30, new CobbleGenUpgrade());
        this.upgrades.put(31, new CraftingUpgrade());
        this.upgrades.put(32, new QuantumOverclockerUpgrade());
        this.upgrades.put(33, new SawBladeUpgrade(false, 1000));
        this.upgrades.put(34, new SawBladeUpgrade(true, 10000));
        this.upgrades.put(3000, new CreativeUpgrade());
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.ImportExport, this.createList(5, 6, 7, 8, 20, 21, 22, 23));
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.MachineModifierA, this.createList(0, 13, 18, 14));
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.MachineModifierB, this.createList(1, 2));
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.RedstoneControl, this.createList(3, 4));
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.Processing, this.createList(13));
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.Sounds, this.createList(9, 10, 16));
        SlotUpgrade.upgradeTextures.put(IMachineUpgradeItem.UpgradeType.Custom, this.createList(11, 15));
    }

    private List<Integer> createList(int ... indexes) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < indexes.length; ++i) {
            list.add(indexes[i]);
        }
        Collections.sort(list);
        return list;
    }

    public List<Integer> getSortedList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.upgrades.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<Integer> getValidVariants() {
        return this.getSortedList();
    }

    public boolean usesFacing(ItemStack stack) {
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (item != null) {
            return item.usesDirection();
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Integer meta : this.getSortedList()) {
            items.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
        }
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        IUpgradeMetaItem item = this.upgrades.get(meta);
        if (item != null) {
            return item.getTexture();
        }
        return Ic2Icons.getTextures("i0")[176];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (item != null) {
            List<String> ctrlList = sortedTooltip.get((Object)ToolTipType.Ctrl);
            List<String> altList = sortedTooltip.get((Object)ToolTipType.Alt);
            LinkedList<String> toAdd = new LinkedList<String>();
            sortedTooltip.put(ToolTipType.Ctrl, toAdd);
            if (item.usesOwner()) {
                toAdd.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.setUpgradeOwner));
            }
            if (item.hasInventory(stack)) {
                toAdd.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(3), Ic2Lang.openTheItemInventory));
            }
            item.addInfo(stack, player, tooltip, sortedTooltip);
            sortedTooltip.put(ToolTipType.Ctrl, ctrlList);
            if (toAdd.size() > 0) {
                ctrlList.add(Ic2Lang.onItemRightClick.getLocalized());
                ctrlList.addAll(toAdd);
                ctrlList.add("");
                toAdd.clear();
            }
            if (item.usesDirection()) {
                ctrlList.add(Ic2Lang.onBlockClick.getLocalized());
                ctrlList.add(TextFormatting.UNDERLINE + Ic2InfoLang.setUpgradeSideOpposite.getLocalized());
                ctrlList.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.setUpgradeSide));
                EnumFacing dir = item.getDir(stack);
                if (dir != null) {
                    altList.add(Ic2InfoLang.upgradeDirection.getLocalizedFormatted(dir));
                }
            }
            if (item.usesOwner() && this.getOwner(stack) != null) {
                altList.add(Ic2InfoLang.upgradeOwner.getLocalizedFormatted(this.getPlayerName(stack)));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isRendering()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (IC2.keyboard.isAltKeyDown(playerIn) && item.usesOwner()) {
            this.setOwner(stack, playerIn);
            IC2.platform.messagePlayer(playerIn, Ic2InfoLang.upgradeOwnerSet, playerIn.func_146103_bH().getName());
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (item.usesExtraRightClick(stack)) {
            item.onRightClick(stack, worldIn, playerIn, handIn);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (item.usesDirection() || item.usesBlockClick(stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack;
        IUpgradeMetaItem item;
        if (!world.field_72995_K && (item = this.upgrades.get((stack = player.func_184586_b(hand)).func_77960_j())) != null) {
            TileEntity tile;
            if (item.usesBlockClick(stack) && item.onBlockClick(stack, world, pos, player, hand)) {
                return EnumActionResult.SUCCESS;
            }
            if (item.usesDirection()) {
                item.setDirection(stack, player.func_70093_af() ? side : side.func_176734_d());
                IC2.platform.messagePlayer(player, Ic2InfoLang.upgradeDirectionSet, player.func_70093_af() ? side : side.func_176734_d());
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_77960_j() == 1 && (tile = world.func_175625_s(pos)) != null && tile.hasCapability(Ic2Capabilities.SinkLimiterCapability, null) && ((SinkLimiterHandler)tile.getCapability(Ic2Capabilities.SinkLimiterCapability, null)).addUpgrade(stack, player)) {
                IC2.platform.messagePlayer(player, Ic2InfoLang.upgradeInjected);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (item != null) {
            return item.getName();
        }
        return super.getLangComponent(stack);
    }

    @Override
    public int getExtraProcessSpeed(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getExtraProcessSpeed(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getProcessSpeedMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getProcessSpeedMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraProcessTime(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getExtraProcessTime(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getProcessTimeMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getExtraEnergyDemand(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getEnergyDemandMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getExtraEnergyStorage(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getEnergyStorageMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getEnergyStorageMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraTier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getExtraTier(upgrade, machine);
        }
        return 0;
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null && item.needsTick()) {
            item.onTick(upgrade, machine);
        }
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null && item.needsTick()) {
            item.onProcessFinished(upgrade, machine);
        }
    }

    @Override
    public float getSoundVolumeMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.getSoundVolumeMultiplier(upgrade, machine);
        }
        return 1.0f;
    }

    public int getItemStackLimit(ItemStack stack) {
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (item != null) {
            return item.getMaxStackSize(stack);
        }
        return super.getItemStackLimit(stack);
    }

    @Override
    public void onProcessEndPre(ItemStack upgrade, IMachine machine, MachineOutput output) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            item.onProcessEndPre(upgrade, machine, output);
        }
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<ItemStack> results) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            item.onProcessEndPost(upgrade, machine, input, output, results);
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType(ItemStack par1) {
        IUpgradeMetaItem item = this.upgrades.get(par1.func_77960_j());
        if (item != null) {
            return item.getType();
        }
        return null;
    }

    @Override
    public boolean useRedstoneInverter(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            return item.useRedstoneinverter(upgrade, machine);
        }
        return false;
    }

    @Override
    public void onInstalling(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(upgrade.func_77960_j());
        if (item != null) {
            item.onInstalling(upgrade, machine);
        }
    }

    public long getWorldTime(IMachine par1) {
        return ((TileEntity)par1).func_145831_w().func_72820_D();
    }

    public void setOwner(ItemStack par1, EntityPlayer par2) {
        if (par1 == null) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        GameProfile file = par2.func_146103_bH();
        UUID id = EntityPlayer.func_146094_a((GameProfile)file);
        if (nbt.func_74764_b("UpgradeData")) {
            NBTTagCompound data = nbt.func_74775_l("UpgradeData");
            data.func_186854_a("Owner", id);
            data.func_74778_a("PlayerName", file.getName());
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_186854_a("Owner", id);
        data.func_74778_a("PlayerName", file.getName());
        nbt.func_74782_a("UpgradeData", (NBTBase)data);
    }

    public String getPlayerName(ItemStack par1) {
        if (par1.func_190926_b()) {
            return null;
        }
        NBTTagCompound nbt = StackUtil.getNbtData(par1);
        if (!nbt.func_74764_b("UpgradeData")) {
            return null;
        }
        NBTTagCompound data = nbt.func_74775_l("UpgradeData");
        if (data.func_74764_b("PlayerName")) {
            return data.func_74779_i("PlayerName");
        }
        return null;
    }

    public UUID getOwner(ItemStack par1) {
        if (par1.func_190926_b()) {
            return null;
        }
        NBTTagCompound nbt = StackUtil.getNbtData(par1);
        if (!nbt.func_74764_b("UpgradeData")) {
            return null;
        }
        NBTTagCompound data = nbt.func_74775_l("UpgradeData");
        if (data.func_74764_b("Owner")) {
            return data.func_186857_a("Owner");
        }
        return null;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (item != null) {
            return item.getInventory(player, hand, stack);
        }
        return null;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    @Override
    public void onNetworkEvent(ItemStack stack, EntityPlayer player, int event) {
        IUpgradeMetaItem item = this.upgrades.get(stack.func_77960_j());
        if (item != null) {
            item.onNetworkEvent(player, stack, event);
        }
    }
}

