/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.inventory;

import ic2.api.classic.network.INetworkFieldData;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.item.inv.inventories.InventorySlotTypeUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.BaseMetaInventoryUpgrade;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotTypeModifier
extends BaseMetaInventoryUpgrade
implements IHandHeldInventory {
    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        if (!nbt.func_74767_n("Loaded")) {
            return;
        }
        if (!nbt.func_74779_i("ID").equals(handler.getInventoryID())) {
            return;
        }
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            SlotType type = SlotType.getTypeFromID(data.func_74762_e("ID"));
            if (type == null) continue;
            RotationList rotation = RotationList.readFromNumber(nbt.func_74762_e("Sides"));
            handler.setTypeToSide(rotation, type);
            handler.clearTypeForSide(rotation.getOppositeList(), type);
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean adv, Map<ToolTipType, List<String>> sortedToolTips) {
        super.addInformation(stack, player, list, adv, sortedToolTips);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (!nbt.func_74767_n("Loaded")) {
            return;
        }
        LinkedList<Tuple> sets = new LinkedList<Tuple>();
        NBTTagList nbtList = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound data = nbtList.func_150305_b(i);
            SlotType type = SlotType.getTypeFromID(data.func_74762_e("ID"));
            if (type == null) continue;
            sets.add(new Tuple((Object)type, RotationList.readFromNumber(data.func_74762_e("Sides")).toSet()));
        }
        String yes = Ic2Lang.yes.getLocalized();
        String no = Ic2Lang.no.getLocalized();
        List<String> altList = sortedToolTips.get((Object)ToolTipType.Alt);
        for (Tuple entry : sets) {
            Set facing = (Set)entry.func_76340_b();
            altList.add(Ic2InfoLang.invUpgradeSlotAccesses.getLocalizedFormatted(((SlotType)entry.func_76341_a()).getLocalizedName(), facing.contains(EnumFacing.DOWN) ? yes : no, facing.contains(EnumFacing.UP) ? yes : no, facing.contains(EnumFacing.NORTH) ? yes : no, facing.contains(EnumFacing.SOUTH) ? yes : no, facing.contains(EnumFacing.WEST) ? yes : no, facing.contains(EnumFacing.EAST) ? yes : no));
        }
    }

    @Override
    public IInventoryModifier.EffectType getEffect() {
        return IInventoryModifier.EffectType.Slot;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return Ic2Icons.getTextures("i1")[163];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.slotTypeUpgrade;
    }

    @Override
    public void onNetworkEvent(ItemStack networkStack, EntityPlayer player, INetworkFieldData data) {
        if (!(data instanceof PayloadFieldPacket)) {
            return;
        }
        PayloadFieldPacket payload = (PayloadFieldPacket)data;
        int size = payload.getSize(1) - 1;
        if (payload.getSize(2) != 1 || size < 1) {
            return;
        }
        int realSize = payload.getNumber(0);
        if (size != realSize * 2) {
            return;
        }
        ItemStack stack = player.func_184586_b(payload.getFlag(0) ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (!StackUtil.isStackEqual(networkStack, stack)) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < realSize; ++i) {
            int slot = i * 2 + 1;
            int type = payload.getNumber(slot);
            if (SlotType.getTypeFromID(type) == null) continue;
            int sides = payload.getNumber(slot + 1);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("ID", (short)type);
            nbt.func_74774_a("Sides", (byte)sides);
            list.func_74742_a((NBTBase)nbt);
        }
        StackUtil.getOrCreateNbtData(stack).func_74782_a("Data", (NBTBase)list);
        IC2.platform.messagePlayer(player, Ic2InfoLang.machineToolSavedData);
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new InventorySlotTypeUpgrade(stack, hand);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> onRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K || player.func_70093_af()) {
            return super.onRightClick(stack, world, player, hand);
        }
        if (!StackUtil.getNbtData(stack).func_74767_n("Loaded")) {
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeNeedsBound);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean hasBlockClick() {
        return true;
    }

    @Override
    public EnumActionResult onBlockClick(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHasHandler) {
            IHasHandler handler = (IHasHandler)tile;
            InventoryHandler inv = handler.getHandler();
            if (inv == null || !inv.canModifySlots()) {
                IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeBoundFailed);
                return EnumActionResult.FAIL;
            }
            this.readFromBlock(stack, inv);
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeBoundSuccess);
            return EnumActionResult.SUCCESS;
        }
        return super.onBlockClick(stack, world, pos, side, player, hand);
    }

    private void readFromBlock(ItemStack stack, InventoryHandler handler) {
        Set<SlotType> types = handler.getSlotTypes();
        NBTTagList list = new NBTTagList();
        for (SlotType type : types) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("ID", (short)type.getID());
            nbt.func_74774_a("Sides", (byte)0);
            list.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74782_a("Data", (NBTBase)list);
        nbt.func_74778_a("ID", handler.getInventoryID());
        nbt.func_74757_a("Loaded", true);
    }
}

