/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CreativeUpgrade
extends BaseMetaUpgrade {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTip) {
        par3.add(Ic2InfoLang.upgradeCreativeOnly.getLocalized());
    }

    @Override
    public int getExtraProcessSpeed(ItemStack upgrade, IMachine machine) {
        return Integer.MAX_VALUE;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack upgrade, IMachine machine) {
        return 0.0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack upgrade, IMachine machine) {
        return 0.0;
    }

    @Override
    public int getExtraTier(ItemStack upgrade, IMachine machine) {
        return 13;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack upgrade, IMachine machine) {
        return 0x3FFFFFFF;
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        IEnergySink sink;
        double needed;
        if (machine instanceof IEnergySink && (needed = (sink = (IEnergySink)((Object)machine)).getDemandedEnergy()) > 1.0) {
            sink.injectEnergy(EnumFacing.UP, EnergyNet.instance.getPowerFromTier(sink.getSinkTier()) - 1.0, 0.0);
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.Custom;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.creativeUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[139];
    }
}

