/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.event.MachineRecipeEvent;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IRecipeMachine;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.upgrades.subtypes.machine.BaseFilteredUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FilteredBasicExportUpgrade
extends BaseFilteredUpgrade {
    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        if (this.getWorldTime(machine) % 20L == 0L) {
            this.sendItems(upgrade, machine);
        }
    }

    public void sendItems(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos())) != null) {
            ItemStack added;
            ItemStack stack;
            IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (mach == null || target == null) {
                return;
            }
            IFilter filter = this.getFilter(upgrade);
            int max = Math.min(9, upgrade.func_190916_E());
            for (int i = 0; i < max && !(stack = mach.removeItem(filter, dir.toFacing(), 1, false)).func_190926_b() && (added = target.addItem(stack, dir.getInverse().toFacing(), true)).func_190916_E() > 0; ++i) {
                mach.removeItem(filter, dir.toFacing(), added.func_190916_E(), true);
                this.addItem(this.getOwner(upgrade), machine, added.func_77946_l());
            }
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        this.sendItems(upgrade, machine);
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<ItemStack> items) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos())) != null) {
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (target == null) {
                return;
            }
            IFilter filter = this.getFilter(upgrade);
            int toAdd = Math.min(upgrade.func_190916_E(), 9);
            for (int i = 0; i < items.size(); ++i) {
                ItemStack split;
                ItemStack added;
                ItemStack item = items.get(i);
                if (item.func_190926_b() || !filter.matches(item) || (added = target.addItem(split = item.func_77946_l().func_77979_a(Math.max(1, toAdd)), dir.getInverse().toFacing(), true)).func_190916_E() <= 0) continue;
                item.func_190918_g(added.func_190916_E());
                if (item.func_190926_b()) {
                    items.remove(i--);
                }
                this.addItem(this.getOwner(upgrade), machine, added.func_77946_l());
                if ((toAdd -= added.func_190916_E()) <= 0) break;
            }
        }
    }

    public void addItem(UUID id, IMachine machine, ItemStack toAdd) {
        MachineRecipeEvent event;
        if (id == null || !(machine instanceof IRecipeMachine) || toAdd.func_190926_b()) {
            return;
        }
        MachineType type = ((IRecipeMachine)((Object)machine)).getType();
        if (type == null) {
            return;
        }
        EntityPlayerMP player = IC2.platform.getServer().func_184103_al().func_177451_a(id);
        if (player != null && (event = type.createEvent((EntityPlayer)player, toAdd, true)) != null) {
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.basicFilteredExportUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[154];
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }
}

