/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.filters.TupleFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.inventory.transport.transporter.ExactTransporter;
import ic2.core.item.upgrades.subtypes.machine.BaseFilteredUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FilteredImportUpgrade
extends BaseFilteredUpgrade {
    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        if (this.getWorldTime(machine) % 20L == 0L) {
            this.importItems(upgrade, machine);
        }
    }

    public void importItems(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null) {
            IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (mach == null || target == null) {
                return;
            }
            if (this.isUpgraded(upgrade)) {
                ItemStack added;
                int max;
                int limit = this.getStackSize(upgrade);
                if (limit != (max = Math.min(limit, (int)(machine.getEnergy() * 3.0)))) {
                    return;
                }
                ExactTransporter exact = new ExactTransporter(target);
                Tuple<ItemStack, IFilter> result = exact.findItems(this.getFilters(upgrade, new MachineFilter(machine)), max, dir.getInverse().toFacing());
                if (result != null && (added = mach.addItem((ItemStack)result.func_76341_a(), dir.toFacing(), false)).func_190916_E() == max) {
                    mach.addItem((ItemStack)result.func_76341_a(), dir.toFacing(), true);
                    exact.removeItems((IFilter)result.func_76340_b(), max, dir.getInverse().toFacing());
                }
            } else {
                ItemStack added;
                ItemStack stack;
                int max;
                TupleFilter filter = new TupleFilter(this.getFilter(upgrade), new MachineFilter(machine));
                int amount = Math.min(9, upgrade.func_190916_E());
                for (int i = 0; i < amount && (max = Math.min(64, (int)(machine.getEnergy() * 3.0))) > 0 && !(stack = target.removeItem(filter, dir.getInverse().toFacing(), max, false)).func_190926_b() && (added = mach.addItem(stack, dir.toFacing(), true)).func_190916_E() > 0; ++i) {
                    target.removeItem(filter, dir.getInverse().toFacing(), added.func_190916_E(), true);
                    machine.useEnergy(Math.max(1, added.func_190916_E() / 3), false);
                }
            }
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        this.importItems(upgrade, machine);
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<ItemStack> items) {
        TileEntity tile;
        if (items.isEmpty()) {
            return;
        }
        if (input.getAmount() < 4) {
            return;
        }
        if (this.isUpgraded(upgrade)) {
            return;
        }
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null) {
            ItemStack added;
            IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (mach == null || target == null) {
                return;
            }
            TupleFilter filter = new TupleFilter(this.getFilter(upgrade), new MachineFilter(machine));
            int amount = Math.min(64, (int)(machine.getEnergy() * 3.0));
            ItemStack stack = target.removeItem(filter, dir.getInverse().toFacing(), amount, false);
            if (!stack.func_190926_b() && (added = mach.addItem(stack, dir.toFacing(), true)).func_190916_E() > 0) {
                target.removeItem(filter, dir.getInverse().toFacing(), added.func_190916_E(), true);
                machine.useEnergy(Math.max(1, added.func_190916_E() / 3), false);
            }
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[153];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.filteredImportUpgrade;
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }

    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> sortedTooltip) {
        if (this.isUpgraded(par1)) {
            sortedTooltip.get((Object)ToolTipType.Alt).add(Ic2InfoLang.upgradeStackSize.getLocalizedFormatted(this.getStackSize(par1)));
        }
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        PlayerHandler handler = PlayerHandler.getHandlerForPlayer(player);
        if (this.isUpgraded(item) && handler.modeSwitchKeyDown) {
            int amount;
            int n = amount = handler.altKeyDown ? 10 : 1;
            if (player.func_70093_af()) {
                amount = -amount;
            }
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
            int size = MathHelper.func_76125_a((int)(nbt.func_74762_e("Size") + amount), (int)1, (int)64);
            nbt.func_74768_a("Size", size);
            IC2.platform.messagePlayer(player, Ic2InfoLang.upgradeStackSize, size);
        } else {
            super.onRightClick(item, world, player, hand);
        }
    }

    @Override
    public int getMaxStackSize(ItemStack stack) {
        return this.isUpgraded(stack) ? 1 : 64;
    }

    public boolean isUpgraded(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("Upgraded");
    }

    public int getStackSize(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Size");
    }
}

