/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.event.MachineRecipeEvent;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IRecipeMachine;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.personal.base.misc.IPersonalBlock;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RoundRobinExportUpgrade
extends BaseMetaUpgrade {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTips) {
        List<String> ctrlTip = toolTips.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.modifyTargetSlot));
        List<String> altTip = toolTips.get((Object)ToolTipType.Alt);
        altTip.add(Ic2InfoLang.targetSlot.getLocalizedFormatted(this.getSelectedSlot(par1)));
        NBTTagCompound nbt = StackUtil.getNbtData(par1);
        for (int i = 0; i < 4; ++i) {
            altTip.add(Ic2InfoLang.slotInfo.getLocalizedFormatted(i, Ic2Lang.getFacingComp(nbt.func_74764_b("Slot" + i) ? EnumFacing.func_82600_a((int)nbt.func_74762_e("Slot" + i)) : null)));
        }
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        if (!(machine instanceof TileEntity)) {
            return;
        }
        if (!machine.isProcessing() && this.getWorldTime(machine) % 20L == 0L) {
            Direction dir = this.getCurrentDir(upgrade);
            if (dir != null) {
                TileEntity tile = dir.applyToTileEntity((TileEntity)machine);
                if (tile != null) {
                    ItemStack added;
                    Object obj = tile;
                    if (tile instanceof IPersonalBlock) {
                        obj = ((IPersonalBlock)tile).getInventory(this.getOwner(upgrade));
                    }
                    IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
                    IItemTransporter target = TransporterManager.manager.getTransporter(obj, true);
                    if (mach == null || target == null) {
                        return;
                    }
                    int aviableItems = Math.min(64, (int)(machine.getEnergy() * 3.0));
                    ItemStack stack = mach.removeItem(CommonFilters.Anything, dir.toFacing(), aviableItems, false);
                    if (!stack.func_190926_b() && (added = target.addItem(stack, dir.getInverse().toFacing(), true)).func_190916_E() > 0) {
                        mach.removeItem(CommonFilters.Anything, dir.toFacing(), added.func_190916_E(), true);
                        machine.useEnergy(Math.max(1, added.func_190916_E() / 3), false);
                        this.increaseTickingSlot(upgrade);
                        this.addItem(this.getOwner(upgrade), machine, Arrays.asList(added.func_77946_l()));
                    }
                }
            } else {
                this.increaseTickingSlot(upgrade);
            }
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<ItemStack> items) {
        if (!(machine instanceof TileEntity)) {
            return;
        }
        Direction dir = this.getCurrentDir(upgrade);
        if (dir != null) {
            TileEntity tile = dir.applyToTileEntity((TileEntity)machine);
            if (tile != null) {
                IItemTransporter target;
                Object obj = tile;
                if (tile instanceof IPersonalBlock) {
                    obj = ((IPersonalBlock)tile).getInventory(this.getOwner(upgrade));
                }
                if ((target = TransporterManager.manager.getTransporter(obj, true)) == null) {
                    return;
                }
                int aviableItems = Math.min(64, (int)(machine.getEnergy() * 3.0));
                int itemsAdded = 0;
                ArrayList<ItemStack> left = new ArrayList<ItemStack>();
                ArrayList<ItemStack> eventList = new ArrayList<ItemStack>();
                while (!items.isEmpty() && aviableItems > 0) {
                    ItemStack item = items.remove(0);
                    if (item == null) continue;
                    ItemStack split = item.func_77946_l();
                    split.func_190918_g(Math.min(aviableItems, item.func_190916_E()));
                    ItemStack added = target.addItem(split, dir.getInverse().toFacing(), true);
                    if (added.func_190916_E() > 0) {
                        eventList.add(added.func_77946_l());
                        item.func_190918_g(added.func_190916_E());
                        itemsAdded += added.func_190916_E();
                        aviableItems -= added.func_190916_E();
                        if (item.func_190916_E() <= 0) continue;
                    }
                    left.add(item);
                }
                machine.useEnergy(Math.max(1, itemsAdded / 3), false);
                if (!left.isEmpty()) {
                    items.addAll(left);
                }
                this.addItem(this.getOwner(upgrade), machine, eventList);
                if (itemsAdded > 0) {
                    this.increaseTickingSlot(upgrade);
                }
            }
        } else {
            this.increaseTickingSlot(upgrade);
        }
    }

    public void addItem(UUID id, IMachine machine, List<ItemStack> list) {
        if (id == null || !(machine instanceof IRecipeMachine) || list.isEmpty()) {
            return;
        }
        MachineType type = ((IRecipeMachine)((Object)machine)).getType();
        if (type == null) {
            return;
        }
        EntityPlayerMP player = IC2.platform.getServer().func_184103_al().func_177451_a(id);
        if (player != null) {
            for (int i = 0; i < list.size(); ++i) {
                MachineRecipeEvent event;
                ItemStack toAdd = list.get(i);
                if (toAdd.func_190926_b() || (event = type.createEvent((EntityPlayer)player, toAdd, true)) == null) continue;
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        }
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.roundRobinExportUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[145];
    }

    @Override
    public void setDirection(ItemStack par1, EnumFacing dir) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        nbt.func_74774_a("Slot" + nbt.func_74771_c("SelectedSlot"), (byte)dir.func_176745_a());
    }

    @Override
    public EnumFacing getDir(ItemStack par1) {
        String slot;
        NBTTagCompound nbt = StackUtil.getNbtData(par1);
        if (nbt.func_74764_b(slot = "Slot" + nbt.func_74771_c("SelectedSlot"))) {
            return EnumFacing.func_82600_a((int)nbt.func_74762_e(slot));
        }
        return null;
    }

    public void clearCurrentSlot(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        String slot = "Slot" + nbt.func_74771_c("SelectedSlot");
        nbt.func_82580_o(slot);
    }

    public Direction getCurrentDir(ItemStack stack) {
        String slot;
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b(slot = "Slot" + nbt.func_74771_c("TickingSlot"))) {
            return Direction.fromSideValue(nbt.func_74762_e(slot));
        }
        return null;
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (player.func_70093_af()) {
                this.clearCurrentSlot(item);
                return;
            }
            int slot = this.getSelectedSlot(item) + 1;
            if (slot >= 4) {
                slot = 0;
            }
            this.setSelectedSlot(item, slot);
            IC2.platform.messagePlayer(player, Ic2InfoLang.targetSlotChanged, slot);
        }
    }

    public int getSelectedSlot(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("SelectedSlot");
    }

    public void setSelectedSlot(ItemStack stack, int slot) {
        StackUtil.getOrCreateNbtData(stack).func_74774_a("SelectedSlot", (byte)slot);
    }

    public int getTickingSlot(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("TickingSlot");
    }

    public void setTickingSlot(ItemStack stack, int slot) {
        StackUtil.getOrCreateNbtData(stack).func_74774_a("TickingSlot", (byte)slot);
    }

    public void increaseTickingSlot(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            int slot = this.getTickingSlot(stack) + 1;
            if (slot >= 4) {
                slot = 0;
            }
            this.setTickingSlot(stack, slot);
            if (this.getCurrentDir(stack) == null) continue;
            return;
        }
    }
}

