/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import com.mojang.authlib.GameProfile;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DataEncoder {
    public static void encode(OutputBuffer buffer, Object obj) {
        DataEncoder.encode(buffer, obj, NetworkField.BitLevel.Bit0);
    }

    public static void encode(OutputBuffer buffer, Object obj, NetworkField.BitLevel level) {
        if (obj == null) {
            buffer.writeByte((byte)-1);
        } else if (obj instanceof Number) {
            if (obj instanceof Integer) {
                buffer.writeByte((byte)0);
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(((Integer)obj).intValue(), level);
                } else {
                    buffer.writeInt((Integer)obj);
                }
            } else if (obj instanceof Short) {
                buffer.writeByte((byte)1);
                if (level.isValid(NetworkField.BitLevel.Bit16)) {
                    buffer.writeData(((Short)obj).shortValue(), level);
                } else {
                    buffer.writeShort((Short)obj);
                }
            } else if (obj instanceof Long) {
                buffer.writeByte((byte)2);
                if (level.isValid(NetworkField.BitLevel.Bit64)) {
                    buffer.writeData((Long)obj, level);
                } else {
                    buffer.writeLong((Long)obj);
                }
            } else if (obj instanceof Float) {
                buffer.writeByte((byte)3);
                buffer.writeFloat(((Float)obj).floatValue());
            } else if (obj instanceof Double) {
                buffer.writeByte((byte)4);
                buffer.writeDouble((Double)obj);
            } else if (obj instanceof Byte) {
                buffer.writeByte((byte)5);
                buffer.writeByte((Byte)obj);
            }
        } else if (obj instanceof Boolean) {
            buffer.writeByte((byte)6);
            buffer.writeBoolean((Boolean)obj);
        } else if (obj instanceof String) {
            buffer.writeByte((byte)7);
            if (level.isValid(NetworkField.BitLevel.Bit32)) {
                buffer.writeString((String)obj, level);
            } else {
                buffer.writeString((String)obj);
            }
        } else if (obj.getClass().isArray()) {
            if (obj instanceof int[]) {
                buffer.writeByte((byte)8);
                int[] array = (int[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeInt(array[i]);
                }
            } else if (obj instanceof short[]) {
                buffer.writeByte((byte)9);
                short[] array = (short[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeShort(array[i]);
                }
            } else if (obj instanceof long[]) {
                buffer.writeByte((byte)10);
                long[] array = (long[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeLong(array[i]);
                }
            } else if (obj instanceof float[]) {
                buffer.writeByte((byte)11);
                float[] array = (float[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeFloat(array[i]);
                }
            } else if (obj instanceof double[]) {
                buffer.writeByte((byte)12);
                double[] array = (double[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeDouble(array[i]);
                }
            } else if (obj instanceof byte[]) {
                buffer.writeByte((byte)13);
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeBytes((byte[])obj, level);
                } else {
                    buffer.writeBytes((byte[])obj);
                }
            } else if (obj instanceof boolean[]) {
                buffer.writeByte((byte)14);
                boolean[] array = (boolean[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeBoolean(array[i]);
                }
            } else if (obj instanceof String[]) {
                buffer.writeByte((byte)15);
                String[] array = (String[])obj;
                if (level.isValid(NetworkField.BitLevel.Bit32)) {
                    buffer.writeData(array.length, level);
                } else {
                    buffer.writeInt(array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeString(array[i]);
                }
            }
        } else if (obj instanceof INetworkFieldData) {
            buffer.writeByte((byte)16);
            try {
                OutputBuffer subBuffer = new OutputBuffer(Unpooled.buffer());
                ((INetworkFieldData)obj).write(subBuffer);
                buffer.writeBytes(subBuffer.getBuf().array());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (obj instanceof ItemStack) {
            buffer.writeByte((byte)17);
            ItemStack item = (ItemStack)obj;
            buffer.writeForgeEntry((IForgeRegistryEntry)item.func_77973_b());
            buffer.writeShort((short)item.func_77960_j());
            buffer.writeByte((byte)item.func_190916_E());
            buffer.writeShort((short)item.func_77952_i());
            boolean nbt = item.func_77942_o();
            buffer.writeBoolean(nbt);
            if (nbt) {
                buffer.writeNBTData(item.func_77978_p());
            }
        } else if (obj instanceof Item) {
            buffer.writeByte((byte)18);
            buffer.writeForgeEntry((IForgeRegistryEntry)((Item)obj));
        } else if (obj instanceof Block) {
            buffer.writeByte((byte)19);
            buffer.writeForgeEntry((IForgeRegistryEntry)((Block)obj));
        } else if (obj instanceof Enchantment) {
            buffer.writeByte((byte)20);
            buffer.writeForgeEntry((IForgeRegistryEntry)((Enchantment)obj));
        } else if (obj instanceof Potion) {
            buffer.writeByte((byte)21);
            buffer.writeForgeEntry((IForgeRegistryEntry)((Potion)obj));
        } else if (obj instanceof StatBase) {
            buffer.writeByte((byte)22);
            buffer.writeString(((StatBase)obj).field_75975_e, NetworkField.BitLevel.Bit16);
        } else if (obj instanceof CropCard) {
            buffer.writeByte((byte)23);
            CropCard card = (CropCard)obj;
            buffer.writeString(new ResourceLocation(card.getOwner(), card.getId()).toString(), NetworkField.BitLevel.Bit16);
        } else if (obj instanceof NBTTagCompound) {
            buffer.writeByte((byte)24);
            buffer.writeNBTData((NBTTagCompound)obj);
        } else if (obj instanceof BlockPos) {
            buffer.writeByte((byte)25);
            BlockPos pos = (BlockPos)obj;
            buffer.writeLong(pos.func_177986_g());
        } else if (obj instanceof Vec3d) {
            buffer.writeByte((byte)26);
            Vec3d pos = (Vec3d)obj;
            buffer.writeDouble(pos.field_72450_a);
            buffer.writeDouble(pos.field_72448_b);
            buffer.writeDouble(pos.field_72449_c);
        } else if (obj instanceof Vec3i) {
            buffer.writeByte((byte)27);
            Vec3i pos = (Vec3i)obj;
            buffer.writeInt(pos.func_177958_n());
            buffer.writeInt(pos.func_177956_o());
            buffer.writeInt(pos.func_177952_p());
        } else if (obj instanceof TileEntity) {
            buffer.writeByte((byte)28);
            TileEntity tile = (TileEntity)obj;
            buffer.writeInt(tile.func_145831_w().field_73011_w.getDimension());
            BlockPos pos = tile.func_174877_v();
            buffer.writeLong(pos.func_177986_g());
        } else if (obj instanceof World) {
            buffer.writeByte((byte)29);
            buffer.writeInt(((World)obj).field_73011_w.getDimension());
        } else if (obj instanceof FluidStack) {
            buffer.writeByte((byte)30);
            FluidStack fluid = (FluidStack)obj;
            String id = FluidRegistry.getFluidName((FluidStack)fluid);
            if (id == null) {
                buffer.writeString("Empty", NetworkField.BitLevel.Bit16);
                return;
            }
            buffer.writeString(id, NetworkField.BitLevel.Bit16);
            buffer.writeInt(fluid.amount);
            NBTTagCompound nbt = fluid.tag;
            buffer.writeBoolean(nbt != null);
            if (nbt != null) {
                buffer.writeNBTData(nbt);
            }
        } else if (obj instanceof FluidTank) {
            buffer.writeByte((byte)31);
            FluidTank tank = (FluidTank)obj;
            boolean empty = tank.getFluid() == null;
            buffer.writeBoolean(empty);
            if (empty) {
                buffer.writeInt(tank.getCapacity());
            } else {
                DataEncoder.encode(buffer, tank.getFluid());
                buffer.writeInt(tank.getCapacity());
            }
        } else if (obj instanceof UUID) {
            buffer.writeByte((byte)32);
            buffer.writeUUID((UUID)obj);
        } else if (obj instanceof GameProfile) {
            buffer.writeByte((byte)33);
            GameProfile prof = (GameProfile)obj;
            buffer.writeString(prof.getName(), NetworkField.BitLevel.Bit16);
            buffer.writeUUID(prof.getId());
        } else if (obj instanceof Enum) {
            buffer.writeByte((byte)34);
            buffer.writeString(((Enum)obj).name(), NetworkField.BitLevel.Bit16);
        } else if (obj instanceof ResourceLocation) {
            buffer.writeByte((byte)35);
            buffer.writeString(((ResourceLocation)obj).toString());
        } else {
            FMLLog.getLogger().info("Unknown Object: " + obj);
        }
    }

    public static Object decode(InputBuffer buffer) {
        return DataEncoder.decode(buffer, NetworkField.BitLevel.Bit0);
    }

    public static Object decode(InputBuffer buffer, NetworkField.BitLevel level) {
        byte index = buffer.readByte();
        switch (index) {
            case -1: {
                return null;
            }
            case 0: {
                return level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt();
            }
            case 1: {
                return level.isValid(NetworkField.BitLevel.Bit16) ? (short)buffer.readData(level) : buffer.readShort();
            }
            case 2: {
                return level.isValid(NetworkField.BitLevel.Bit64) ? buffer.readData(level) : buffer.readLong();
            }
            case 3: {
                return Float.valueOf(buffer.readFloat());
            }
            case 4: {
                return buffer.readDouble();
            }
            case 5: {
                return buffer.readByte();
            }
            case 6: {
                return buffer.readBoolean();
            }
            case 7: {
                return level.isValid(NetworkField.BitLevel.Bit32) ? buffer.readString(level) : buffer.readString();
            }
            case 8: {
                int[] array = new int[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readInt();
                }
                return array;
            }
            case 9: {
                short[] array = new short[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readShort();
                }
                return array;
            }
            case 10: {
                long[] array = new long[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readLong();
                }
                return array;
            }
            case 11: {
                float[] array = new float[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readFloat();
                }
                return array;
            }
            case 12: {
                double[] array = new double[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readDouble();
                }
                return array;
            }
            case 13: {
                return level.isValid(NetworkField.BitLevel.Bit32) ? buffer.readBytes(level) : buffer.readBytes();
            }
            case 14: {
                boolean[] array = new boolean[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readBoolean();
                }
                return array;
            }
            case 15: {
                String[] array = new String[level.isValid(NetworkField.BitLevel.Bit32) ? (int)buffer.readData(level) : buffer.readInt()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buffer.readString();
                }
                return array;
            }
            case 16: {
                return new InputBuffer(buffer.getSubBuffer());
            }
            case 17: {
                Item item = (Item)buffer.readForgeRegistryEntry(Item.field_150901_e);
                short meta = buffer.readShort();
                byte stacksize = buffer.readByte();
                ItemStack stack = new ItemStack(item, (int)stacksize, (int)meta);
                stack.func_77964_b((int)buffer.readShort());
                if (buffer.readBoolean()) {
                    stack.func_77982_d(buffer.readNBTData());
                }
                return stack;
            }
            case 18: {
                return buffer.readForgeRegistryEntry(Item.field_150901_e);
            }
            case 19: {
                return buffer.readForgeRegistryEntry(Block.field_149771_c);
            }
            case 20: {
                return buffer.readForgeRegistryEntry(Enchantment.field_185264_b);
            }
            case 21: {
                return buffer.readForgeRegistryEntry(Potion.field_188414_b);
            }
            case 22: {
                return StatList.func_151177_a((String)buffer.readString(NetworkField.BitLevel.Bit16));
            }
            case 23: {
                ResourceLocation loc = new ResourceLocation(buffer.readString(NetworkField.BitLevel.Bit16));
                return Crops.instance.getCropCard(loc.func_110624_b(), loc.func_110623_a());
            }
            case 24: {
                return buffer.readNBTData();
            }
            case 25: {
                return BlockPos.func_177969_a((long)buffer.readLong());
            }
            case 26: {
                double x = buffer.readDouble();
                double y = buffer.readDouble();
                double z = buffer.readDouble();
                return new Vec3i(x, y, z);
            }
            case 27: {
                int x = buffer.readInt();
                int y = buffer.readInt();
                int z = buffer.readInt();
                return new Vec3i(x, y, z);
            }
            case 28: {
                World world = IC2.platform.getWorld(buffer.readInt());
                if (world == null) {
                    return null;
                }
                return world.func_175625_s(BlockPos.func_177969_a((long)buffer.readLong()));
            }
            case 29: {
                return IC2.platform.getWorld(buffer.readInt());
            }
            case 30: {
                String id = buffer.readString(NetworkField.BitLevel.Bit16);
                if (id.equals("Empty")) {
                    return null;
                }
                Fluid fluid = FluidRegistry.getFluid((String)id);
                if (fluid == null) {
                    return null;
                }
                int amount = buffer.readInt();
                if (!buffer.readBoolean()) {
                    return new FluidStack(fluid, amount);
                }
                return new FluidStack(fluid, amount, buffer.readNBTData());
            }
            case 31: {
                boolean empty = buffer.readBoolean();
                if (empty) {
                    return new FluidTank(buffer.readInt());
                }
                FluidStack stack = (FluidStack)DataEncoder.decode(buffer);
                return new FluidTank(stack, buffer.readInt());
            }
            case 32: {
                return buffer.readUUID();
            }
            case 33: {
                String id = buffer.readString(NetworkField.BitLevel.Bit16);
                return new GameProfile(buffer.readUUID(), id);
            }
            case 34: {
                return buffer.readString(NetworkField.BitLevel.Bit16);
            }
            case 35: {
                return new ResourceLocation(buffer.readString());
            }
        }
        return null;
    }
}

