/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player;

import ic2.core.IC2;
import ic2.core.platform.player.Keyboard;
import ic2.core.platform.player.PlayerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class KeyboardClient
extends Keyboard {
    private Minecraft mc;
    private KeyBinding altKey;
    private KeyBinding boostKey;
    private KeyBinding modeSwitchKey;
    private KeyBinding sideinventoryKey;
    private KeyBinding expandinfoKey;
    private KeyBinding toggleKey;
    private int lastKeyState = 0;
    private boolean guiDissabled;

    @Override
    public void init() {
        this.mc = FMLClientHandler.instance().getClient();
        this.altKey = new KeyBinding("ALT Key", 56, "IC2 Keys");
        this.boostKey = new KeyBinding("Boost Key", 29, "IC2 Keys");
        this.modeSwitchKey = new KeyBinding("Mode Switch Key", 50, "IC2 Keys");
        this.sideinventoryKey = new KeyBinding("Side Inventory Key", 46, "IC2 Keys");
        this.expandinfoKey = new KeyBinding("Hub Expand Key", 45, "IC2 Keys");
        this.toggleKey = new KeyBinding("Toggle Key", 47, "IC2 Keys");
        ClientRegistry.registerKeyBinding((KeyBinding)this.altKey);
        ClientRegistry.registerKeyBinding((KeyBinding)this.boostKey);
        ClientRegistry.registerKeyBinding((KeyBinding)this.modeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)this.sideinventoryKey);
        ClientRegistry.registerKeyBinding((KeyBinding)this.expandinfoKey);
        ClientRegistry.registerKeyBinding((KeyBinding)this.toggleKey);
        this.updateConfig();
    }

    public void updateConfig() {
        this.guiDissabled = !IC2.config.getFlag("KeysInGuis");
    }

    @Override
    public void sendKeyUpdate() {
        int currentKeyState = (this.isKeyPressed(this.altKey) ? 1 : 0) << 0 | (this.isKeyPressed(this.boostKey) ? 1 : 0) << 1 | (this.isKeyPressed(this.mc.field_71474_y.field_74351_w) ? 1 : 0) << 2 | (this.isKeyPressed(this.modeSwitchKey) ? 1 : 0) << 3 | (this.isKeyPressed(this.mc.field_71474_y.field_74314_A) ? 1 : 0) << 4 | (this.isKeyPressed(this.sideinventoryKey) ? 1 : 0) << 5 | (this.isKeyPressed(this.expandinfoKey) ? 1 : 0) << 6 | (this.isKeyPressed(this.toggleKey) ? 1 : 0) << 7;
        if (this.guiDissabled && this.mc.field_71462_r != null || this.mc.field_71462_r instanceof GuiChat) {
            currentKeyState = 0;
        }
        if (currentKeyState != this.lastKeyState) {
            EntityPlayer player = IC2.platform.getPlayerInstance();
            if (player != null) {
                IC2.network.get().initiateKeyUpdate(currentKeyState);
                this.processKeyUpdate(player, currentKeyState);
            }
            this.lastKeyState = currentKeyState;
        }
    }

    public boolean isKeyPressed(KeyBinding binding) {
        return GameSettings.func_100015_a((KeyBinding)binding) && binding.getKeyConflictContext().isActive() && binding.getKeyModifier().isActive(binding.getKeyConflictContext());
    }

    @Override
    public void processKeyUpdate(EntityPlayer player, int keyState) {
        super.processKeyUpdate(player, keyState);
        PlayerHandler.getClientPlayerHandler().updateKeys(keyState);
    }

    @Override
    public String getKeyName(int type) {
        switch (type) {
            case 0: {
                return this.getKeyName(this.altKey);
            }
            case 1: {
                return this.getKeyName(this.boostKey);
            }
            case 2: {
                return this.getKeyName(this.modeSwitchKey);
            }
            case 3: {
                return this.getKeyName(this.sideinventoryKey);
            }
            case 4: {
                return this.getKeyName(this.expandinfoKey);
            }
            case 5: {
                return this.getKeyName(this.toggleKey);
            }
            case 6: {
                return this.getKeyName(this.mc.field_71474_y.field_74314_A);
            }
            case 7: {
                return this.getKeyName(this.mc.field_71474_y.field_74351_w);
            }
            case 8: {
                return this.getKeyName(this.mc.field_71474_y.field_74368_y);
            }
            case 9: {
                return this.getKeyName(this.mc.field_71474_y.field_74311_E);
            }
        }
        return "Unknown Type";
    }

    private String getKeyName(KeyBinding key) {
        String name = key.getDisplayName();
        if (name.equalsIgnoreCase("None")) {
            return key.func_151464_g();
        }
        return name;
    }
}

