/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures;

import ic2.core.platform.textures.Ic2Icons;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Sprites {

    public static class TextureEntry {
        String sheetID;
        int xMin;
        int xMax;
        int yMin;
        int yMax;

        public TextureEntry(String icon, int x, int y, int xM, int yM) {
            this.sheetID = icon;
            this.xMin = x;
            this.xMax = xM;
            this.yMin = y;
            this.yMax = yM;
        }

        @SideOnly(value=Side.CLIENT)
        public void load(TextureMap par1) {
            SpriteData sprite = Ic2Icons.iconIDToData.get(this.sheetID);
            for (int y = this.yMin; y < this.yMax; ++y) {
                for (int x = this.xMin; x < this.xMax; ++x) {
                    Ic2Icons.loadIcon(par1, sprite, x, y);
                }
            }
        }
    }

    public static class SpriteInfo {
        int maxX;
        int maxY;
        int spriteAmount;

        public SpriteInfo(int maxX, int maxY) {
            this.maxX = maxX;
            this.maxY = maxY;
            this.spriteAmount = maxX * maxY;
        }
    }

    public static class SpriteData {
        String spriteID;
        String texture;
        SpriteInfo info;

        public SpriteData(String spriteID, String texture, SpriteInfo info) {
            this.spriteID = spriteID;
            this.texture = texture;
            this.info = info;
        }
    }

    public static class SpecialEntry {
        String sheetID;
        int xCoord;
        int yCoord;
        int modify;

        public SpecialEntry(String icon, int x, int y, int mod) {
            this.sheetID = icon;
            this.xCoord = x;
            this.yCoord = y;
            this.modify = mod;
        }

        @SideOnly(value=Side.CLIENT)
        public void load(TextureMap par1) {
            Ic2Icons.loadSpecialIcon(par1, Ic2Icons.iconIDToData.get(this.sheetID), this.xCoord, this.yCoord, this.modify);
        }
    }
}

