/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures;

import ic2.core.block.crop.Ic2Crops;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.Sprites;
import ic2.core.platform.textures.SubIcon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SubIconManager {
    static Map<String, BufferedImage> sheetCache = new HashMap<String, BufferedImage>();

    public static TextureAtlasSprite getSubIcon(TextureMap map, int x, int y, Sprites.SpriteData data, int modfiy) {
        String name = "ic2:replacements/" + data.spriteID + "/" + data.spriteID + "x" + x + "y" + y;
        SubIcon icon = new SubIcon(name, data.texture, x + y * data.info.maxX, data.info, modfiy);
        map.setTextureEntry((TextureAtlasSprite)icon);
        return icon;
    }

    static BufferedImage loadSheet(IResourceManager manager, String sheet) throws Exception {
        try {
            InputStream stream = manager.func_110536_a(new ResourceLocation(sheet)).func_110527_b();
            if (stream == null) {
                throw new RuntimeException("Sheet not found: " + sheet);
            }
            return ImageIO.read(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ForgeEventHandler {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchPost(TextureStitchEvent.Post evt) {
            sheetCache.clear();
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchPre(TextureStitchEvent.Pre evt) {
            Ic2Icons.reset();
            Ic2Icons.load(evt.getMap());
            Ic2Crops.instance.loadTextures(evt.getMap());
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onModelBuilding(ModelBakeEvent evt) {
            Ic2Models.loadModels(evt);
        }
    }
}

