/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.events;

import ic2.api.classic.crops.ICropSoil;
import ic2.api.classic.crops.IFarmland;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ITerraformingBP;
import ic2.core.IC2;
import ic2.core.block.base.util.BasicFakeMachine;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.boat.EntityElectricBoat;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerHasGui;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.slots.SlotUpgrade;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import ic2.core.item.armor.electric.ItemArmorQuantumJetplate;
import ic2.core.item.armor.electric.ItemArmorQuantumNuclearJetplate;
import ic2.core.item.manager.GatewayElectricItemManager;
import ic2.core.item.upgrades.ItemUpgradeModul;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ElectricToolTipManager {
    public static DecimalFormat format = new DecimalFormat("#.##");
    public static int cancelState = 0;

    @SubscribeEvent
    public void onHitByLightning(EntityStruckByLightningEvent event) {
        if (!IC2.config.getFlag("SpecialElectricArmor")) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            IHasInventory inv;
            IBaublesPlugin plugin;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            int charge = 100000000;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack item;
                if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND || (item = player.func_184582_a(slot)) == null) continue;
                charge = (int)((double)charge - ElectricItem.manager.charge(item, charge, Integer.MAX_VALUE, true, false));
            }
            if (charge > 0 && (plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class)) != null && (inv = plugin.getBaublesInventory(player)) != null) {
                for (int i = 0; i < inv.getSlotCount(); ++i) {
                    ItemStack item = inv.getStackInSlot(i);
                    if (item == null) continue;
                    charge = (int)((double)charge - ElectricItem.manager.charge(item, charge, Integer.MAX_VALUE, true, false));
                }
            }
            if (charge > 0 && charge < 100000000 && !ItemElectricArmorBase.hasElectricBoots((EntityLivingBase)player)) {
                player.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)charge);
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiTooltipDrawn(RenderTooltipEvent.Pre event) {
        if (cancelState == 1) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGuiPostDrawFirst(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (cancelState == 2) {
            cancelState = 1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiPostDrawLast(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (cancelState == 1) {
            cancelState = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onToolEvent(ItemTooltipEvent evt) {
        GuiScreen screen;
        BasicFakeMachine machine;
        Object item;
        boolean euReader;
        Block block;
        EntityPlayer player;
        String tooltip;
        List text = evt.getToolTip();
        ItemStack tool = evt.getItemStack();
        if (tool == null || tool.func_190926_b()) {
            return;
        }
        IElectricItemManager manager = ((GatewayElectricItemManager)ElectricItem.manager).getManager(tool);
        if (manager != null && (tooltip = manager.getToolTip(tool)) != null) {
            text.add(1, TextFormatting.AQUA + tooltip);
        }
        if ((player = evt.getEntityPlayer()) == null) {
            return;
        }
        if (PlayerHandler.getClientPlayerHandler().hasCropanalyzer() && (block = Block.func_149634_a((Item)tool.func_77973_b())) != Blocks.field_150350_a) {
            try {
                IFarmland farm;
                IBlockState state = block.func_176203_a(tool.func_77973_b().func_77647_b(tool.func_77960_j()));
                ICropSoil soil = Ic2Crops.instance.getSoil(state);
                if (soil != null) {
                    text.add(TextFormatting.GREEN + Ic2Lang.soilData.getLocalizedFormatted(soil.getNutrientEffect(state), soil.getHumidityEffect(state)));
                    text.add(Ic2Lang.soilInfo.getLocalized());
                }
                if ((farm = Ic2Crops.instance.getFarmland(state)) != null) {
                    text.add(TextFormatting.GREEN + Ic2Lang.farmlandData.getLocalizedFormatted(farm.getNutrients(state), farm.getHumidity(state)));
                    text.add(Ic2Lang.farmlandInfo.getLocalized());
                }
            }
            catch (Exception state) {
                // empty catch block
            }
        }
        if (euReader = PlayerHandler.getClientPlayerHandler().hasEUReader()) {
            if (tool.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)tool.func_77973_b();
                text.add(2, Ic2InfoLang.electricTransferRate.getLocalizedFormatted((int)item.getTransferLimit(tool)));
                text.add(3, Ic2InfoLang.euTier.getLocalizedFormatted(item.getTier(tool)));
            }
            if (tool.func_77973_b() instanceof IMachineUpgradeItem) {
                item = (IMachineUpgradeItem)tool.func_77973_b();
                machine = new BasicFakeMachine(player);
                screen = Minecraft.func_71410_x().field_71462_r;
                try {
                    Set<IMachineUpgradeItem.UpgradeType> supported;
                    ContainerHasGui container;
                    IMachineUpgradeItem.UpgradeType type = item.getType(tool);
                    if (type != IMachineUpgradeItem.UpgradeType.RedstoneControl && type != IMachineUpgradeItem.UpgradeType.Sounds && type != IMachineUpgradeItem.UpgradeType.WorldInteraction) {
                        int size = GuiScreen.func_146271_m() ? tool.func_190916_E() : 1;
                        int extraProcessSpeed = 0;
                        double processingSpeedMultiplier = 1.0;
                        int extraProcessTime = 0;
                        double processTimeMultiplier = 1.0;
                        int extraEnergyDemand = 0;
                        double energyDemandMultiplier = 1.0;
                        int extraEnergyStorage = 0;
                        double energyStorageMultiplier = 1.0;
                        int extraTier = 0;
                        item.onInstalling(tool, machine);
                        extraProcessSpeed += item.getExtraProcessSpeed(tool, machine) * size;
                        processingSpeedMultiplier *= Math.pow(item.getProcessSpeedMultiplier(tool, machine), size);
                        extraProcessTime += item.getExtraProcessTime(tool, machine) * size;
                        processTimeMultiplier *= Math.pow(item.getProcessTimeMultiplier(tool, machine), size);
                        extraEnergyDemand += item.getExtraEnergyDemand(tool, machine) * size;
                        energyDemandMultiplier *= Math.pow(item.getEnergyDemandMultiplier(tool, machine), size);
                        extraEnergyStorage += item.getExtraEnergyStorage(tool, machine) * size;
                        energyStorageMultiplier *= Math.pow(item.getEnergyStorageMultiplier(tool, machine), size);
                        extraTier += item.getExtraTier(tool, machine) * size;
                        if (extraProcessSpeed != 0) {
                            text.add(Ic2InfoLang.upgradeSpeed.getLocalizedFormatted(extraProcessSpeed));
                        }
                        if (processingSpeedMultiplier != 1.0) {
                            text.add(Ic2InfoLang.upgradeSpeedModifier.getLocalizedFormatted(Ic2Formatters.stackFormat.format(processingSpeedMultiplier * 100.0) + "%"));
                        }
                        if (extraProcessTime != 0) {
                            text.add(Ic2InfoLang.upgradeRecipeTime.getLocalizedFormatted(extraProcessTime));
                        }
                        if (processTimeMultiplier != 1.0) {
                            text.add(Ic2InfoLang.upgradeRecipeTimeModifier.getLocalizedFormatted(Ic2Formatters.stackFormat.format(processTimeMultiplier * 100.0) + "%"));
                        }
                        if (extraEnergyDemand != 0) {
                            text.add(Ic2InfoLang.upgradeEnergyConsumtion.getLocalizedFormatted(extraEnergyDemand));
                        }
                        if (energyDemandMultiplier != 1.0) {
                            text.add(Ic2InfoLang.upgradeEnergyConsumtionModifier.getLocalizedFormatted(Ic2Formatters.stackFormat.format(energyDemandMultiplier * 100.0) + "%"));
                        }
                        if (extraEnergyStorage != 0) {
                            text.add(Ic2InfoLang.upgradeEnergyStorage.getLocalizedFormatted(extraEnergyStorage));
                        }
                        if (energyStorageMultiplier != 1.0) {
                            text.add(Ic2InfoLang.upgradeEnergyStorageModifier.getLocalizedFormatted(Ic2Formatters.stackFormat.format(energyStorageMultiplier * 100.0) + "%"));
                        }
                        if (extraTier != 0) {
                            String boni = extraTier > 0 ? "+" : "";
                            text.add(Ic2InfoLang.upgradeExtraEnergyTier.getLocalizedFormatted(boni + extraTier));
                        }
                        if (extraTier > 0 && screen instanceof GuiContainer && ((GuiContainer)screen).getSlotUnderMouse() instanceof SlotUpgrade) {
                            text.add(Ic2InfoLang.upgradeLockt.getLocalizedFormatted(IC2.keyboard.getKeyName(0)));
                        }
                    }
                    if (screen instanceof GuiComponentContainer && ((GuiComponentContainer)screen).field_147002_h instanceof ContainerHasGui && (container = (ContainerHasGui)((GuiComponentContainer)screen).field_147002_h).getGuiHolder() instanceof IMachine && (supported = ((IMachine)container.getGuiHolder()).getSupportedTypes()) != null && supported.contains((Object)type)) {
                        text.add(TextFormatting.GREEN + Ic2Lang.supportedUpgrades.getLocalized());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (tool.func_77973_b() instanceof ITerraformingBP) {
                item = (ITerraformingBP)tool.func_77973_b();
                text.add(Ic2InfoLang.tfbpCost.getLocalizedFormatted(item.getConsume(tool)));
                text.add(Ic2InfoLang.tfbpRange.getLocalizedFormatted(item.getRange(tool)));
            }
        } else if (tool.func_77973_b() instanceof IMachineUpgradeItem) {
            item = (IMachineUpgradeItem)tool.func_77973_b();
            machine = new BasicFakeMachine(player);
            try {
                if (item.getExtraTier(tool, machine) > 0 && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiContainer && ((GuiContainer)screen).getSlotUnderMouse() instanceof SlotUpgrade) {
                    text.add(Ic2InfoLang.upgradeLockt.getLocalizedFormatted(IC2.keyboard.getKeyName(0)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post evt) {
        Minecraft mc;
        RenderGameOverlayEvent.ElementType elementType = evt.getType();
        evt.getType();
        if (elementType != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            RenderGameOverlayEvent.ElementType elementType2 = evt.getType();
            evt.getType();
            if (elementType2 != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
                return;
            }
        }
        if ((mc = Minecraft.func_71410_x()) == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        RenderGameOverlayEvent.ElementType elementType3 = evt.getType();
        evt.getType();
        if (elementType3 == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            this.handleUpgradeSlot((EntityPlayer)player, mc, evt);
        }
        if (player.func_184187_bx() instanceof EntityElectricBoat) {
            this.handleElectricBoat((EntityElectricBoat)player.func_184187_bx(), (EntityPlayer)player, mc, evt);
            return;
        }
        this.handleNuclearJetpack((EntityPlayer)player, mc, evt);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleUpgradeSlot(EntityPlayer player, Minecraft mc, RenderGameOverlayEvent.Post evt) {
        ItemStack held = player.func_184614_ca();
        if (held == null) {
            held = player.func_184592_cb();
        }
        if (held == null || !(held.func_77973_b() instanceof ItemUpgradeModul)) {
            return;
        }
        ItemUpgradeModul mod = (ItemUpgradeModul)held.func_77973_b();
        if (!mod.usesFacing(held)) {
            return;
        }
        RayTraceResult object = mc.field_71476_x;
        if (object == null || object.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        EnumFacing side = object.field_178784_b;
        if (side == null) {
            return;
        }
        GlStateManager.func_179084_k();
        FontRenderer fontrenderer = mc.field_71466_p;
        ScaledResolution scaledresolution = evt.getResolution();
        int i = scaledresolution.func_78326_a();
        int b0 = scaledresolution.func_78328_b() - 110;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = Ic2Lang.getFacingComp(side).getLocalized();
        fontrenderer.func_175063_a(s, (float)(i / 2 - fontrenderer.func_78256_a(s) / 2), (float)(b0 - 2), 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    private void handleElectricBoat(EntityElectricBoat boat, EntityPlayer player, Minecraft mc, RenderGameOverlayEvent.Post evt) {
        float scale;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        boolean charge = GuiScreen.func_146271_m();
        float f = scale = charge ? boat.getCharge() : boat.getForce();
        if (!charge && (scale /= (float)(scale < 0.0f ? 2 : 4)) < 0.0f) {
            scale = -scale;
        }
        FontRenderer fontrenderer = mc.field_71466_p;
        ScaledResolution scaledresolution = evt.getResolution();
        int i = scaledresolution.func_78326_a();
        int short1 = 182;
        int j = i / 2 - short1 / 2;
        int k = (int)(scale * (float)(short1 + 1));
        int b0 = scaledresolution.func_78328_b() - 29;
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        if (k > 0) {
            this.drawTexturedModalRect(j, b0, 0, 79, k, 5, 0);
        }
        String s = (charge ? Ic2InfoLang.boatCharge : Ic2InfoLang.boatForce).getLocalizedFormatted(format.format(scale *= 100.0f) + "%");
        fontrenderer.func_175063_a(s, (float)(i / 2 - fontrenderer.func_78256_a(s) / 2), (float)(b0 - 2), 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleNuclearJetpack(EntityPlayer player, Minecraft mc, RenderGameOverlayEvent.Post evt) {
        ItemArmorJetpackBase pack;
        ItemStack item = player.field_71071_by.func_70440_f(2);
        if (item == null) {
            IHasInventory inv;
            IBaublesPlugin plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class);
            if (plugin != null && (inv = plugin.getBaublesInventory(player)) != null) {
                item = inv.getStackInSlot(plugin.getArmorSlot());
            }
            if (item == null) {
                return;
            }
        }
        boolean jetplate = item.func_77973_b() instanceof ItemArmorQuantumJetplate;
        boolean nJetplate = item.func_77973_b() instanceof ItemArmorQuantumNuclearJetplate;
        if (!(item.func_77973_b() instanceof ItemArmorJetpackBase || jetplate || nJetplate)) {
            return;
        }
        ItemArmorJetpackBase itemArmorJetpackBase = jetplate ? ((ItemArmorQuantumJetplate)item.func_77973_b()).jetpack : (pack = nJetplate ? ((ItemArmorQuantumNuclearJetplate)item.func_77973_b()).jetpack : (ItemArmorJetpackBase)item.func_77973_b());
        if (!pack.canDoRocketMode(item)) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getNbtData(item);
        if (!nbt.func_74767_n("RocketMode")) {
            return;
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int maxCharge = pack.getMaxRocketCharge(item);
        int charge = nbt.func_74762_e("UsedEnergy");
        float scale = (float)charge / (float)maxCharge;
        FontRenderer fontrenderer = mc.field_71466_p;
        ScaledResolution scaledresolution = evt.getResolution();
        int i = scaledresolution.func_78326_a();
        int short1 = 182;
        int j = i / 2 - short1 / 2;
        int k = (int)(scale * (float)(short1 + 1));
        int b0 = scaledresolution.func_78328_b() - 29;
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        if (k > 0) {
            this.drawTexturedModalRect(j, b0, 0, 79, k, 5, 0);
        }
        int per = (int)(scale * 100.0f);
        String s = Ic2InfoLang.rocketCharge.getLocalizedFormatted(per + "%");
        fontrenderer.func_175063_a(s, (float)(i / 2 - fontrenderer.func_78256_a(s) / 2), (float)(b0 - 2), 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

