/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.events;

import ic2.api.classic.wind.IWindHandler;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import ic2.core.item.armor.base.ItemIC2ShieldBase;
import ic2.core.network.packets.client.BeaconPacket;
import ic2.core.network.packets.server.ElytraPacket;
import ic2.core.platform.player.IC2Advancements;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Items;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEventHandlers {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getGui() instanceof GuiBeacon && event.getButton().field_146127_k == -1) {
            GuiBeacon gui = (GuiBeacon)event.getGui();
            IInventory inv = ((Slot)gui.field_147002_h.field_75151_b.get((int)0)).field_75224_c;
            if (!inv.func_70301_a(0).func_190926_b() && IC2.config.getFlag("nukeStuff")) {
                IC2.network.get(false).sendCustomPacket(new BeaconPacket(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
            }
        }
    }

    @SubscribeEvent
    public void onInventoryClosed(PlayerContainerEvent.Close close) {
        PlayerHandler handler = PlayerHandler.getHandlerForPlayer(close.getEntityPlayer());
        if (handler.watching != null) {
            handler.watching = null;
        }
    }

    @SubscribeEvent
    public void attackEvent(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        float amount = event.getAmount();
        DamageSource source = event.getSource();
        if (amount > 0.0f && this.canBlockDamageSource(source, entity)) {
            ItemStack active = entity.func_184607_cu();
            if (amount > 3.0f && active.func_77973_b() instanceof ItemIC2ShieldBase && entity instanceof EntityPlayer) {
                ((ItemIC2ShieldBase)active.func_77973_b()).damageShield(active, 1 + MathHelper.func_76141_d((float)amount), entity);
                if (active.func_190926_b()) {
                    EnumHand enumhand = entity.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)entity), (ItemStack)active, (EnumHand)enumhand);
                    entity.func_184201_a(enumhand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, (ItemStack)null);
                    entity.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    entity.func_184602_cy();
                }
            }
            if (source.func_76352_a()) {
                amount = 0.0f;
            } else {
                amount *= 0.33f;
                if (source.func_76346_g() instanceof EntityLivingBase) {
                    EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
                    attacker.func_70653_a((Entity)entity, 0.5f, entity.field_70165_t - source.func_76346_g().field_70165_t, entity.field_70161_v - source.func_76346_g().field_70161_v);
                    int thorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)active);
                    if (thorns > 0 && EnchantmentThorns.func_92094_a((int)thorns, (Random)attacker.func_70681_au())) {
                        attacker.func_70097_a(DamageSource.func_92087_a((Entity)entity), (float)EnchantmentThorns.func_92095_b((int)thorns, (Random)attacker.func_70681_au()));
                    }
                }
            }
            event.setCanceled(true);
        }
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn, EntityLivingBase entity) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityFallEvent(LivingFallEvent evt) {
        EntityLivingBase base = evt.getEntityLiving();
        if (IC2.platform.isSimulating() && base instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)base;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (stack.func_190926_b()) {
                return;
            }
            int fallDamage = (int)evt.getDistance() - 3;
            if (fallDamage >= 8 && stack.func_77973_b() != Ic2Items.quantumBoots.func_77973_b()) {
                return;
            }
            this.damageItem(stack, fallDamage, player, evt);
        }
    }

    public void damageItem(ItemStack stack, int fallDamage, EntityPlayer player, LivingFallEvent evt) {
        ItemElectricArmorBase base;
        int armorDamage;
        Item item = stack.func_77973_b();
        if (item == Ic2Items.hazmatBoots.func_77973_b()) {
            int armorDamage2 = (fallDamage + 1) / 2;
            if (armorDamage2 <= stack.func_77958_k() - stack.func_77952_i() && armorDamage2 >= 0) {
                stack.func_77972_a(armorDamage2, (EntityLivingBase)player);
                evt.setCanceled(true);
            }
        } else if ((item == Ic2Items.nanoBoots.func_77973_b() || item == Ic2Items.quantumBoots.func_77973_b()) && ElectricItem.manager.canUse(stack, armorDamage = (base = (ItemElectricArmorBase)item).getEnergyPerDamage() * fallDamage) && ElectricItem.manager.use(stack, armorDamage, (EntityLivingBase)player)) {
            evt.setCanceled(true);
        }
    }

    public static void onElytraTick(PlayerHandler handler) {
        EntityPlayer player = handler.getPlayer();
        if (!handler.windEffectsElytra) {
            return;
        }
        if (IC2.platform.isSimulating()) {
            float effect;
            if (player.func_184613_cA()) {
                IWindHandler windHandler = IC2.windManager.getHanlderFromWorld(player.func_130014_f_());
                float yaw = (player.field_70177_z + 360.0f) % 360.0f;
                float pitch = (180.0f - player.field_70125_A + 270.0f) % 360.0f;
                double windSpeed = windHandler.getWindStrenght(player.func_180425_c(), yaw, pitch);
                boolean negative = windSpeed < 0.0;
                double speed = Math.abs(windSpeed) / windHandler.getMaxWind();
                effect = (float)((double)0.01f * speed);
            } else {
                effect = 0.0f;
            }
            if (effect != handler.lastWindEffect) {
                handler.lastWindEffect = effect;
                IC2.network.get().sendCustomPacket(player, new ElytraPacket(effect));
            }
        } else if (player.func_184613_cA()) {
            if (handler.lastWindEffect != 0.0f) {
                player.func_191958_b(0.0f, 0.0f, 1.0f, handler.lastWindEffect);
            }
        } else if (handler.lastWindEffect != 0.0f) {
            handler.lastWindEffect = 0.0f;
        }
    }

    public static class StatAdvancementTracker {
        int ticker = 0;

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            ++this.ticker;
            if (this.ticker >= 20) {
                this.ticker = 0;
                for (EntityPlayerMP mp : IC2.platform.getServer().func_184103_al().func_181057_v()) {
                    IC2Advancements.STAT_CHANGE.onTrigger(mp);
                }
            }
        }

        @SubscribeEvent
        public void onEntityKilled(LivingDeathEvent event) {
            DamageSource source = event.getSource();
            if (source.func_76346_g() instanceof EntityPlayerMP) {
                IC2Advancements.PLAYER_KILLS.onTrigger((EntityPlayerMP)source.func_76346_g(), event.getEntity(), source);
            }
        }
    }

    public static class ElytraEventHandler {
        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
            if (evt.phase == TickEvent.Phase.START) {
                return;
            }
            EntityEventHandlers.onElytraTick(PlayerHandler.getHandlerForPlayer(evt.player));
        }
    }
}

