/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import ic2.core.RotationList;
import ic2.core.util.helpers.FilteredList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AabbUtil {
    public static int getBlockCount(World world, BlockPos start, int radius, IBlockFilter filter, boolean advFilter, boolean randomStart, RotationList rotations) {
        return AabbUtil.getTargets(world, start, radius, filter, advFilter, randomStart, rotations).size();
    }

    public static int getBlockCount(World world, BlockPos start, BoundingBox box, IBlockFilter filter, boolean advFilter, boolean randomStart, RotationList rotations) {
        return AabbUtil.getTargets(world, start, box, filter, advFilter, randomStart, false, rotations).size();
    }

    public static List<BlockPos> getTargets(World world, BlockPos start, int radius, IBlockFilter filter, boolean advFilter, boolean randomStart, RotationList rotations) {
        return AabbUtil.getTargets(world, start, new BoundingBox(start, radius), filter, advFilter, randomStart, false, rotations);
    }

    public static List<BlockPos> getTargets(World world, BlockPos start, int radius, IBlockFilter filter, boolean advFilter, RotationList rotations) {
        return AabbUtil.getTargets(world, start, new BoundingBox(start, radius), filter, advFilter, false, true, rotations);
    }

    public static List<BlockPos> getTargets(World world, BlockPos start, BoundingBox box, IBlockFilter filter, boolean advFilter, boolean randomStart, boolean allowInvalids, RotationList rotations) {
        FilteredList<BlockPos> targets = new FilteredList<BlockPos>();
        if (allowInvalids) {
            for (BlockPos pos : box) {
                if (!filter.forceChunkLoad() && !world.func_175668_a(pos, false) || (advFilter ? !filter.isValidBlock(world, pos) : !filter.isValidBlock(world.func_180495_p(pos)))) continue;
                targets.add(pos);
            }
        } else {
            FilteredList<BlockPos> visited = new FilteredList<BlockPos>();
            LinkedList<BlockPos> work = new LinkedList<BlockPos>();
            for (EnumFacing dir : rotations) {
                BlockPos pos = start.func_177972_a(dir);
                work.add(pos);
            }
            if (randomStart) {
                Collections.shuffle(work);
            }
            while (work.size() > 0) {
                BlockPos pos = (BlockPos)work.remove();
                if (!box.intersectsWith(pos) || visited.contains(pos) || !filter.forceChunkLoad() && !world.func_175668_a(pos, false)) continue;
                visited.add(pos);
                if (advFilter ? !filter.isValidBlock(world, pos) : !filter.isValidBlock(world.func_180495_p(pos))) continue;
                targets.add(pos);
                work.addAll(AabbUtil.getNeighboors(pos, rotations));
            }
        }
        return targets;
    }

    private static List<BlockPos> getNeighboors(BlockPos pos, RotationList rotations) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (EnumFacing dir : rotations) {
            list.add(pos.func_177972_a(dir));
        }
        return list;
    }

    public static class BoundingBox
    implements Iterable<BlockPos> {
        int minX;
        int minY;
        int minZ;
        int maxX;
        int maxY;
        int maxZ;

        public static BoundingBox buildOutOfList(Collection<BlockPos> list) {
            int xMin = Integer.MAX_VALUE;
            int yMin = Integer.MAX_VALUE;
            int zMin = Integer.MAX_VALUE;
            int xMax = Integer.MIN_VALUE;
            int yMax = Integer.MIN_VALUE;
            int zMax = Integer.MIN_VALUE;
            for (BlockPos pos : list) {
                xMin = Math.min(pos.func_177958_n(), xMin);
                yMin = Math.min(pos.func_177956_o(), yMin);
                zMin = Math.min(pos.func_177952_p(), zMin);
                xMax = Math.max(pos.func_177958_n(), xMax);
                yMax = Math.max(pos.func_177956_o(), yMax);
                zMax = Math.max(pos.func_177952_p(), zMax);
            }
            return new BoundingBox(xMin, yMin, zMin, xMax, yMax, zMax);
        }

        @SideOnly(value=Side.CLIENT)
        public BoundingBox(Vec3d pos, int range) {
            this(new BlockPos(pos), range);
        }

        public BoundingBox(BlockPos pos) {
            this(pos, pos);
        }

        public BoundingBox(BlockPos pos, int range) {
            this(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range, range, range));
        }

        public BoundingBox(BlockPos start, BlockPos end) {
            this.minX = Math.min(start.func_177958_n(), end.func_177958_n());
            this.minY = Math.min(start.func_177956_o(), end.func_177956_o());
            this.minZ = Math.min(start.func_177952_p(), end.func_177952_p());
            this.maxX = Math.max(start.func_177958_n(), end.func_177958_n());
            this.maxY = Math.max(start.func_177956_o(), end.func_177956_o());
            this.maxZ = Math.max(start.func_177952_p(), end.func_177952_p());
        }

        public BoundingBox(AxisAlignedBB box) {
            this((int)box.field_72340_a, (int)box.field_72338_b, (int)box.field_72339_c, (int)box.field_72336_d, (int)box.field_72337_e, (int)box.field_72334_f);
        }

        public BoundingBox(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
            this.minX = xMin;
            this.minY = yMin;
            this.minZ = zMin;
            this.maxX = xMax;
            this.maxY = yMax;
            this.maxZ = zMax;
        }

        public BoundingBox offset(BlockPos pos) {
            return new BoundingBox(this.minX + pos.func_177958_n(), this.minY + pos.func_177956_o(), this.minZ + pos.func_177952_p(), this.maxX + pos.func_177958_n(), this.maxY + pos.func_177956_o(), this.maxZ + pos.func_177952_p());
        }

        public BoundingBox applyOffset(BlockPos pos) {
            this.minX += pos.func_177958_n();
            this.minY += pos.func_177956_o();
            this.minZ += pos.func_177952_p();
            this.maxX += pos.func_177958_n();
            this.maxY += pos.func_177956_o();
            this.maxZ += pos.func_177952_p();
            return this;
        }

        public BoundingBox set(EnumFacing facing, int newValue) {
            switch (facing) {
                case UP: {
                    this.maxY = Math.max(this.minY, newValue);
                    break;
                }
                case DOWN: {
                    this.minY = Math.min(this.maxY, newValue);
                    break;
                }
                case EAST: {
                    this.minX = Math.min(this.maxX, newValue);
                    break;
                }
                case WEST: {
                    this.maxX = Math.max(this.minX, newValue);
                    break;
                }
                case NORTH: {
                    this.maxZ = Math.max(this.minZ, newValue);
                    break;
                }
                case SOUTH: {
                    this.minZ = Math.min(this.maxZ, newValue);
                }
            }
            return this;
        }

        public BoundingBox expand(EnumFacing dir, int amount) {
            switch (dir) {
                case UP: {
                    this.maxY += amount;
                    break;
                }
                case DOWN: {
                    this.minY -= amount;
                    break;
                }
                case SOUTH: {
                    this.maxZ += amount;
                    break;
                }
                case NORTH: {
                    this.minZ -= amount;
                    break;
                }
                case WEST: {
                    this.maxX += amount;
                    break;
                }
                case EAST: {
                    this.minX -= amount;
                }
            }
            return this;
        }

        public BoundingBox expandAxis(EnumFacing.Axis axis, int amount) {
            switch (axis) {
                case X: {
                    this.maxX += amount;
                    this.minX -= amount;
                    break;
                }
                case Y: {
                    this.maxY += amount;
                    this.minY -= amount;
                    break;
                }
                case Z: {
                    this.maxZ += amount;
                    this.minZ -= amount;
                }
            }
            return this;
        }

        public BoundingBox expandSide(EnumFacing side, int amount) {
            switch (side.func_176740_k()) {
                case X: {
                    this.maxY += amount;
                    this.minY -= amount;
                    this.maxZ += amount;
                    this.minZ -= amount;
                    break;
                }
                case Y: {
                    this.maxX += amount;
                    this.minX -= amount;
                    this.maxZ += amount;
                    this.minZ -= amount;
                    break;
                }
                case Z: {
                    this.maxX += amount;
                    this.minX -= amount;
                    this.maxY += amount;
                    this.minY -= amount;
                }
            }
            return this;
        }

        public int getBlocksInArea() {
            int x = Math.max(1, Math.abs(this.maxX - this.minX));
            int y = Math.max(1, Math.abs(this.maxY - this.minY));
            int z = Math.max(1, Math.abs(this.maxZ - this.minZ));
            return x * y * z;
        }

        public String toString() {
            return "X: [min: " + this.minX + ", max: " + this.maxX + "], Y: [min: " + this.minY + ", max: " + this.maxY + "], Z: " + this.minZ + ", max: " + this.maxZ + "]";
        }

        public boolean intersectsWith(BlockPos pos) {
            return pos.func_177958_n() >= this.minX && pos.func_177958_n() <= this.maxX && pos.func_177956_o() >= this.minY && pos.func_177956_o() <= this.maxY && pos.func_177952_p() >= this.minZ && pos.func_177952_p() <= this.maxZ;
        }

        public boolean intersetsWith(TileEntity tile) {
            return this.intersectsWith(tile.func_174877_v());
        }

        public boolean intersetsWith(Entity entity) {
            return this.intersectsWith(entity.func_180425_c());
        }

        public boolean boxColides(BoundingBox other) {
            return (other.minX >= this.minX && other.minX <= this.maxX || other.maxX >= this.minX && other.maxX <= this.maxX) && (other.minY >= this.minY && other.minY <= this.maxY || other.maxY >= this.minY && other.maxY <= this.maxY) && (other.minZ >= this.minZ && other.minZ <= this.maxZ || other.maxZ >= this.minZ && other.maxZ <= this.maxZ);
        }

        @Override
        public Iterator<BlockPos> iterator() {
            return new Iterator<BlockPos>(){
                int x;
                int y;
                int z;
                boolean hasNext;
                {
                    this.x = minX;
                    this.y = minY;
                    this.z = minZ;
                    this.hasNext = true;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public BlockPos next() {
                    BlockPos pos = new BlockPos(this.x, this.y, this.z);
                    if (++this.x > maxX) {
                        this.x = minX;
                        if (++this.y > maxY) {
                            this.y = minY;
                            if (++this.z > maxZ) {
                                this.z = minZ;
                                this.hasNext = false;
                            }
                        }
                    }
                    return pos;
                }

                @Override
                public void remove() {
                }
            };
        }

        public Iterable<BlockPos> getHollowIterator() {
            return new Iterable<BlockPos>(){

                @Override
                public Iterator<BlockPos> iterator() {
                    return new Iterator<BlockPos>(){
                        LinkedList<BlockPos> left = new LinkedList<BlockPos>(this.getList());

                        @Override
                        public boolean hasNext() {
                            return this.left.size() > 0;
                        }

                        @Override
                        public BlockPos next() {
                            return this.left.remove();
                        }

                        @Override
                        public void remove() {
                        }

                        private List<BlockPos> getList() {
                            LinkedList<BlockPos> list = new LinkedList<BlockPos>();
                            for (int x = minX; x <= maxX; ++x) {
                                for (int y = minY; y <= maxY; ++y) {
                                    for (int z = minZ; z <= maxZ; ++z) {
                                        if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                                        list.add(new BlockPos(x, y, z));
                                    }
                                }
                            }
                            return list;
                        }
                    };
                }
            };
        }
    }

    public static interface IBlockFilter {
        public boolean isValidBlock(IBlockState var1);

        public boolean isValidBlock(World var1, BlockPos var2);

        public boolean forceChunkLoad();
    }
}

