/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;

public class FilteredList<T>
extends ArrayList<T>
implements Set<T> {
    Set<T> entries;

    public FilteredList() {
        this.entries = new HashSet<T>();
    }

    public FilteredList(int size) {
        super(size);
        this.entries = new HashSet<T>(size);
    }

    public FilteredList(Collection<? extends T> c) {
        super(c);
        this.entries = new HashSet<T>(c);
        super.retainAll(this.entries);
    }

    @Override
    public boolean add(T e) {
        if (this.entries.add(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null) {
            return false;
        }
        ArrayList<T> adding = new ArrayList<T>(c.size());
        for (T data : c) {
            if (!this.entries.add(data)) continue;
            adding.add(data);
        }
        return super.addAll(adding) && adding.size() > 0;
    }

    public List<T> getAdded(Collection<? extends T> c) {
        if (c == null) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T data : c) {
            if (!this.entries.add(data)) continue;
            result.add(data);
        }
        super.addAll(result);
        return result;
    }

    @Override
    public T remove(int index) {
        Object data = super.remove(index);
        this.entries.remove(data);
        return (T)data;
    }

    @Override
    public boolean removeAll(Collection c) {
        this.entries.removeAll(c);
        return super.removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        this.entries.remove(o);
        return super.remove(o);
    }

    @Override
    public boolean retainAll(Collection c) {
        this.entries.retainAll(c);
        return super.retainAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.entries.containsAll(c);
    }

    @Override
    public void clear() {
        this.entries.clear();
        super.clear();
    }

    @Override
    public Spliterator<T> spliterator() {
        return super.spliterator();
    }
}

