/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc;

import ic2.api.classic.addon.IC2Plugin;
import ic2.api.classic.addon.IModul;
import ic2.api.classic.addon.misc.IOverrideObject;
import ic2.core.IC2;
import ic2.core.item.block.ItemBlockRare;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModulLoader {
    Map<String, Modul> modules = new LinkedHashMap<String, Modul>();

    public <T> T getPlugin(String id, Class<? extends T> clz) {
        Modul sub = this.modules.get(id);
        if (sub == null) {
            return null;
        }
        IModul modul = sub.getModul();
        if (clz.isInstance(modul)) {
            return (T)modul;
        }
        return null;
    }

    public void loadModules(ASMDataTable table) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        boolean hasResources = false;
        for (Modul entry : this.getCoreModule(table)) {
            IModul mod = entry.getModul();
            int version = entry.getPlugin().requiredAPIVersion();
            if (mod == null || version != 0 && version >= IC2.IC2_API_VERSION || !mod.canLoad(side) || !IC2.config.canLoadPlugin(entry.getPlugin().id())) continue;
            this.modules.put(entry.getPlugin().id(), entry);
            if (!entry.getPlugin().hasResourcePack()) continue;
            IC2.platform.loadPack(entry);
            hasResources = true;
        }
        if (hasResources) {
            IC2.platform.reloadLang();
        }
        IC2.platform.storeMods();
    }

    private List<Modul> getCoreModule(ASMDataTable table) {
        ArrayList<Modul> list = new ArrayList<Modul>();
        Set cases = table.getAll(IC2Plugin.class.getCanonicalName());
        for (ASMDataTable.ASMData data : cases) {
            try {
                Class<?> clz = Class.forName(data.getClassName());
                if (clz == null) continue;
                IC2Plugin plug = clz.getAnnotation(IC2Plugin.class);
                IC2.log.info("Loading Plugin: [name=" + plug.name() + ", version=" + plug.version() + "]");
                IModul modul = (IModul)clz.newInstance();
                if (modul == null) continue;
                list.add(new Modul(modul, plug, data.getCandidate().getModContainer()));
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public void fireEvent(Consumer<Modul> receiver) {
        Loader.instance();
        Loader loader = Loader.instance();
        ModContainer active = loader.activeModContainer();
        for (Modul mod : this.modules.values()) {
            ModContainer container = IC2.platform.getModData(mod, active);
            loader.setActiveModContainer(container);
            receiver.accept(mod);
        }
        loader.setActiveModContainer(active);
    }

    @SideOnly(value=Side.CLIENT)
    public void loadTextures() {
        for (Modul mod : this.modules.values()) {
            mod.getModul().onTextureLoad();
        }
    }

    public static class Modul {
        IModul modul;
        IC2Plugin plugin;
        File source;

        public Modul(IModul modul, IC2Plugin plugin, File source) {
            this.modul = modul;
            this.plugin = plugin;
            this.source = source;
        }

        public IModul getModul() {
            return this.modul;
        }

        public IC2Plugin getPlugin() {
            return this.plugin;
        }

        public File getSource() {
            return this.source;
        }
    }

    public static class ItemOverride
    implements IOverrideObject {
        Item item;

        public ItemOverride(Item override) {
            this.item = override;
        }

        @Override
        public Item getItem() {
            return this.item;
        }

        @Override
        public Block getBlock() {
            return null;
        }

        public Class<? extends ItemBlockRare> getItemBlock() {
            return null;
        }
    }

    public static class BlockOverride
    implements IOverrideObject {
        Block block;
        Class<? extends ItemBlockRare> itemBlock;

        public BlockOverride(Block par1) {
            this(par1, ItemBlockRare.class);
        }

        public BlockOverride(Block par1, Class<? extends ItemBlockRare> par2) {
            this.block = par1;
            this.itemBlock = par2;
        }

        @Override
        public Item getItem() {
            return null;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        public Class<? extends ItemBlockRare> getItemBlock() {
            return this.itemBlock;
        }
    }
}

