/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc;

import ic2.api.classic.util.IServerTickCallback;
import ic2.api.classic.util.ITickCallbackProvider;
import ic2.api.classic.util.IWorldTickCallback;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.world.World;

public class TickCallbackManager
implements ITickCallbackProvider {
    Map<World, Set<WorldTickContainer>> worldCallbacks = new HashMap<World, Set<WorldTickContainer>>();
    List<ServerTickContainer> serverCallbacks = new LinkedList<ServerTickContainer>();
    Map<World, Set<WorldTickContainer>> worldBacklog = new HashMap<World, Set<WorldTickContainer>>();
    List<ServerTickContainer> serverBacklog = new LinkedList<ServerTickContainer>();

    public void onWorldTick(World world) {
        Set<WorldTickContainer> backlog;
        if (world == null) {
            return;
        }
        Set<WorldTickContainer> container = this.worldCallbacks.get(world);
        Set<WorldTickContainer> preBacklog = this.worldBacklog.remove(world);
        if (preBacklog != null) {
            if (container == null) {
                container = new LinkedHashSet<WorldTickContainer>();
                this.worldCallbacks.put(world, container);
            }
            container.addAll(preBacklog);
        }
        if (container != null && container.size() > 0) {
            Iterator<WorldTickContainer> cont = container.iterator();
            while (cont.hasNext()) {
                if (!cont.next().handle(world)) continue;
                cont.remove();
            }
        }
        if ((backlog = this.worldBacklog.remove(world)) != null) {
            if (container == null) {
                container = new LinkedHashSet<WorldTickContainer>();
                this.worldCallbacks.put(world, container);
            }
            container.addAll(backlog);
        }
    }

    public void onServerTick() {
        if (this.serverBacklog.size() > 0) {
            this.serverCallbacks.addAll(this.serverBacklog);
            this.serverBacklog.clear();
        }
        if (this.serverCallbacks.size() > 0) {
            Iterator<ServerTickContainer> iter = this.serverCallbacks.iterator();
            while (iter.hasNext()) {
                if (!iter.next().handle()) continue;
                iter.remove();
            }
        }
        if (this.serverBacklog.size() > 0) {
            this.serverCallbacks.addAll(this.serverBacklog);
            this.serverBacklog.clear();
        }
    }

    @Override
    public void addCallback(World world, IWorldTickCallback par1, int delay) {
        Set<WorldTickContainer> callbacks = this.worldBacklog.get(world);
        if (callbacks == null) {
            callbacks = new LinkedHashSet<WorldTickContainer>();
            this.worldBacklog.put(world, callbacks);
        }
        callbacks.add(new WorldTickContainer(par1, delay));
    }

    @Override
    public void addCallback(IServerTickCallback par1, int delay) {
        this.serverBacklog.add(new ServerTickContainer(par1, delay));
    }

    @Override
    public void addCallback(World world, IWorldTickCallback par1) {
        this.addCallback(world, par1, 1);
    }

    @Override
    public void addCallback(IServerTickCallback par1) {
        this.addCallback(par1, 1);
    }

    public void onWorldUnload(World world) {
        this.worldCallbacks.remove(world);
        this.worldBacklog.remove(world);
    }

    public void onUnload() {
        this.worldCallbacks.clear();
        this.serverCallbacks.clear();
        this.serverBacklog.clear();
        this.worldBacklog.clear();
    }

    public static class WorldTickContainer {
        int delay;
        IWorldTickCallback callback;

        public WorldTickContainer(IWorldTickCallback par1, int time) {
            this.callback = par1;
            this.delay = time;
        }

        public boolean handle(World world) {
            --this.delay;
            if (this.delay <= 0) {
                try {
                    ActionResult<Integer> result = this.callback.tickCallback(world);
                    if (result == null || result.func_188397_a() != EnumActionResult.PASS || (Integer)result.func_188398_b() == 0) {
                        return true;
                    }
                    this.delay = (Integer)result.func_188398_b();
                }
                catch (Exception e) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ServerTickContainer {
        int delay;
        IServerTickCallback callback;

        public ServerTickContainer(IServerTickCallback par1, int time) {
            this.callback = par1;
            this.delay = time;
        }

        public boolean handle() {
            --this.delay;
            if (this.delay <= 0) {
                try {
                    ActionResult<Integer> result = this.callback.tickCallback();
                    if (result == null || result.func_188397_a() != EnumActionResult.PASS || (Integer)result.func_188398_b() == 0) {
                        return true;
                    }
                    this.delay = (Integer)result.func_188398_b();
                }
                catch (Exception e) {
                    return true;
                }
            }
            return false;
        }
    }
}

