/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntigration.core.machine.canner;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.jeiIntigration.core.machine.canner.CannerRecipeWrapper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class FoodCanRecipeWrapper
extends CannerRecipeWrapper {
    ItemStack input;
    ItemStack container;
    ItemStack output;

    public FoodCanRecipeWrapper(FoodEntry entry) {
        this.input = entry.getItem();
        int size = entry.getCanAmount();
        int meta = entry.getSubType();
        this.container = StackUtil.copyWithSize(Ic2Items.tinCan, size);
        this.output = StackUtil.copyWithDamageAndSize(Ic2Items.filledTinCan, meta, size);
    }

    @Override
    public List<ItemStack> getInput() {
        return Arrays.asList(this.input);
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    public static class FoodEntry {
        int amount;
        ItemStack ref;

        public FoodEntry(ItemFood item, ItemStack stack) {
            this.amount = (int)Math.ceil((double)item.func_150905_g(stack) / 2.0);
            this.ref = stack.func_77946_l();
        }

        public FoodEntry(int count, ItemStack stack) {
            this.amount = count;
            this.ref = stack.func_77946_l();
        }

        public ItemStack getItem() {
            return this.ref;
        }

        public int getCanAmount() {
            return this.amount;
        }

        public int getSubType() {
            return ClassicRecipes.canningMachine.getEffectForItem(this.ref);
        }
    }
}

