/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen.village.component;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.mod.blocks.BlockColoredLamp;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheColoredLampColors;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.gen.village.InitVillager;
import de.ellpeck.actuallyadditions.mod.gen.village.component.VillageComponentJamHouse;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCanolaPress;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoalGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCompost;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFermentingBarrel;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGrinder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillageComponentEngineerHouse
extends StructureVillagePieces.House1 {
    private static final ResourceLocation STRUCTURE_RES_LOC = new ResourceLocation("actuallyadditions", "andrew_period_house");
    private static final int X_SIZE = 13;
    private static final int Y_SIZE = 11;
    private static final int Z_SIZE = 10;
    private int averageGroundLevel = -1;

    public VillageComponentEngineerHouse() {
    }

    public VillageComponentEngineerHouse(StructureBoundingBox boundingBox, EnumFacing par5) {
        this.func_186164_a(par5);
        this.field_74887_e = boundingBox;
    }

    public static VillageComponentEngineerHouse buildComponent(List<StructureComponent> pieces, int p1, int p2, int p3, EnumFacing p4) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)13, (int)11, (int)10, (EnumFacing)p4);
        return VillageComponentEngineerHouse.func_74895_a((StructureBoundingBox)boundingBox) && StructureComponent.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null ? new VillageComponentEngineerHouse(boundingBox, p4) : null;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 11 - 2, 0);
        }
        this.fillWithBlocks(world, sbb, 0, 0, 0, 12, 10, 9, Blocks.field_150350_a);
        this.spawnActualHouse(world, sbb);
        this.fillHouse(world, sbb);
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.func_74871_b(world, i, 11, j, sbb);
                this.func_175808_b(world, Blocks.field_150346_d.func_176223_P(), i, -1, j, sbb);
            }
        }
        this.func_74893_a(world, sbb, 7, 4, 6, 1);
        return true;
    }

    private void fillWithBlocks(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block) {
        this.func_175804_a(world, sbb, minX, minY, minZ, maxX, maxY, maxZ, block.func_176223_P(), block.func_176223_P(), false);
    }

    private void fillHouse(World world, StructureBoundingBox sbb) {
        if (ConfigBoolValues.DUNGEON_LOOT.isEnabled()) {
            TileEntity reconstructor;
            TileEntity coal;
            TileEntity crusher;
            TileEntity press;
            TileEntity coffee;
            TileEntity ferment;
            TileEntityBase tile;
            TileEntity compost;
            if (world.field_73012_v.nextBoolean() && (compost = this.getTileAtPos(world, 6, 1, 2, sbb)) instanceof TileEntityCompost) {
                tile = (TileEntityCompost)compost;
                tile.stopFromDropping = true;
                tile.inv.setStackInSlot(0, new ItemStack(InitItems.itemFertilizer, 10));
            }
            if ((ferment = this.getTileAtPos(world, 11, 1, 0, sbb)) instanceof TileEntityFermentingBarrel) {
                tile = (TileEntityFermentingBarrel)ferment;
                ((TileEntityFermentingBarrel)tile).stopFromDropping = true;
                ((TileEntityFermentingBarrel)tile).canolaTank.setFluid(new FluidStack(InitFluids.fluidCanolaOil, world.field_73012_v.nextInt(1500) + 200));
            }
            if ((coffee = this.getTileAtPos(world, 4, 2, 6, sbb)) instanceof TileEntityCoffeeMachine) {
                TileEntityCoffeeMachine tile2 = (TileEntityCoffeeMachine)coffee;
                tile2.stopFromDropping = true;
                tile2.tank.setFluid(new FluidStack(FluidRegistry.WATER, world.field_73012_v.nextInt(3000) + 500));
                tile2.coffeeCacheAmount = world.field_73012_v.nextInt(150);
                tile2.storage.setEnergyStored(world.field_73012_v.nextInt(tile2.storage.getMaxEnergyStored() / 2));
            }
            if ((press = this.getTileAtPos(world, 2, 1, 5, sbb)) instanceof TileEntityCanolaPress) {
                TileEntityCanolaPress tile3 = (TileEntityCanolaPress)press;
                tile3.stopFromDropping = true;
                tile3.storage.setEnergyStored(world.field_73012_v.nextInt(tile3.storage.getMaxEnergyStored() / 3));
                tile3.inv.setStackInSlot(0, new ItemStack(InitItems.itemMisc, world.field_73012_v.nextInt(60) + 1, TheMiscItems.CANOLA.ordinal()));
            }
            if ((crusher = this.getTileAtPos(world, 2, 1, 6, sbb)) instanceof TileEntityGrinder) {
                TileEntityGrinder tile4 = (TileEntityGrinder)crusher;
                tile4.stopFromDropping = true;
                tile4.storage.setEnergyStored(world.field_73012_v.nextInt(tile4.storage.getMaxEnergyStored() / 2));
                if (world.field_73012_v.nextFloat() >= 0.25f) {
                    tile4.inv.setStackInSlot(0, new ItemStack(InitBlocks.blockMisc, world.field_73012_v.nextInt(10) + 1, TheMiscBlocks.ORE_QUARTZ.ordinal()));
                }
            }
            if ((coal = this.getTileAtPos(world, 5, 5, 6, sbb)) instanceof TileEntityCoalGenerator) {
                TileEntityCoalGenerator tile5 = (TileEntityCoalGenerator)coal;
                tile5.stopFromDropping = true;
                tile5.inv.setStackInSlot(0, new ItemStack(Items.field_151044_h, world.field_73012_v.nextInt(25) + 3, 1));
            }
            if ((reconstructor = this.getTileAtPos(world, 8, 4, 3, sbb)) instanceof TileEntityAtomicReconstructor) {
                ((TileEntityAtomicReconstructor)reconstructor).stopFromDropping = true;
            }
            VillageComponentJamHouse.generateCrate(world, sbb, this.func_74865_a(6, 4), this.func_74862_a(4), this.func_74873_b(6, 4), DungeonLoot.ENGINEER_HOUSE);
        }
        TileEntity firstRelay = this.getTileAtPos(world, 6, 5, 6, sbb);
        TileEntity secondRelay = this.getTileAtPos(world, 8, 5, 3, sbb);
        if (firstRelay instanceof TileEntityLaserRelayEnergy && secondRelay instanceof TileEntityLaserRelayEnergy) {
            ((TileEntityLaserRelayEnergy)firstRelay).stopFromDropping = true;
            ((TileEntityLaserRelayEnergy)secondRelay).stopFromDropping = true;
            ActuallyAdditionsAPI.connectionHandler.addConnection(firstRelay.func_174877_v(), secondRelay.func_174877_v(), LaserType.ENERGY, world);
        }
        int meta = world.field_73012_v.nextInt(TheColoredLampColors.values().length);
        this.func_175811_a(world, InitBlocks.blockColoredLampOn.func_176223_P().func_177226_a(BlockColoredLamp.TYPE, (Comparable)((Object)BlockColoredLamp.ALL_LAMP_TYPES[meta])), 8, 1, 6, sbb);
    }

    private void spawnActualHouse(World world, StructureBoundingBox sbb) {
        TemplateManager manager = world.func_72860_G().func_186340_h();
        MinecraftServer server = world.func_73046_m();
        if (manager != null && server != null) {
            Rotation rotation;
            Mirror mirror;
            EnumFacing facing = this.func_186165_e();
            if (facing == EnumFacing.SOUTH) {
                mirror = Mirror.NONE;
                rotation = Rotation.NONE;
            } else if (facing == EnumFacing.WEST) {
                mirror = Mirror.NONE;
                rotation = Rotation.CLOCKWISE_90;
            } else if (facing == EnumFacing.EAST) {
                mirror = Mirror.LEFT_RIGHT;
                rotation = Rotation.CLOCKWISE_90;
            } else {
                mirror = Mirror.LEFT_RIGHT;
                rotation = Rotation.NONE;
            }
            PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_186223_a(sbb);
            Template template = manager.func_186237_a(server, STRUCTURE_RES_LOC);
            if (template != null) {
                template.func_186253_b(world, new BlockPos(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0)), placement);
            }
        }
    }

    private TileEntity getTileAtPos(World world, int x, int y, int z, StructureBoundingBox sbb) {
        BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return InitVillager.engineerProfession;
    }
}

