/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.items.metalists.ThePotionRings;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingItem;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPotionRing
extends ItemBase
implements IColorProvidingItem,
IDisplayStandItem {
    public static final ThePotionRings[] ALL_RINGS = ThePotionRings.values();
    public static final int MAX_BLAZE = 800;
    private final boolean isAdvanced;

    public ItemPotionRing(boolean isAdvanced, String name) {
        super(name);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.isAdvanced = isAdvanced;
    }

    public static int getStoredBlaze(ItemStack stack) {
        if (!StackUtil.isValid(stack) || !stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("Blaze");
    }

    public static void setStoredBlaze(ItemStack stack, int amount) {
        if (StackUtil.isValid(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a("Blaze", amount);
        }
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double diff = 800 - ItemPotionRing.getStoredBlaze(stack);
        return diff / 800.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        int curr = ItemPotionRing.getStoredBlaze(stack);
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)curr / 800.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_77952_i() >= ALL_RINGS.length ? "actuallyadditions.lolWutHowUDoDis" : this.func_77658_a() + ItemPotionRing.ALL_RINGS[stack.func_77952_i()].name;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        super.func_77663_a(stack, world, player, par4, par5);
        if (!world.field_72995_K && stack.func_77952_i() < ALL_RINGS.length && player instanceof EntityPlayer) {
            EntityPlayer thePlayer = (EntityPlayer)player;
            int storedBlaze = ItemPotionRing.getStoredBlaze(stack);
            if (storedBlaze > 0) {
                ItemStack equippedStack = thePlayer.func_184614_ca();
                ItemStack offhandStack = thePlayer.func_184592_cb();
                if (this.effectEntity((EntityLivingBase)thePlayer, stack, StackUtil.isValid(equippedStack) && stack == equippedStack || StackUtil.isValid(offhandStack) && stack == offhandStack) && world.func_82737_E() % 10L == 0L) {
                    ItemPotionRing.setStoredBlaze(stack, storedBlaze - 1);
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public String func_77653_i(ItemStack stack) {
        if (Util.isClient()) {
            String standardName = StringUtil.localize(this.func_77658_a() + ".name");
            if (stack.func_77952_i() < ALL_RINGS.length) {
                String effect = StringUtil.localize(ItemPotionRing.ALL_RINGS[stack.func_77952_i()].name);
                return standardName + " " + effect;
            }
            return standardName;
        }
        String standardName = StringUtil.localizeIllegallyOnTheServerDontUseMePls(this.func_77658_a() + ".name");
        if (stack.func_77952_i() < ALL_RINGS.length) {
            String effect = StringUtil.localizeIllegallyOnTheServerDontUseMePls(ItemPotionRing.ALL_RINGS[stack.func_77952_i()].name);
            return standardName + " " + effect;
        }
        return standardName;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77952_i() >= ALL_RINGS.length ? EnumRarity.COMMON : ItemPotionRing.ALL_RINGS[stack.func_77952_i()].rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int j = 0; j < ALL_RINGS.length; ++j) {
                list.add((Object)new ItemStack((Item)this, 1, j));
                ItemStack full = new ItemStack((Item)this, 1, j);
                ItemPotionRing.setStoredBlaze(full, 800);
                list.add((Object)full);
            }
        }
    }

    @Override
    protected void registerRendering() {
        for (int i = 0; i < ALL_RINGS.length; ++i) {
            ActuallyAdditions.PROXY.addRenderRegister(new ItemStack((Item)this, 1, i), this.getRegistryName(), "inventory");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return stack.func_77952_i() >= ALL_RINGS.length ? 0xFFFFFF : ItemPotionRing.ALL_RINGS[stack.func_77952_i()].color;
            }
        };
    }

    @Override
    public boolean update(ItemStack stack, TileEntity tile, int elapsedTicks) {
        boolean advanced = ((ItemPotionRing)stack.func_77973_b()).isAdvanced;
        int range = advanced ? 48 : 16;
        List entities = tile.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(tile.func_174877_v().func_177958_n() - range), (double)(tile.func_174877_v().func_177956_o() - range), (double)(tile.func_174877_v().func_177952_p() - range), (double)(tile.func_174877_v().func_177958_n() + range), (double)(tile.func_174877_v().func_177956_o() + range), (double)(tile.func_174877_v().func_177952_p() + range)));
        if (entities != null && !entities.isEmpty()) {
            if (advanced) {
                for (EntityLivingBase entity : entities) {
                    this.effectEntity(entity, stack, true);
                }
                return true;
            }
            Potion potion = Potion.func_188412_a((int)ThePotionRings.values()[stack.func_77952_i()].effectID);
            for (EntityLivingBase entity : entities) {
                if (!entity.func_70644_a(potion)) continue;
                if (tile.func_145831_w().field_73012_v.nextInt(100) <= 0) {
                    entity.func_184589_d(potion);
                    break;
                }
                this.effectEntity(entity, stack, true);
                return true;
            }
            Collections.shuffle(entities);
            this.effectEntity((EntityLivingBase)entities.get(0), stack, true);
            return true;
        }
        return false;
    }

    @Override
    public int getUsePerTick(ItemStack stack, TileEntity tile, int elapsedTicks) {
        return 325;
    }

    private boolean effectEntity(EntityLivingBase thePlayer, ItemStack stack, boolean canUseBasic) {
        ThePotionRings effect = ThePotionRings.values()[stack.func_77952_i()];
        Potion potion = Potion.func_188412_a((int)effect.effectID);
        PotionEffect activeEffect = thePlayer.func_70660_b(potion);
        if (!effect.needsWaitBeforeActivating || activeEffect == null || activeEffect.func_76459_b() <= 1) {
            if (!((ItemPotionRing)stack.func_77973_b()).isAdvanced) {
                if (canUseBasic) {
                    thePlayer.func_70690_d(new PotionEffect(potion, effect.activeTime, effect.normalAmplifier, true, false));
                    return true;
                }
            } else {
                thePlayer.func_70690_d(new PotionEffect(potion, effect.activeTime, effect.advancedAmplifier, true, false));
                return true;
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(String.format("%d/%d %s", ItemPotionRing.getStoredBlaze(stack), 800, StringUtil.localize("item.actuallyadditions.item_misc_ring.storage")));
    }
}

